/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.MediaType;
import org.restlet.resource.ChannelRepresentation;
import org.restlet.util.ByteUtils;

public class ReadableRepresentation
extends ChannelRepresentation {
    private static final Logger logger = Logger.getLogger(ReadableRepresentation.class.getCanonicalName());
    private volatile ReadableByteChannel channel;

    public ReadableRepresentation(ReadableByteChannel readableChannel, MediaType mediaType) {
        this(readableChannel, mediaType, -1L);
    }

    public ReadableRepresentation(ReadableByteChannel channel, MediaType mediaType, long expectedSize) {
        super(mediaType);
        this.setSize(expectedSize);
        this.channel = channel;
        this.setAvailable(channel != null);
        this.setTransient(true);
    }

    public ReadableByteChannel getChannel() throws IOException {
        ReadableByteChannel result = this.channel;
        this.channel = null;
        this.setAvailable(false);
        return result;
    }

    public void release() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error while releasing the representation.", e);
            }
            this.channel = null;
        }
        super.release();
    }

    public void setChannel(ReadableByteChannel channel) {
        this.channel = channel;
    }

    public void write(WritableByteChannel writableChannel) throws IOException {
        ByteUtils.write(this.getChannel(), writableChannel);
    }
}

