/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.restlet.data.MediaType;
import org.restlet.resource.Representation;
import org.restlet.resource.XmlRepresentation;
import org.restlet.util.XmlWriter;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class SaxRepresentation
extends XmlRepresentation {
    private volatile SAXSource source;

    public SaxRepresentation(MediaType mediaType) {
        super(mediaType);
    }

    public SaxRepresentation(MediaType mediaType, Document xmlDocument) {
        super(mediaType);
        this.source = new SAXSource(SAXSource.sourceToInputSource(new DOMSource(xmlDocument)));
    }

    public SaxRepresentation(MediaType mediaType, InputSource xmlSource) {
        super(mediaType);
        this.source = new SAXSource(xmlSource);
    }

    public SaxRepresentation(MediaType mediaType, SAXSource xmlSource) {
        super(mediaType);
        this.source = xmlSource;
    }

    public SaxRepresentation(Representation xmlRepresentation) {
        super(xmlRepresentation.getMediaType());
        try {
            this.source = xmlRepresentation instanceof XmlRepresentation ? ((XmlRepresentation)xmlRepresentation).getSaxSource() : new SAXSource(new InputSource(xmlRepresentation.getStream()));
            if (xmlRepresentation.getIdentifier() != null) {
                this.source.setSystemId(xmlRepresentation.getIdentifier().getTargetRef().toString());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public Object evaluate(String expression, QName returnType) throws Exception {
        Object result = null;
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(this);
        if (this.source == null) {
            throw new Exception("Unable to obtain a DOM document for the SAX representation. XPath evaluation cancelled.");
        }
        Document document = this.getDocumentBuilder().parse(SAXSource.sourceToInputSource(this.source));
        result = xpath.evaluate(expression, document, returnType);
        return result;
    }

    public SAXSource getSaxSource() throws IOException {
        if (this.source == null) {
            return new SAXSource(new InputSource(this.getStream()));
        }
        return this.source;
    }

    public void parse(ContentHandler contentHandler) throws IOException {
        if (contentHandler != null) {
            try {
                SAXResult result = new SAXResult(contentHandler);
                TransformerFactory.newInstance().newTransformer().transform(this.source, result);
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Couldn't parse the source representation: " + tce.getMessage());
            }
            catch (TransformerException te) {
                te.printStackTrace();
                throw new IOException("Couldn't parse the source representation: " + te.getMessage());
            }
            catch (TransformerFactoryConfigurationError tfce) {
                throw new IOException("Couldn't parse the source representation: " + tfce.getMessage());
            }
        } else {
            throw new IOException("Couldn't parse the source representation: no content restlet defined.");
        }
    }

    public void release() {
        if (this.source != null) {
            this.source = null;
        }
        super.release();
    }

    public void setSaxSource(SAXSource source) {
        this.source = source;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(new XmlWriter(outputStream, this.getCharacterSet() == null ? "UTF-8" : this.getCharacterSet().toString()));
    }

    public void write(XmlWriter writer) throws IOException {
    }
}

