/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Directory;
import org.restlet.Guard;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Product;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.Variant;
import org.restlet.util.Helper;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Engine {
    private static volatile ClassLoader classloader = Engine.class.getClassLoader();
    private static volatile Engine instance = null;
    private static final Logger logger = Logger.getLogger(Engine.class.getCanonicalName());
    public static final String MAJOR_NUMBER = "1";
    public static final String MINOR_NUMBER = "1";
    private static final String providerResource = "META-INF/services/org.restlet.util.Engine";
    public static final String RELEASE_NUMBER = "m5";
    public static final String VERSION = "1.1.m5";

    public static Class<?> classForName(String classname) throws ClassNotFoundException {
        Class<?> result = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        result = loader != null ? Class.forName(classname, false, loader) : Class.forName(classname);
        return result;
    }

    public static ClassLoader getClassLoader() {
        return classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Engine getInstance() {
        Engine result = instance;
        if (result == null) {
            String engineClassName = null;
            ClassLoader cl = Engine.getClassLoader();
            URL configURL = cl.getResource(providerResource);
            if (configURL == null) {
                cl = Thread.currentThread().getContextClassLoader();
                configURL = cl.getResource(providerResource);
            }
            if (configURL == null) {
                cl = ClassLoader.getSystemClassLoader();
                configURL = cl.getResource(providerResource);
            }
            if (configURL != null) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(configURL.openStream(), "utf-8"));
                    String providerName = reader.readLine();
                    if (providerName != null) {
                        engineClassName = providerName.substring(0, providerName.indexOf(35)).trim();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Unable to register the Restlet API implementation. Please check that the JAR file is in your classpath.");
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            logger.warning("IOException encountered while closing an open BufferedReader" + e.getMessage());
                        }
                    }
                }
                try {
                    result = instance = (Engine)Class.forName(engineClassName).newInstance();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to register the Restlet API implementation", e);
                    throw new RuntimeException("Unable to register the Restlet API implementation");
                }
            }
            if (configURL == null) {
                logger.log(Level.SEVERE, "Unable to find an implementation of the Restlet API. Please check your classpath.");
            }
        }
        return result;
    }

    public static int hashCode(Object ... objects) {
        int result = 1;
        if (objects != null) {
            for (Object obj : objects) {
                result = 31 * result + (obj == null ? 0 : obj.hashCode());
            }
        }
        return result;
    }

    public static void setClassLoader(ClassLoader newClassloader) {
        classloader = newClassloader;
    }

    public static void setInstance(Engine engine) {
        instance = engine;
    }

    public abstract int authenticate(Request var1, Guard var2);

    public abstract void challenge(Response var1, boolean var2, Guard var3);

    public abstract void copyResponseHeaders(Iterable<Parameter> var1, Response var2, Logger var3);

    public abstract void copyResponseHeaders(Response var1, Series<Parameter> var2, Logger var3);

    public abstract Resource createDirectoryResource(Directory var1, Request var2, Response var3) throws IOException;

    public abstract Helper<Application> createHelper(Application var1);

    public abstract Helper<Client> createHelper(Client var1, String var2);

    public abstract Helper<Component> createHelper(Component var1);

    public abstract Helper<Server> createHelper(Server var1, String var2);

    public abstract void fireContextChanged(Restlet var1, Context var2);

    public abstract String formatCookie(Cookie var1) throws IllegalArgumentException;

    public abstract String formatCookieSetting(CookieSetting var1) throws IllegalArgumentException;

    public abstract String formatDimensions(Collection<Dimension> var1);

    public abstract String formatUserAgent(List<Product> var1) throws IllegalArgumentException;

    public abstract Variant getPreferredVariant(ClientInfo var1, List<Variant> var2, Language var3);

    public abstract void parse(Logger var1, Form var2, Representation var3);

    public abstract void parse(Logger var1, Form var2, String var3, CharacterSet var4, boolean var5, char var6);

    public abstract MediaType parseContentType(String var1) throws IllegalArgumentException;

    public abstract Cookie parseCookie(String var1) throws IllegalArgumentException;

    public abstract CookieSetting parseCookieSetting(String var1) throws IllegalArgumentException;

    public abstract List<Product> parseUserAgent(String var1) throws IllegalArgumentException;

    public abstract String toMd5(String var1);
}

