/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Finder;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Router;
import org.restlet.Server;
import org.restlet.VirtualHost;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.FileRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.service.LogService;
import org.restlet.service.StatusService;
import org.restlet.util.ClientList;
import org.restlet.util.Engine;
import org.restlet.util.Helper;
import org.restlet.util.ServerList;
import org.restlet.util.Template;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
extends Restlet {
    private final ClientList clients;
    private volatile VirtualHost defaultHost;
    private volatile Helper<Component> helper;
    private final List<VirtualHost> hosts = new CopyOnWriteArrayList<VirtualHost>();
    private volatile Router internalRouter;
    private volatile LogService logService;
    private final ServerList servers;
    private volatile StatusService statusService;

    public static void main(String[] args) throws Exception {
        try {
            if (args == null || args.length != 1) {
                System.err.println("Can't launch the component. Requires the path to an XML configuration file.\n");
            } else {
                new Component(LocalReference.createFileReference(args[0])).start();
            }
        }
        catch (Exception e) {
            System.err.println("Can't launch the component.\nAn unexpected exception occurred:");
            e.printStackTrace(System.err);
        }
    }

    public Component() {
        this.clients = new ClientList(null);
        this.servers = new ServerList(null, this);
        if (Engine.getInstance() != null) {
            this.helper = Engine.getInstance().createHelper(this);
            if (this.helper != null) {
                this.defaultHost = new VirtualHost(this.getContext());
                this.internalRouter = new Router(this.getContext().createChildContext()){

                    @Override
                    public Route attach(Restlet target) {
                        if (target.getContext() == null) {
                            target.setContext(this.getContext().createChildContext());
                        }
                        return super.attach(target);
                    }

                    @Override
                    public Route attach(String uriPattern, Restlet target) {
                        if (target.getContext() == null) {
                            target.setContext(this.getContext().createChildContext());
                        }
                        return super.attach(uriPattern, target);
                    }

                    @Override
                    public Route attachDefault(Restlet defaultTarget) {
                        if (defaultTarget.getContext() == null) {
                            defaultTarget.setContext(this.getContext().createChildContext());
                        }
                        return super.attachDefault(defaultTarget);
                    }

                    @Override
                    protected Finder createFinder(Class<? extends Resource> targetClass) {
                        Finder result = super.createFinder(targetClass);
                        result.setContext(this.getContext().createChildContext());
                        return result;
                    }
                };
                this.logService = new LogService(true);
                this.statusService = new StatusService(true);
                this.clients.setContext(this.getContext());
                this.servers.setContext(this.getContext());
            }
        }
    }

    public Component(Reference xmlConfigReference) {
        this();
        Representation xmlConfigRepresentation = null;
        if (xmlConfigReference != null) {
            Protocol protocol = xmlConfigReference.getSchemeProtocol();
            if (Protocol.FILE.equals(protocol)) {
                xmlConfigRepresentation = new FileRepresentation(new LocalReference(xmlConfigReference).getFile(), MediaType.TEXT_XML);
            } else {
                Response response = new Client(protocol).get(xmlConfigReference);
                if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                    xmlConfigRepresentation = response.getEntity();
                }
            }
        }
        if (xmlConfigRepresentation != null) {
            this.parseXmlConfiguration(xmlConfigRepresentation);
        } else {
            this.getLogger().log(Level.WARNING, "Unable to get the Component XML configuration located at this URI: " + xmlConfigReference);
        }
    }

    public Component(Representation xmlConfigRepresentation) {
        this();
        if (xmlConfigRepresentation != null) {
            this.parseXmlConfiguration(xmlConfigRepresentation);
        } else {
            this.getLogger().log(Level.WARNING, "Unable to parse the Component XML configuration.");
        }
    }

    private Route attach(Router router, String targetClassName, String uriPattern, boolean defaultRoute) {
        Route route;
        block11: {
            route = null;
            if (targetClassName != null) {
                try {
                    Class<?> targetClass = Engine.loadClass(targetClassName);
                    if (Resource.class.isAssignableFrom(targetClass)) {
                        Class<?> resourceClass = targetClass;
                        route = uriPattern != null && !defaultRoute ? router.attach(uriPattern, resourceClass) : router.attachDefault(resourceClass);
                        break block11;
                    }
                    Restlet target = null;
                    try {
                        target = (Restlet)targetClass.getConstructor(Context.class).newInstance(this.getContext().createChildContext());
                    }
                    catch (NoSuchMethodException e) {
                        this.getLogger().log(Level.FINE, "Couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of type Context. The empty constructor and the context setter will be used instead.", e);
                        target = (Restlet)targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        target.setContext(this.getContext().createChildContext());
                    }
                    if (target != null) {
                        route = uriPattern != null && !defaultRoute ? router.attach(uriPattern, target) : router.attachDefault(target);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't find the target class. Please check that your classpath includes " + targetClassName, e);
                }
                catch (InstantiationException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check this class has an empty constructor " + targetClassName, e);
                }
                catch (IllegalAccessException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check that you have to proper access rights to " + targetClassName, e);
                }
                catch (NoSuchMethodException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of Context " + targetClassName, e);
                }
                catch (InvocationTargetException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. An exception was thrown while creating " + targetClassName, e);
                }
            }
        }
        return route;
    }

    private Route attachWithDescriptor(Router router, String targetDescriptor, String uriPattern, boolean defaultRoute) {
        Route route = null;
        String targetClassName = null;
        try {
            targetClassName = "org.restlet.ext.wadl.WadlApplication";
            Class<?> targetClass = Engine.loadClass(targetClassName);
            Response response = this.getContext().getClientDispatcher().get(targetDescriptor);
            if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                Representation representation = response.getEntity();
                Application target = (Application)targetClass.getConstructor(Context.class, Representation.class).newInstance(this.getContext().createChildContext(), representation);
                if (target != null) {
                    route = uriPattern != null && !defaultRoute ? router.attach(uriPattern, target) : router.attachDefault(target);
                }
            } else {
                this.getLogger().log(Level.WARNING, "The target descriptor has not been found or is not available, or no client supporting the URI's protocol has been defined on this component. " + targetDescriptor);
            }
        }
        catch (ClassNotFoundException e) {
            this.getLogger().log(Level.WARNING, "Couldn't find the target class. Please check that your classpath includes " + targetClassName, e);
        }
        catch (InstantiationException e) {
            this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check this class has an empty constructor " + targetClassName, e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check that you have to proper access rights to " + targetClassName, e);
        }
        catch (NoSuchMethodException e) {
            this.getLogger().log(Level.WARNING, "Couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of Context " + targetClassName, e);
        }
        catch (InvocationTargetException e) {
            this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. An exception was thrown while creating " + targetClassName, e);
        }
        return route;
    }

    private boolean getBoolean(Node node, boolean defaultValue) {
        boolean value = defaultValue;
        if (node != null) {
            try {
                value = Boolean.parseBoolean(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public ClientList getClients() {
        return this.clients;
    }

    public VirtualHost getDefaultHost() {
        return this.defaultHost;
    }

    private float getFloat(Node node, float defaultValue) {
        float value = defaultValue;
        if (node != null) {
            try {
                value = Float.parseFloat(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    private Helper<Component> getHelper() {
        return this.helper;
    }

    public List<VirtualHost> getHosts() {
        return this.hosts;
    }

    private int getInt(Node node, int defaultValue) {
        int value = defaultValue;
        if (node != null) {
            try {
                value = Integer.parseInt(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public Router getInternalRouter() {
        return this.internalRouter;
    }

    public LogService getLogService() {
        return this.logService;
    }

    private long getLong(Node node, long defaultValue) {
        long value = defaultValue;
        if (node != null) {
            try {
                value = Long.parseLong(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    private Protocol getProtocol(String scheme) {
        Protocol protocol = Protocol.valueOf(scheme);
        if (protocol == null) {
            protocol = new Protocol(scheme);
        }
        return protocol;
    }

    public ServerList getServers() {
        return this.servers;
    }

    public StatusService getStatusService() {
        return this.statusService;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    private void parseHost(VirtualHost host, Node hostNode) {
        this.parseRouter(host, hostNode);
        Node item = hostNode.getAttributes().getNamedItem("hostDomain");
        if (item != null && item.getNodeValue() != null) {
            host.setHostDomain(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("hostPort")) != null && item.getNodeValue() != null) {
            host.setHostPort(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("hostScheme")) != null && item.getNodeValue() != null) {
            host.setHostScheme(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("name")) != null && item.getNodeValue() != null) {
            host.setName(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("resourceDomain")) != null && item.getNodeValue() != null) {
            host.setResourceDomain(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("resourcePort")) != null && item.getNodeValue() != null) {
            host.setResourcePort(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("resourceScheme")) != null && item.getNodeValue() != null) {
            host.setResourceScheme(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("serverAddress")) != null && item.getNodeValue() != null) {
            host.setServerAddress(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("serverPort")) != null && item.getNodeValue() != null) {
            host.setServerPort(item.getNodeValue());
        }
        this.setAttach(host, hostNode);
    }

    private void parseRouter(Router router, Node routerNode) {
        Node item = routerNode.getAttributes().getNamedItem("defaultMatchingMode");
        if (item != null) {
            this.getInternalRouter().setDefaultMatchingMode(this.getInt(item, this.getInternalRouter().getDefaultMatchingMode()));
        }
        if ((item = routerNode.getAttributes().getNamedItem("defaultMatchingQuery")) != null) {
            this.getInternalRouter().setDefaultMatchQuery(this.getBoolean(item, this.getInternalRouter().getDefaultMatchQuery()));
        }
        if ((item = routerNode.getAttributes().getNamedItem("maxAttempts")) != null) {
            this.getInternalRouter().setMaxAttempts(this.getInt(item, this.getInternalRouter().getMaxAttempts()));
        }
        if ((item = routerNode.getAttributes().getNamedItem("routingMode")) != null) {
            this.getInternalRouter().setRoutingMode(this.getInt(item, this.getInternalRouter().getRoutingMode()));
        }
        if ((item = routerNode.getAttributes().getNamedItem("requiredScore")) != null) {
            this.getInternalRouter().setRequiredScore(this.getFloat(item, this.getInternalRouter().getRequiredScore()));
        }
        if ((item = routerNode.getAttributes().getNamedItem("retryDelay")) != null) {
            this.getInternalRouter().setRetryDelay(this.getLong(item, this.getInternalRouter().getRetryDelay()));
        }
        this.setAttach(this.getInternalRouter(), routerNode);
    }

    private void parseXmlConfiguration(Representation xmlConfigRepresentation) {
        block30: {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(false);
                dbf.setValidating(false);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(xmlConfigRepresentation.getStream());
                if ("component".equals(document.getFirstChild().getNodeName())) {
                    NodeList childNodes = document.getFirstChild().getChildNodes();
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node item;
                        Node childNode = childNodes.item(i);
                        if ("client".equals(childNode.getNodeName())) {
                            item = childNode.getAttributes().getNamedItem("protocol");
                            Client client = null;
                            if (item == null) {
                                item = childNode.getAttributes().getNamedItem("protocols");
                                if (item != null) {
                                    String[] protocols = item.getNodeValue().split(" ");
                                    ArrayList<Protocol> protocolsList = new ArrayList<Protocol>();
                                    for (String protocol : protocols) {
                                        protocolsList.add(this.getProtocol(protocol));
                                    }
                                    client = new Client(new Context(), protocolsList);
                                }
                            } else {
                                client = new Client(new Context(), this.getProtocol(item.getNodeValue()));
                            }
                            if (client == null) continue;
                            this.getClients().add(client);
                            for (int j = 0; j < childNode.getChildNodes().getLength(); ++j) {
                                Node childNode2 = childNode.getChildNodes().item(j);
                                if (!"parameter".equals(childNode2.getNodeName())) continue;
                                Node nameNode = childNode2.getAttributes().getNamedItem("name");
                                Node valueNode = childNode2.getAttributes().getNamedItem("value");
                                if (nameNode == null || valueNode == null) continue;
                                client.getContext().getParameters().add(nameNode.getNodeValue(), valueNode.getNodeValue());
                            }
                            continue;
                        }
                        if ("server".equals(childNode.getNodeName())) {
                            String address;
                            item = childNode.getAttributes().getNamedItem("protocol");
                            Node portNode = childNode.getAttributes().getNamedItem("port");
                            Node addressNode = childNode.getAttributes().getNamedItem("address");
                            Server server = null;
                            if (item == null) {
                                item = childNode.getAttributes().getNamedItem("protocols");
                                if (item != null) {
                                    String[] protocols = item.getNodeValue().split(" ");
                                    ArrayList<Protocol> protocolsList = new ArrayList<Protocol>();
                                    for (String protocol : protocols) {
                                        protocolsList.add(this.getProtocol(protocol));
                                    }
                                    int port = this.getInt(portNode, -1);
                                    if (port == -1) {
                                        this.getLogger().warning("Please specify a port when defining a list of protocols.");
                                    } else {
                                        server = new Server(new Context(), protocolsList, this.getInt(portNode, -1), this.getServers().getTarget());
                                    }
                                }
                            } else {
                                Protocol protocol = this.getProtocol(item.getNodeValue());
                                server = new Server(new Context(), protocol, this.getInt(portNode, protocol.getDefaultPort()), this.getServers().getTarget());
                            }
                            if (server == null) continue;
                            if (addressNode != null && (address = addressNode.getNodeValue()) != null) {
                                server.setAddress(address);
                            }
                            for (int j = 0; j < childNode.getChildNodes().getLength(); ++j) {
                                Node childNode2 = childNode.getChildNodes().item(j);
                                if (!"parameter".equals(childNode2.getNodeName())) continue;
                                Node nameNode = childNode2.getAttributes().getNamedItem("name");
                                Node valueNode = childNode2.getAttributes().getNamedItem("value");
                                if (nameNode == null || valueNode == null) continue;
                                server.getContext().getParameters().add(nameNode.getNodeValue(), valueNode.getNodeValue());
                            }
                            this.getServers().add(server);
                            continue;
                        }
                        if ("defaultHost".equals(childNode.getNodeName())) {
                            this.parseHost(this.getDefaultHost(), childNode);
                            continue;
                        }
                        if ("host".equals(childNode.getNodeName())) {
                            VirtualHost host = new VirtualHost(this.getContext());
                            this.parseHost(host, childNode);
                            this.getHosts().add(host);
                            continue;
                        }
                        if ("parameter".equals(childNode.getNodeName())) {
                            Node nameNode = childNode.getAttributes().getNamedItem("name");
                            Node valueNode = childNode.getAttributes().getNamedItem("value");
                            if (nameNode == null || valueNode == null) continue;
                            this.getContext().getParameters().add(nameNode.getNodeValue(), valueNode.getNodeValue());
                            continue;
                        }
                        if ("internalRouter".equals(childNode.getNodeName())) {
                            this.parseRouter(this.getInternalRouter(), childNode);
                            continue;
                        }
                        if ("logService".equals(childNode.getNodeName())) {
                            item = childNode.getAttributes().getNamedItem("logFormat");
                            if (item != null) {
                                this.getLogService().setLogFormat(item.getNodeValue());
                            }
                            if ((item = childNode.getAttributes().getNamedItem("loggerName")) != null) {
                                this.getLogService().setLoggerName(item.getNodeValue());
                            }
                            if ((item = childNode.getAttributes().getNamedItem("enabled")) != null) {
                                this.getLogService().setEnabled(this.getBoolean(item, true));
                            }
                            if ((item = childNode.getAttributes().getNamedItem("identityCheck")) == null) continue;
                            this.getLogService().setIdentityCheck(this.getBoolean(item, true));
                            continue;
                        }
                        if (!"statusService".equals(childNode.getNodeName())) continue;
                        item = childNode.getAttributes().getNamedItem("contactEmail");
                        if (item != null) {
                            this.getStatusService().setContactEmail(item.getNodeValue());
                        }
                        if ((item = childNode.getAttributes().getNamedItem("enabled")) != null) {
                            this.getStatusService().setEnabled(this.getBoolean(item, true));
                        }
                        if ((item = childNode.getAttributes().getNamedItem("homeRef")) != null) {
                            this.getStatusService().setHomeRef(new Reference(item.getNodeValue()));
                        }
                        if ((item = childNode.getAttributes().getNamedItem("overwrite")) == null) continue;
                        this.getStatusService().setOverwrite(this.getBoolean(item, true));
                    }
                    break block30;
                }
                this.getLogger().log(Level.WARNING, "Unable to find the root \"component\" node in the XML configuration.");
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Unable to parse the Component XML configuration.", e);
            }
        }
    }

    private void setAttach(Router router, Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!"attach".equals(childNode.getNodeName())) continue;
            String uriPattern = null;
            Node item = childNode.getAttributes().getNamedItem("uriPattern");
            uriPattern = item != null ? item.getNodeValue() : "";
            item = childNode.getAttributes().getNamedItem("default");
            boolean bDefault = this.getBoolean(item, false);
            Route route = null;
            item = childNode.getAttributes().getNamedItem("targetClass");
            if (item != null) {
                route = this.attach(router, item.getNodeValue(), uriPattern, bDefault);
            } else {
                item = childNode.getAttributes().getNamedItem("targetDescriptor");
                if (item != null) {
                    route = this.attachWithDescriptor(router, item.getNodeValue(), uriPattern, bDefault);
                } else {
                    this.getLogger().log(Level.WARNING, "Both targetClass name and targetDescriptor are missing. Couldn't attach a new route.");
                }
            }
            if (route == null) continue;
            Template template = route.getTemplate();
            item = childNode.getAttributes().getNamedItem("matchingMode");
            template.setMatchingMode(this.getInt(item, 1));
            item = childNode.getAttributes().getNamedItem("defaultVariableType");
            template.getDefaultVariable().setType(this.getInt(item, 10));
        }
    }

    public synchronized void setClients(ClientList clients) {
        this.clients.clear();
        if (clients != null) {
            this.clients.addAll(clients);
        }
    }

    public void setDefaultHost(VirtualHost defaultHost) {
        this.defaultHost = defaultHost;
    }

    public synchronized void setHosts(List<VirtualHost> hosts) {
        this.hosts.clear();
        if (hosts != null) {
            this.hosts.addAll(hosts);
        }
    }

    public void setInternalRouter(Router internalRouter) {
        this.internalRouter = internalRouter;
    }

    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    public synchronized void setServers(ServerList servers) {
        this.servers.clear();
        if (servers != null) {
            this.servers.addAll(servers);
        }
    }

    public void setStatusService(StatusService statusService) {
        this.statusService = statusService;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            this.startClients();
            this.startServers();
            this.startHelper();
            this.startServices();
            super.start();
        }
    }

    protected synchronized void startClients() throws Exception {
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.start();
            }
        }
    }

    protected synchronized void startHelper() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().start();
        }
    }

    protected synchronized void startServers() throws Exception {
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.start();
            }
        }
    }

    protected synchronized void startServices() throws Exception {
        if (this.getLogService() != null) {
            this.getLogService().start();
        }
        if (this.getStatusService() != null) {
            this.getStatusService().start();
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        this.stopHelper();
        this.stopServers();
        this.stopClients();
        this.stopServices();
        super.stop();
    }

    protected synchronized void stopClients() throws Exception {
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.stop();
            }
        }
    }

    protected synchronized void stopHelper() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().stop();
        }
    }

    protected synchronized void stopServers() throws Exception {
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.stop();
            }
        }
    }

    protected synchronized void stopServices() throws Exception {
        if (this.getLogService() != null) {
            this.getLogService().stop();
        }
        if (this.getStatusService() != null) {
            this.getStatusService().stop();
        }
    }

    public synchronized void updateHosts() throws Exception {
        this.getHelper().update();
    }
}

