/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.util.Engine;
import org.restlet.util.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Guard
extends Filter {
    public static final int AUTHENTICATION_INVALID = -1;
    public static final int AUTHENTICATION_MISSING = 0;
    public static final int AUTHENTICATION_STALE = 2;
    public static final int AUTHENTICATION_VALID = 1;
    public static final long DEFAULT_NONCE_LIFESPAN_MILLIS = 300000L;
    private volatile Collection<String> domainUris = Collections.singleton("/");
    private volatile long nonceLifespan = 300000L;
    private volatile String realm;
    private volatile boolean rechallengeEnabled;
    private volatile ChallengeScheme scheme;
    private volatile Resolver<char[]> secretResolver;
    private final ConcurrentMap<String, char[]> secrets;
    private volatile String serverKey = "serverKey";

    public Guard(Context context, ChallengeScheme scheme, String realm) throws IllegalArgumentException {
        super(context);
        if (scheme == null) {
            throw new IllegalArgumentException("Please specify an authentication scheme. Use the 'None' challenge if no authentication is required.");
        }
        this.rechallengeEnabled = true;
        this.secretResolver = new Resolver<char[]>(){

            @Override
            public char[] resolve(String identifier) {
                return (char[])Guard.this.getSecrets().get(identifier);
            }
        };
        this.secrets = new ConcurrentHashMap<String, char[]>();
        this.scheme = scheme;
        this.realm = realm;
    }

    public Guard(Context context, String realm, Collection<String> baseUris, String serverKey) {
        this(context, ChallengeScheme.HTTP_DIGEST, realm);
        this.domainUris = baseUris;
        this.serverKey = serverKey;
    }

    public void accept(Request request, Response response) {
        super.doHandle(request, response);
    }

    public int authenticate(Request request) {
        return Engine.getInstance().authenticate(request, this);
    }

    public boolean authorize(Request request) {
        return true;
    }

    @Deprecated
    public void challenge(Response response) {
        this.challenge(response, false);
    }

    public void challenge(Response response, boolean stale) {
        Engine.getInstance().challenge(response, stale, this);
    }

    public boolean checkSecret(Request request, String identifier, char[] secret) {
        return this.checkSecret(identifier, secret);
    }

    @Deprecated
    protected boolean checkSecret(String identifier, char[] secret) {
        boolean result = false;
        char[] secret2 = this.findSecret(identifier);
        if (secret == null || secret2 == null) {
            result = secret == secret2;
        } else if (secret.length == secret2.length) {
            boolean equals = true;
            for (int i = 0; i < secret.length && equals; ++i) {
                equals = secret[i] == secret2[i];
            }
            result = equals;
        }
        return result;
    }

    @Override
    public int doHandle(Request request, Response response) {
        boolean loggable = this.getLogger().isLoggable(Level.FINE);
        switch (this.authenticate(request)) {
            case 1: {
                ChallengeResponse challengeResponse = request.getChallengeResponse();
                if (loggable) {
                    if (challengeResponse != null) {
                        this.getLogger().fine("Authentication succeeded. Valid credentials provided for identifier: " + request.getChallengeResponse().getIdentifier() + ".");
                    } else {
                        this.getLogger().fine("Authentication succeeded. Valid credentials provided.");
                    }
                }
                if (this.authorize(request)) {
                    if (loggable) {
                        if (challengeResponse != null) {
                            this.getLogger().fine("Request authorized for identifier: " + request.getChallengeResponse().getIdentifier() + ".");
                        } else {
                            this.getLogger().fine("Request authorized.");
                        }
                    }
                    this.accept(request, response);
                    break;
                }
                if (loggable) {
                    if (challengeResponse != null) {
                        this.getLogger().fine("Request not authorized for identifier: " + request.getChallengeResponse().getIdentifier() + ".");
                    } else {
                        this.getLogger().fine("Request not authorized.");
                    }
                }
                this.forbid(response);
                break;
            }
            case 0: {
                if (loggable) {
                    this.getLogger().fine("Authentication failed. No credentials provided.");
                }
                this.challenge(response, false);
                break;
            }
            case -1: {
                if (loggable) {
                    this.getLogger().fine("Authentication failed. Invalid credentials provided.");
                }
                if (this.isRechallengeEnabled()) {
                    this.challenge(response, false);
                    break;
                }
                this.forbid(response);
                break;
            }
            case 2: {
                if (loggable) {
                    this.getLogger().fine("Authentication failed. Stale credentials provided.");
                }
                this.challenge(response, true);
            }
        }
        return 0;
    }

    public char[] findSecret(String identifier) {
        return this.getSecretResolver().resolve(identifier);
    }

    public void forbid(Response response) {
        response.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
    }

    public Collection<String> getDomainUris() {
        return this.domainUris;
    }

    public long getNonceLifespan() {
        return this.nonceLifespan;
    }

    public String getRealm() {
        return this.realm;
    }

    public ChallengeScheme getScheme() {
        return this.scheme;
    }

    public Resolver<char[]> getSecretResolver() {
        return this.secretResolver;
    }

    public ConcurrentMap<String, char[]> getSecrets() {
        return this.secrets;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public boolean isRechallengeEnabled() {
        return this.rechallengeEnabled;
    }

    public void setDomainUris(Collection<String> domainUris) {
        this.domainUris = domainUris;
    }

    public void setNonceLifespan(long lifespan) {
        this.nonceLifespan = lifespan;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setRechallengeEnabled(boolean rechallengeEnabled) {
        this.rechallengeEnabled = rechallengeEnabled;
    }

    public void setScheme(ChallengeScheme scheme) {
        this.scheme = scheme;
    }

    public void setSecretResolver(Resolver<char[]> secretResolver) {
        this.secretResolver = secretResolver;
    }

    public void setServerKey(String serverKey) {
        this.serverKey = serverKey;
    }
}

