/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.rest.ch7;

import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.example.book.rest.ch7.Bookmark;
import org.restlet.example.book.rest.ch7.UserResource;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;

public class BookmarksResource
extends UserResource {
    @Override
    public void doInit() {
        super.doInit();
        this.getVariants().clear();
        if (this.getUser() != null) {
            this.getVariants().add(new Variant(MediaType.TEXT_HTML));
        }
    }

    @Override
    public Representation get(Variant variant) throws ResourceException {
        Representation result = null;
        if (variant.getMediaType().equals((Object)MediaType.TEXT_HTML)) {
            int code = this.checkAuthorization();
            ReferenceList rl = new ReferenceList();
            for (Bookmark bookmark : this.getUser().getBookmarks()) {
                if (bookmark.isRestricting() && code != 1) continue;
                rl.add(bookmark.getUri());
            }
            result = rl.getWebRepresentation();
        }
        return result;
    }

    public Representation handle() {
        Representation result = null;
        Reference ref = this.getRequest().getResourceRef();
        if (!ref.getPath().endsWith("/")) {
            ref.setPath(ref.getPath() + "/");
            this.redirectPermanent(ref);
        } else {
            result = super.handle();
        }
        return result;
    }
}

