/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.oauth.mongo;

import com.mongodb.DBObject;
import java.util.List;
import java.util.Map;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.Client;

public class MongoClient
implements Client {
    public static final String CLIENT_SECRET = "client_secret";
    public static final String CLIENT_TYPE = "client_type";
    public static final String REDIRECT_URIS = "redirect_uris";
    public static final String ALLOWED_RESPONSE_TYPES = "allowed_response_types";
    public static final String ALLOWED_GRANT_TYPES = "allowed_grant_types";
    public static final String PROPERTIES = "properties";
    private DBObject client;

    public MongoClient(DBObject client) {
        this.client = client;
    }

    public String getClientId() {
        return this.client.get("_id").toString();
    }

    public char[] getClientSecret() {
        if (this.client.containsField(CLIENT_SECRET)) {
            return this.client.get(CLIENT_SECRET).toString().toCharArray();
        }
        return null;
    }

    public String[] getRedirectURIs() {
        if (this.client.containsField(REDIRECT_URIS)) {
            List list = (List)this.client.get(REDIRECT_URIS);
            String[] uris = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                uris[i] = list.get(i).toString();
            }
            return uris;
        }
        return null;
    }

    public Map getProperties() {
        DBObject properties = (DBObject)this.client.get(PROPERTIES);
        return properties.toMap();
    }

    public Client.ClientType getClientType() {
        String type = this.client.get(CLIENT_TYPE).toString();
        if (type.equals("public")) {
            return Client.ClientType.PUBLIC;
        }
        if (type.equals("confidential")) {
            return Client.ClientType.CONFIDENTIAL;
        }
        throw new IllegalStateException("Unknown Client Type");
    }

    public boolean isResponseTypeAllowed(ResponseType responseType) {
        return this.isTypeAllowed(ALLOWED_RESPONSE_TYPES, responseType.name());
    }

    public boolean isGrantTypeAllowed(GrantType grantType) {
        return this.isTypeAllowed(ALLOWED_GRANT_TYPES, grantType.name());
    }

    private boolean isTypeAllowed(String field, String typeName) {
        List list = (List)this.client.get(field);
        for (Object allowedType : list) {
            if (!allowedType.toString().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.client.toString();
    }
}

