/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.wadl;

import java.io.IOException;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.example.ext.wadl.BaseResource;
import org.restlet.example.ext.wadl.Item;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemResource
extends BaseResource {
    Item item;
    String itemName;

    public Representation describe() {
        this.setName("Representation of a single item");
        return super.describe();
    }

    protected void describeDelete(MethodInfo info) {
        info.setDocumentation("Delete the current item.");
        ResponseInfo response = new ResponseInfo("No representation is returned.");
        response.getStatuses().add(Status.SUCCESS_NO_CONTENT);
        info.getResponses().add(response);
    }

    protected void describeGet(MethodInfo info) {
        info.setIdentifier("item");
        info.setDocumentation("To retrieve details of a specific item");
        ResponseInfo response = new ResponseInfo();
        RepresentationInfo repInfo = new RepresentationInfo(MediaType.TEXT_XML);
        repInfo.setXmlElement("item");
        repInfo.setDocumentation("XML representation of the current item.");
        response.getRepresentations().add(repInfo);
        info.getResponses().add(response);
        response = new ResponseInfo("Item not found");
        repInfo = new RepresentationInfo(MediaType.TEXT_HTML);
        repInfo.setIdentifier("itemError");
        response.getStatuses().add(Status.CLIENT_ERROR_NOT_FOUND);
        response.getRepresentations().add(repInfo);
        info.getResponses().add(response);
    }

    protected void describePut(MethodInfo info) {
        info.setDocumentation("Update or create the current item.");
        RepresentationInfo repInfo = new RepresentationInfo(MediaType.APPLICATION_WWW_FORM);
        ParameterInfo param = new ParameterInfo("name", ParameterStyle.PLAIN, "Name of the item");
        repInfo.getParameters().add(param);
        param = new ParameterInfo("description", ParameterStyle.PLAIN, "Description of the item");
        repInfo.getParameters().add(param);
        repInfo.setDocumentation("Web form.");
        info.getRequest().getRepresentations().add(repInfo);
        ResponseInfo response = new ResponseInfo();
        response.getStatuses().add(Status.SUCCESS_OK);
        response.getStatuses().add(Status.SUCCESS_CREATED);
        info.getResponses().add(response);
        response = new ResponseInfo();
        response.getStatuses().add(Status.SUCCESS_OK);
        response.getStatuses().add(Status.SUCCESS_CREATED);
        info.getResponses().add(response);
        super.describePut(info);
    }

    protected void doInit() throws ResourceException {
        this.itemName = (String)this.getRequest().getAttributes().get("itemName");
        if (this.itemName != null) {
            this.item = (Item)this.getItems().get(this.itemName);
        }
        this.setExisting(this.item != null);
    }

    @Delete
    public void removeItem() {
        if (this.item != null) {
            this.getItems().remove(this.item.getName());
        }
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    @Put
    public void storeItem(Representation entity) throws IOException {
        if (this.item == null) {
            this.item = new Item(this.itemName);
        }
        Form form = new Form(entity);
        this.item.setDescription(form.getFirstValue("description"));
        if (this.getItems().putIfAbsent(this.item.getName(), this.item) == null) {
            this.setStatus(Status.SUCCESS_CREATED);
        } else {
            this.setStatus(Status.SUCCESS_OK);
        }
    }

    @Get(value="xml")
    public Representation toXml() {
        try {
            DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
            Document d = representation.getDocument();
            Element eltItem = d.createElement("item");
            d.appendChild(eltItem);
            Element eltName = d.createElement("name");
            eltName.appendChild(d.createTextNode(this.item.getName()));
            eltItem.appendChild(eltName);
            Element eltDescription = d.createElement("description");
            eltDescription.appendChild(d.createTextNode(this.item.getDescription()));
            eltItem.appendChild(eltDescription);
            d.normalizeDocument();
            return representation;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

