/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.firstResource;

import java.io.IOException;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.example.firstResource.BaseResource;
import org.restlet.example.firstResource.Item;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemResource
extends BaseResource {
    Item item;
    String itemName;

    protected void doInit() throws ResourceException {
        this.itemName = (String)this.getRequest().getAttributes().get("itemName");
        this.item = (Item)this.getItems().get(this.itemName);
        this.setExisting(this.item != null);
    }

    @Delete
    public void removeItem() {
        if (this.item != null) {
            this.getItems().remove(this.item.getName());
        }
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    @Put
    public void storeItem(Representation entity) throws IOException {
        if (this.item == null) {
            this.item = new Item(this.itemName);
        }
        Form form = new Form(entity);
        this.item.setDescription(form.getFirstValue("description"));
        if (this.getItems().putIfAbsent(this.item.getName(), this.item) == null) {
            this.setStatus(Status.SUCCESS_CREATED);
        } else {
            this.setStatus(Status.SUCCESS_OK);
        }
    }

    @Get(value="xml")
    public Representation toXml() {
        try {
            DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
            Document d = representation.getDocument();
            Element eltItem = d.createElement("item");
            d.appendChild(eltItem);
            Element eltName = d.createElement("name");
            eltName.appendChild(d.createTextNode(this.item.getName()));
            eltItem.appendChild(eltName);
            Element eltDescription = d.createElement("description");
            eltDescription.appendChild(d.createTextNode(this.item.getDescription()));
            eltItem.appendChild(eltDescription);
            d.normalizeDocument();
            return representation;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

