/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.restlet.Context;
import org.restlet.ext.jaxrs.internal.provider.AbstractProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class SourceProvider
extends AbstractProvider<Source> {
    private final Logger logger = Context.getCurrentLogger();
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    @Override
    public long getSize(Source object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public Source readFrom(Class<Source> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return new StreamSource(entityStream);
    }

    @Override
    protected Class<?> supportedClass() {
        return Source.class;
    }

    @Override
    public void writeTo(Source source, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Transformer transformer;
        StreamResult streamResult = new StreamResult(entityStream);
        try {
            transformer = this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            this.logger.log(Level.WARNING, "Could not create Transformer", e);
            IOException ioException = new IOException("Could not create javax.xml.transform.Transformer");
            ioException.setStackTrace(e.getStackTrace());
            throw ioException;
        }
        try {
            transformer.transform(source, streamResult);
        }
        catch (Exception e) {
            IOException ioException = new IOException("Could not transform the javax.xml.transform.Source");
            ioException.setStackTrace(e.getStackTrace());
            throw ioException;
        }
        catch (TransformerFactoryConfigurationError e) {
            IOException ioException = new IOException("Could not transform the javax.xml.transform.Source");
            ioException.setStackTrace(e.getStackTrace());
            throw ioException;
        }
    }
}

