/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.ext.oauth.OAuthError;

public class OAuthException
extends Exception {
    private static final long serialVersionUID = 1L;
    private OAuthError error;
    private String description;
    private String errorUri;

    public OAuthException(OAuthError error, String description, String errorUri) {
        this.error = error;
        this.description = description;
        this.errorUri = errorUri;
    }

    public static OAuthException toOAuthException(Throwable t) {
        if (t instanceof OAuthException) {
            return (OAuthException)t;
        }
        if (t.getCause() instanceof OAuthException) {
            return (OAuthException)t.getCause();
        }
        return new OAuthException(OAuthError.server_error, t.getMessage(), null);
    }

    public OAuthError getError() {
        return this.error;
    }

    public String getErrorDescription() {
        return this.description;
    }

    public String getErrorURI() {
        return this.errorUri;
    }

    public JSONObject createErrorDocument() throws JSONException {
        JSONObject result = new JSONObject();
        result.put("error", (Object)this.error.name());
        if (this.description != null && this.description.length() > 0) {
            result.put("error_description", (Object)this.description);
        }
        if (this.errorUri != null && this.errorUri.length() > 0) {
            result.put("error_uri", (Object)this.errorUri);
        }
        return result;
    }
}

