/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.wadl.ApplicationInfo;
import org.restlet.ext.wadl.WadlRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_WADL = new VariantInfo(MediaType.APPLICATION_WADL);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_APPLICATION_WADL.includes(source)) {
            result = this.addObjectClass(result, ApplicationInfo.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (ApplicationInfo.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_APPLICATION_WADL);
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (source != null && ApplicationInfo.class.isAssignableFrom(target)) {
            result = 1.0f;
        }
        return result;
    }

    public float score(Object source, Variant target, Resource resource) {
        if (source instanceof ApplicationInfo) {
            return 1.0f;
        }
        return -1.0f;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        ApplicationInfo result = null;
        if (ApplicationInfo.class.isAssignableFrom(target)) {
            result = source instanceof WadlRepresentation ? ((WadlRepresentation)source).getApplication() : new WadlRepresentation(source).getApplication();
        }
        return target.cast(result);
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) throws IOException {
        if (source instanceof ApplicationInfo) {
            return new WadlRepresentation((ApplicationInfo)source);
        }
        return null;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        if (ApplicationInfo.class.isAssignableFrom(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_WADL, 1.0f);
        }
    }
}

