/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.ext.Db4oException;
import com.db4o.ext.Db4oIllegalStateException;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.monitoring.Freespace;
import com.db4o.monitoring.FreespaceMBean;
import com.db4o.monitoring.IO;
import com.db4o.monitoring.IOMBean;
import com.db4o.monitoring.NativeQueries;
import com.db4o.monitoring.NativeQueriesMBean;
import com.db4o.monitoring.ObjectLifecycle;
import com.db4o.monitoring.ObjectLifecycleMBean;
import com.db4o.monitoring.Queries;
import com.db4o.monitoring.QueriesMBean;
import com.db4o.monitoring.ReferenceSystem;
import com.db4o.monitoring.ReferenceSystemMBean;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db4oMBeans {
    private static final String MONITORING_DOMAIN_NAME = "com.db4o.monitoring";

    public static String mBeanIDForContainer(ObjectContainer container) {
        return container.toString();
    }

    public static ObjectName mBeanNameFor(Class<?> mbeanInterface, String name) {
        name = name.replaceAll("[:\\?\\*=,\"]", " ");
        String nameSpec = "com.db4o.monitoring:name=" + name + ",mbean=" + Db4oMBeans.displayName(mbeanInterface);
        try {
            return new ObjectName(nameSpec);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("'" + nameSpec + "' is not a valid name.", e);
        }
    }

    private static String displayName(Class<?> mbeanInterface) {
        String className = mbeanInterface.getSimpleName();
        if (!className.endsWith("MBean")) {
            throw new IllegalArgumentException();
        }
        return className.substring(0, className.length() - "MBean".length());
    }

    static IO newIOStatsMBean(ObjectContainer container) {
        try {
            return new IO(container, IOMBean.class);
        }
        catch (JMException e) {
            throw new Db4oException((Throwable)e);
        }
    }

    public static Queries newQueriesMBean(InternalObjectContainer container) {
        try {
            return new Queries((ObjectContainer)container, QueriesMBean.class);
        }
        catch (JMException e) {
            throw new Db4oIllegalStateException((Throwable)e);
        }
    }

    public static ReferenceSystem newReferenceSystemMBean(InternalObjectContainer container) {
        try {
            return new ReferenceSystem((ObjectContainer)container, ReferenceSystemMBean.class);
        }
        catch (JMException e) {
            throw new Db4oIllegalStateException((Throwable)e);
        }
    }

    public static NativeQueries newNativeQueriesMBean(InternalObjectContainer container) {
        try {
            return new NativeQueries((ObjectContainer)container, NativeQueriesMBean.class);
        }
        catch (JMException e) {
            throw new Db4oIllegalStateException((Throwable)e);
        }
    }

    public static Freespace newFreespaceMBean(InternalObjectContainer container) {
        try {
            return new Freespace((ObjectContainer)container, FreespaceMBean.class);
        }
        catch (JMException e) {
            throw new Db4oIllegalStateException((Throwable)e);
        }
    }

    public static ObjectLifecycle newObjectLifecycleMBean(ObjectContainer container) {
        try {
            return new ObjectLifecycle(container, ObjectLifecycleMBean.class);
        }
        catch (JMException e) {
            throw new Db4oIllegalStateException((Throwable)e);
        }
    }
}

