/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.config.CommonConfiguration;
import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.diagnostic.Diagnostic;
import com.db4o.diagnostic.DiagnosticListener;
import com.db4o.diagnostic.LoadedFromClassIndex;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.QueryEventArgs;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.config.Db4oLegacyConfigurationBridge;
import com.db4o.monitoring.Db4oMBeans;
import com.db4o.monitoring.Queries;

public class QueryMonitoringSupport
implements ConfigurationItem {
    public void apply(InternalObjectContainer container) {
        final Queries queries = Db4oMBeans.newQueriesMBean(container);
        CommonConfiguration config = Db4oLegacyConfigurationBridge.asCommonConfiguration((Configuration)container.configure());
        config.diagnostic().addListener(new DiagnosticListener(){

            public void onDiagnostic(Diagnostic d) {
                if (d instanceof LoadedFromClassIndex) {
                    queries.notifyClassIndexScan((LoadedFromClassIndex)d);
                }
            }
        });
        EventRegistry events = EventRegistryFactory.forObjectContainer((ObjectContainer)container);
        events.queryStarted().addListener((EventListener4)new EventListener4<QueryEventArgs>(){

            public void onEvent(Event4<QueryEventArgs> e, QueryEventArgs args) {
                queries.notifyQueryStarted();
            }
        });
        events.queryFinished().addListener((EventListener4)new EventListener4<QueryEventArgs>(){

            public void onEvent(Event4<QueryEventArgs> e, QueryEventArgs args) {
                queries.notifyQueryFinished();
            }
        });
    }

    public void prepare(Configuration configuration) {
    }
}

