/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.engine.Engine;
import org.restlet.engine.header.PreferenceReader;
import org.restlet.engine.io.IoUtils;
import org.restlet.routing.Filter;
import org.restlet.service.MetadataService;
import org.restlet.service.TunnelService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TunnelFilter
extends Filter {
    private final List<HeaderReplacer> acceptEncodingReplacers = this.getAcceptEncodingReplacers();
    private final List<HeaderReplacer> acceptReplacers = this.getAcceptReplacers();

    public TunnelFilter(Context context) {
        super(context);
    }

    @Override
    public int beforeHandle(Request request, Response response) {
        if (this.getTunnelService().isUserAgentTunnel()) {
            this.processUserAgent(request);
        }
        if (this.getTunnelService().isExtensionsTunnel()) {
            this.processExtensions(request);
        }
        if (this.getTunnelService().isQueryTunnel()) {
            this.processQuery(request);
        }
        if (this.getTunnelService().isHeadersTunnel()) {
            this.processHeaders(request);
        }
        return 0;
    }

    private List<HeaderReplacer> getAcceptEncodingReplacers() {
        return this.getheaderReplacers(Engine.getResource("org/restlet/service/accept-encoding.properties"), "acceptEncodingOld", "acceptEncodingNew");
    }

    private List<HeaderReplacer> getAcceptReplacers() {
        return this.getheaderReplacers(Engine.getResource("org/restlet/service/accept.properties"), "acceptOld", "acceptNew");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HeaderReplacer> getheaderReplacers(URL userAgentPropertiesUrl, String oldHeaderName, String newHeaderName) {
        ArrayList<HeaderReplacer> headerReplacers = new ArrayList<HeaderReplacer>();
        if (userAgentPropertiesUrl != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(userAgentPropertiesUrl.openStream(), CharacterSet.UTF_8.getName()), IoUtils.BUFFER_SIZE);
                HeaderReplacer.Builder headerReplacerBuilder = new HeaderReplacer.Builder();
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        String[] keyValue;
                        if (!line.startsWith("#") && (keyValue = line.split(":")).length == 2) {
                            String key = keyValue[0].trim();
                            String value = keyValue[1].trim();
                            if (oldHeaderName.equalsIgnoreCase(key)) {
                                headerReplacerBuilder.setOldValue("".equals(value) ? null : value);
                            } else if (newHeaderName.equalsIgnoreCase(key)) {
                                headerReplacerBuilder.setNewValue(value);
                                headerReplacers.add(headerReplacerBuilder.build());
                                headerReplacerBuilder = new HeaderReplacer.Builder();
                            } else {
                                headerReplacerBuilder.putAgentAttribute(key, value);
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                this.getContext().getLogger().warning("Cannot read '" + userAgentPropertiesUrl.toString() + "' due to: " + e.getMessage());
            }
        }
        return headerReplacers;
    }

    private Metadata getMetadata(String extension) {
        return this.getMetadataService().getMetadata(extension);
    }

    public MetadataService getMetadataService() {
        return this.getApplication().getMetadataService();
    }

    public TunnelService getTunnelService() {
        return this.getApplication().getTunnelService();
    }

    private boolean processExtensions(Request request) {
        Reference resourceRef;
        TunnelService tunnelService = this.getTunnelService();
        boolean extensionsModified = false;
        Method method = request.getMethod();
        if (tunnelService.isPreferencesTunnel() && (method.equals(Method.GET) || method.equals(Method.HEAD)) && (resourceRef = request.getResourceRef()).hasExtensions()) {
            String extensions;
            boolean languageFound;
            boolean mediaTypeFound;
            boolean characterSetFound;
            boolean encodingFound;
            block9: {
                ClientInfo clientInfo = request.getClientInfo();
                encodingFound = false;
                characterSetFound = false;
                mediaTypeFound = false;
                languageFound = false;
                extensions = resourceRef.getExtensions();
                while (true) {
                    int lastIndexOfPoint = extensions.lastIndexOf(46);
                    String extension = extensions.substring(lastIndexOfPoint + 1);
                    Metadata metadata = this.getMetadata(extension);
                    if (!mediaTypeFound && metadata instanceof MediaType) {
                        this.updateMetadata(clientInfo, metadata);
                        mediaTypeFound = true;
                    } else if (!languageFound && metadata instanceof Language) {
                        this.updateMetadata(clientInfo, metadata);
                        languageFound = true;
                    } else if (!characterSetFound && metadata instanceof CharacterSet) {
                        this.updateMetadata(clientInfo, metadata);
                        characterSetFound = true;
                    } else {
                        if (encodingFound || !(metadata instanceof Encoding)) break block9;
                        this.updateMetadata(clientInfo, metadata);
                        encodingFound = true;
                    }
                    if (lastIndexOfPoint <= 0) break;
                    extensions = extensions.substring(0, lastIndexOfPoint);
                }
                extensions = "";
            }
            if (encodingFound || characterSetFound || mediaTypeFound || languageFound) {
                resourceRef.setExtensions(extensions);
                extensionsModified = true;
            }
        }
        return extensionsModified;
    }

    private void processHeaders(Request request) {
        String newMethodValue;
        Series extraHeaders;
        TunnelService tunnelService = this.getTunnelService();
        if (tunnelService.isMethodTunnel() && (extraHeaders = (Series)request.getAttributes().get("org.restlet.http.headers")) != null && (newMethodValue = extraHeaders.getFirstValue(this.getTunnelService().getMethodHeader(), true)) != null && newMethodValue.trim().length() > 0) {
            request.setMethod(Method.valueOf(newMethodValue));
        }
    }

    private boolean processQuery(Request request) {
        TunnelService tunnelService = this.getTunnelService();
        boolean queryModified = false;
        Reference resourceRef = request.getResourceRef();
        if (resourceRef.hasQuery()) {
            String methodName;
            Method tunnelledMethod;
            Form query = resourceRef.getQueryAsForm();
            Method method = request.getMethod();
            if (tunnelService.isMethodTunnel() && (tunnelledMethod = Method.valueOf(methodName = query.getFirstValue(tunnelService.getMethodParameter()))) != null && (Method.POST.equals(method) || Method.OPTIONS.equals(tunnelledMethod))) {
                request.setMethod(tunnelledMethod);
                query.removeFirst(tunnelService.getMethodParameter());
                queryModified = true;
            }
            if (tunnelService.isPreferencesTunnel()) {
                String charSetParameter = tunnelService.getCharacterSetParameter();
                String encodingParameter = tunnelService.getEncodingParameter();
                String languageParameter = tunnelService.getLanguageParameter();
                String mediaTypeParameter = tunnelService.getMediaTypeParameter();
                String acceptedCharSet = query.getFirstValue(charSetParameter);
                String acceptedEncoding = query.getFirstValue(encodingParameter);
                String acceptedLanguage = query.getFirstValue(languageParameter);
                String acceptedMediaType = query.getFirstValue(mediaTypeParameter);
                ClientInfo clientInfo = request.getClientInfo();
                Metadata metadata = this.getMetadata(acceptedCharSet);
                if (metadata == null && acceptedCharSet != null) {
                    metadata = CharacterSet.valueOf(acceptedCharSet);
                }
                if (metadata instanceof CharacterSet) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(charSetParameter);
                    queryModified = true;
                }
                if ((metadata = this.getMetadata(acceptedEncoding)) == null && acceptedEncoding != null) {
                    metadata = Encoding.valueOf(acceptedEncoding);
                }
                if (metadata instanceof Encoding) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(encodingParameter);
                    queryModified = true;
                }
                if ((metadata = this.getMetadata(acceptedLanguage)) == null && acceptedLanguage != null) {
                    metadata = Language.valueOf(acceptedLanguage);
                }
                if (metadata instanceof Language) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(languageParameter);
                    queryModified = true;
                }
                if ((metadata = this.getMetadata(acceptedMediaType)) == null && acceptedMediaType != null) {
                    metadata = MediaType.valueOf(acceptedMediaType);
                }
                if (metadata instanceof MediaType) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(mediaTypeParameter);
                    queryModified = true;
                }
            }
            if (queryModified) {
                request.getResourceRef().setQuery(query.getQueryString(null));
            }
        }
        return queryModified;
    }

    private void processUserAgent(Request request) {
        Map<String, String> agentAttributes = request.getClientInfo().getAgentAttributes();
        if (!(agentAttributes == null || this.acceptReplacers.isEmpty() && this.acceptEncodingReplacers.isEmpty())) {
            Series headers = (Series)request.getAttributes().get("org.restlet.http.headers");
            String acceptOld = headers != null ? headers.getFirstValue("Accept", true) : null;
            for (HeaderReplacer headerReplacer : this.acceptReplacers) {
                if (!headerReplacer.matchesConditions(agentAttributes, acceptOld)) continue;
                ClientInfo clientInfo = new ClientInfo();
                PreferenceReader.addMediaTypes(headerReplacer.getHeaderNew(), clientInfo);
                request.getClientInfo().setAcceptedMediaTypes(clientInfo.getAcceptedMediaTypes());
                break;
            }
            String acceptEncodingOld = headers != null ? headers.getFirstValue("Accept-Encoding", true) : null;
            for (HeaderReplacer headerReplacer : this.acceptEncodingReplacers) {
                if (!headerReplacer.matchesConditions(agentAttributes, acceptEncodingOld)) continue;
                ClientInfo clientInfo = new ClientInfo();
                PreferenceReader.addEncodings(headerReplacer.getHeaderNew(), clientInfo);
                request.getClientInfo().setAcceptedEncodings(clientInfo.getAcceptedEncodings());
                break;
            }
        }
    }

    private void updateMetadata(ClientInfo clientInfo, Metadata metadata) {
        if (metadata != null) {
            if (metadata instanceof CharacterSet) {
                clientInfo.getAcceptedCharacterSets().clear();
                clientInfo.getAcceptedCharacterSets().add(new Preference<CharacterSet>((CharacterSet)metadata));
            } else if (metadata instanceof Encoding) {
                clientInfo.getAcceptedEncodings().clear();
                clientInfo.getAcceptedEncodings().add(new Preference<Encoding>((Encoding)metadata));
            } else if (metadata instanceof Language) {
                clientInfo.getAcceptedLanguages().clear();
                clientInfo.getAcceptedLanguages().add(new Preference<Language>((Language)metadata));
            } else if (metadata instanceof MediaType) {
                clientInfo.getAcceptedMediaTypes().clear();
                clientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>((MediaType)metadata));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HeaderReplacer {
        private final Map<String, String> agentAttributes;
        private final String headerNew;
        private final String headerOld;

        HeaderReplacer(String headerOld, String headerNew, Map<String, String> agentAttributes) {
            this.headerOld = headerOld;
            this.headerNew = headerNew;
            this.agentAttributes = Collections.unmodifiableMap(agentAttributes);
        }

        public Map<String, String> getAgentAttributes() {
            return this.agentAttributes;
        }

        public String getHeaderNew() {
            return this.headerNew;
        }

        public String getHeaderOld() {
            return this.headerOld;
        }

        public boolean matchesConditions(Map<String, String> agentAttributes, String headerOld) {
            boolean checked = true;
            Iterator<Map.Entry<String, String>> iterator = this.getAgentAttributes().entrySet().iterator();
            while (checked && iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String attribute = agentAttributes.get(entry.getKey());
                checked = attribute != null && attribute.equalsIgnoreCase(entry.getValue());
            }
            if (checked && this.getHeaderOld() != null) {
                checked = this.getHeaderOld().equals(headerOld);
            }
            return checked;
        }

        static class Builder {
            Map<String, String> agentAttributes = new HashMap<String, String>();
            String newValue;
            String oldValue;

            Builder() {
            }

            HeaderReplacer build() {
                return new HeaderReplacer(this.oldValue, this.newValue, this.agentAttributes);
            }

            void putAgentAttribute(String key, String value) {
                this.agentAttributes.put(key, value);
            }

            void setNewValue(String newValue) {
                this.newValue = newValue;
            }

            void setOldValue(String oldValue) {
                this.oldValue = oldValue;
            }
        }
    }
}

