/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.filters;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.Element;
import org.revapi.ElementFilter;
import org.revapi.java.spi.JavaAnnotationElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;

abstract class AbstractIncludeExcludeFilter
implements ElementFilter {
    private final String configurationRootPath;
    private final String schemaPath;
    private final IdentityHashMap<Object, InclusionState> elementResults = new IdentityHashMap();
    protected Predicate<String> includeTest;
    protected Predicate<String> excludeTest;
    protected boolean doNothing;

    protected AbstractIncludeExcludeFilter(String configurationRootPath, String schemaPath) {
        this.configurationRootPath = configurationRootPath;
        this.schemaPath = schemaPath;
    }

    protected Predicate<String> composeTest(List<String> fullMatches, List<Pattern> patterns) {
        if (fullMatches != null && fullMatches.size() > 0) {
            return s -> Collections.binarySearch(fullMatches, s) >= 0;
        }
        if (patterns != null && patterns.size() > 0) {
            return s -> patterns.stream().anyMatch(p -> p.matcher((CharSequence)s).matches());
        }
        return null;
    }

    public void close() throws Exception {
        this.elementResults.clear();
    }

    @Nullable
    public String getExtensionId() {
        return this.configurationRootPath;
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream(this.schemaPath), Charset.forName("UTF-8"));
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        ModelNode root = analysisContext.getConfiguration();
        if (!root.isDefined()) {
            this.doNothing = true;
            return;
        }
        ModelNode regex = root.get("regex");
        boolean regexes = regex.isDefined() && regex.asBoolean();
        ArrayList<String> fullMatches = new ArrayList<String>();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        this.readMatches(root.get("exclude"), regexes, fullMatches, patterns);
        this.validateConfiguration(true, fullMatches, patterns, regexes);
        this.excludeTest = this.composeTest(fullMatches, patterns);
        fullMatches = new ArrayList();
        patterns = new ArrayList();
        this.readMatches(root.get("include"), regexes, fullMatches, patterns);
        this.validateConfiguration(false, fullMatches, patterns, regexes);
        this.includeTest = this.composeTest(fullMatches, patterns);
        this.doNothing = this.includeTest == null && this.excludeTest == null;
    }

    protected abstract void validateConfiguration(boolean var1, List<String> var2, List<Pattern> var3, boolean var4);

    private void readMatches(ModelNode array, boolean regexes, List<String> fullMatches, List<Pattern> patterns) {
        if (!array.isDefined()) {
            return;
        }
        for (ModelNode ann : array.asList()) {
            String name = ann.asString();
            if (regexes) {
                patterns.add(Pattern.compile(name));
                continue;
            }
            fullMatches.add(name);
        }
        if (!regexes) {
            Collections.sort(fullMatches);
        }
    }

    public boolean applies(@Nullable Element element) {
        return this.decide(element);
    }

    public boolean shouldDescendInto(@Nullable Object element) {
        return true;
    }

    private boolean decide(@Nullable Object element) {
        InclusionState parentInclusionState;
        if (this.doNothing || !(element instanceof JavaElement)) {
            return true;
        }
        InclusionState ret = this.elementResults.get(element);
        if (ret != null) {
            return ret.toBoolean();
        }
        JavaElement el = (JavaElement)element;
        Element parent = el.getParent();
        InclusionState inclusionState = parentInclusionState = parent == null ? InclusionState.UNDECIDED : this.elementResults.get(parent);
        if (parentInclusionState == null) {
            parentInclusionState = InclusionState.UNDECIDED;
        }
        if (!(element instanceof JavaModelElement)) {
            return this.decideAnnotation((JavaAnnotationElement)element, parentInclusionState);
        }
        JavaModelElement javaElement = (JavaModelElement)element;
        Stream<String> tested = this.getTestedElementRepresentations(javaElement);
        ret = parentInclusionState;
        switch (parentInclusionState) {
            case INCLUDED: {
                if (this.excludeTest == null || !tested.anyMatch(s -> this.excludeTest.test((String)s))) break;
                ret = InclusionState.EXCLUDED;
                break;
            }
            case EXCLUDED: {
                if (!this.canBeReIncluded(javaElement)) break;
            }
            case UNDECIDED: {
                List testedList = null;
                if (this.includeTest != null && this.excludeTest != null) {
                    testedList = tested.collect(Collectors.toList());
                    tested = testedList.stream();
                }
                if (this.includeTest != null) {
                    InclusionState inclusionState2 = ret = tested.anyMatch(s -> this.includeTest.test((String)s)) ? InclusionState.INCLUDED : InclusionState.EXCLUDED;
                }
                if (this.excludeTest == null) break;
                if (testedList != null) {
                    tested = testedList.stream();
                }
                if (!tested.anyMatch(s -> this.excludeTest.test((String)s))) break;
                ret = InclusionState.EXCLUDED;
            }
        }
        this.elementResults.put(element, ret);
        return ret.toBoolean();
    }

    boolean decideAnnotation(JavaAnnotationElement annotation, InclusionState parentInclusionState) {
        return parentInclusionState.toBoolean();
    }

    protected abstract boolean canBeReIncluded(JavaModelElement var1);

    protected abstract Stream<String> getTestedElementRepresentations(JavaModelElement var1);

    protected static enum InclusionState {
        INCLUDED,
        EXCLUDED,
        UNDECIDED;


        boolean toBoolean() {
            switch (this) {
                case INCLUDED: 
                case UNDECIDED: {
                    return true;
                }
            }
            return false;
        }
    }
}

