/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.revapi.TreeFilter;
import org.revapi.base.OverridableIncludeExcludeTreeFilter;
import org.revapi.java.filters.ClassFilter;
import org.revapi.java.filters.PackageFilter;
import org.revapi.java.spi.JavaElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalysisConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AnalysisConfiguration.class);
    private final MissingClassReporting missingClassReporting;
    private final Set<String> useReportingCodes;
    private final boolean ignoreMissingAnnotations;
    private final boolean matchOverloads;
    private final TreeFilter<JavaElement> filter;

    AnalysisConfiguration(MissingClassReporting missingClassReporting, Set<String> useReportingCodes, boolean ignoreMissingAnnotations, boolean matchOverloads, @Nullable TreeFilter<JavaElement> filter) {
        this.missingClassReporting = missingClassReporting;
        this.useReportingCodes = useReportingCodes;
        this.ignoreMissingAnnotations = ignoreMissingAnnotations;
        this.matchOverloads = matchOverloads;
        this.filter = filter;
    }

    public static AnalysisConfiguration fromModel(JsonNode node) {
        MissingClassReporting reporting = AnalysisConfiguration.readMissingClassReporting(node);
        Set<String> useReportingCodes = AnalysisConfiguration.readUseReportingCodes(node);
        boolean ignoreMissingAnnotations = AnalysisConfiguration.readIgnoreMissingAnnotations(node);
        boolean matchOverloads = AnalysisConfiguration.readMatchOverloads(node);
        JsonNode classesRegex = node.path("filter").path("classes").path("regex");
        JsonNode packagesRegex = node.path("filter").path("packages").path("regex");
        Set<Pattern> classInclusionFilters = AnalysisConfiguration.readFilter(node.path("filter").path("classes").path("include"), classesRegex);
        Set<Pattern> classExclusionFilters = AnalysisConfiguration.readFilter(node.path("filter").path("classes").path("exclude"), classesRegex);
        Set<Pattern> packageInclusionFilters = AnalysisConfiguration.readFilter(node.path("filter").path("packages").path("include"), packagesRegex);
        Set<Pattern> packageExclusionFilters = AnalysisConfiguration.readFilter(node.path("filter").path("packages").path("exclude"), packagesRegex);
        OverridableIncludeExcludeTreeFilter includeFilter = null;
        if (!(classInclusionFilters.isEmpty() && classExclusionFilters.isEmpty() && packageInclusionFilters.isEmpty() && packageExclusionFilters.isEmpty())) {
            LOG.warn("Filtering using the revapi.java.filter.(classes|packages) has been deprecated in favor of revapi.filter in combination with the java matcher.");
            if (!classInclusionFilters.isEmpty() || !classExclusionFilters.isEmpty()) {
                includeFilter = new ClassFilter(classInclusionFilters.toArray(new Pattern[0]), classExclusionFilters.toArray(new Pattern[0]));
            }
            if (!packageInclusionFilters.isEmpty() || !packageExclusionFilters.isEmpty()) {
                PackageFilter pkgFilter = new PackageFilter(packageInclusionFilters.toArray(new Pattern[0]), packageExclusionFilters.toArray(new Pattern[0]));
                includeFilter = includeFilter == null ? pkgFilter : TreeFilter.intersection((TreeFilter[])new TreeFilter[]{includeFilter, pkgFilter});
            }
        }
        return new AnalysisConfiguration(reporting, useReportingCodes, ignoreMissingAnnotations, matchOverloads, (TreeFilter<JavaElement>)includeFilter);
    }

    public MissingClassReporting getMissingClassReporting() {
        return this.missingClassReporting;
    }

    public boolean reportUseForAllDifferences() {
        return this.useReportingCodes == null;
    }

    public Set<String> getUseReportingCodes() {
        return this.useReportingCodes == null ? Collections.emptySet() : this.useReportingCodes;
    }

    public boolean isIgnoreMissingAnnotations() {
        return this.ignoreMissingAnnotations;
    }

    public boolean isMatchOverloads() {
        return this.matchOverloads;
    }

    @Deprecated
    @Nullable
    public TreeFilter<JavaElement> getPackageClassFilter() {
        return this.filter;
    }

    private static MissingClassReporting readMissingClassReporting(JsonNode analysisConfig) {
        JsonNode config = analysisConfig.path("missing-classes").path("behavior");
        if (config.isTextual()) {
            switch (config.asText()) {
                case "report": {
                    return MissingClassReporting.REPORT;
                }
                case "ignore": {
                    return MissingClassReporting.IGNORE;
                }
                case "error": {
                    return MissingClassReporting.ERROR;
                }
            }
            throw new IllegalArgumentException("Unsupported value of revapi.java.missing-classes.behavior: '" + config.asText() + "'. Only 'report', 'ignore' and 'error' are recognized.");
        }
        return MissingClassReporting.REPORT;
    }

    private static boolean readIgnoreMissingAnnotations(JsonNode analysisConfig) {
        JsonNode config = analysisConfig.path("missing-classes").path("ignoreMissingAnnotations");
        return config.asBoolean(false);
    }

    private static boolean readMatchOverloads(JsonNode analysisConfig) {
        return analysisConfig.path("matchOverloads").asBoolean(true);
    }

    @Nullable
    private static Set<String> readUseReportingCodes(JsonNode analysisConfig) {
        HashSet<String> ret = new HashSet<String>(5);
        JsonNode config = analysisConfig.path("reportUsesFor");
        if (config.isArray()) {
            for (JsonNode code : config) {
                ret.add(code.asText());
            }
        } else if (config.isTextual() && "all-differences".equals(config.asText())) {
            ret = null;
        } else {
            ret.add("java.missing.oldClass");
            ret.add("java.missing.newClass");
            ret.add("java.class.nonPublicPartOfAPI");
            ret.add("java.class.externalClassExposedInAPI");
            ret.add("java.class.externalClassNoLongerExposedInAPI");
        }
        return ret;
    }

    private static Set<Pattern> readFilter(JsonNode filterNode, JsonNode regexNode) {
        if (!filterNode.isArray()) {
            return Collections.emptySet();
        }
        boolean isRegex = regexNode.asBoolean(false);
        return StreamSupport.stream(filterNode.spliterator(), false).map(filter -> {
            if (isRegex) {
                return Pattern.compile(filter.asText());
            }
            return Pattern.compile(Pattern.quote(filter.asText()));
        }).collect(Collectors.toSet());
    }

    public static enum MissingClassReporting {
        IGNORE,
        ERROR,
        REPORT;

    }
}

