/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.Util;

public final class ReturnTypeChanged
extends CheckBase {
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    protected void doVisitMethod(@Nullable JavaMethodElement oldMethod, @Nullable JavaMethodElement newMethod) {
        if (!this.isBothAccessible((JavaModelElement)oldMethod, (JavaModelElement)newMethod)) {
            return;
        }
        assert (oldMethod != null);
        assert (newMethod != null);
        TypeMirror oldReturnType = oldMethod.getModelRepresentation().getReturnType();
        TypeMirror newReturnType = newMethod.getModelRepresentation().getReturnType();
        String oldRet = Util.toUniqueString((TypeMirror)oldReturnType);
        String newRet = Util.toUniqueString((TypeMirror)newReturnType);
        TypeMirror erasedOldType = this.getOldTypeEnvironment().getTypeUtils().erasure(oldMethod.getDeclaringElement().getReturnType());
        TypeMirror erasedNewType = this.getNewTypeEnvironment().getTypeUtils().erasure(newMethod.getDeclaringElement().getReturnType());
        String oldErasedRet = Util.toUniqueString((TypeMirror)erasedOldType);
        String newErasedRet = Util.toUniqueString((TypeMirror)erasedNewType);
        if (!oldRet.equals(newRet) || !oldErasedRet.equals(newErasedRet)) {
            this.pushActive((JavaElement)oldMethod, (JavaElement)newMethod, new Object[]{oldReturnType, oldRet, newReturnType, newRet, erasedOldType, oldErasedRet, erasedNewType, newErasedRet});
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        TypeMirror oldReturnType = (TypeMirror)methods.context[0];
        String oldR = (String)methods.context[1];
        TypeMirror newReturnType = (TypeMirror)methods.context[2];
        String newR = (String)methods.context[3];
        TypeMirror erasedOldType = (TypeMirror)methods.context[4];
        String oldER = (String)methods.context[5];
        TypeMirror erasedNewType = (TypeMirror)methods.context[6];
        String newER = (String)methods.context[7];
        Code code = null;
        String oldHR = Util.toHumanReadableString((AnnotatedConstruct)oldReturnType);
        String newHR = Util.toHumanReadableString((AnnotatedConstruct)newReturnType);
        if (!oldER.equals(newER)) {
            if (ReturnTypeChanged.isPrimitiveOrVoid(erasedOldType) || ReturnTypeChanged.isPrimitiveOrVoid(erasedNewType)) {
                code = Code.METHOD_RETURN_TYPE_CHANGED;
            } else if (this.isCovariant(erasedOldType, erasedNewType)) {
                code = Code.METHOD_RETURN_TYPE_CHANGED_COVARIANTLY;
            } else if (oldR.equals(newR)) {
                oldHR = Util.toHumanReadableString((AnnotatedConstruct)erasedOldType);
                newHR = Util.toHumanReadableString((AnnotatedConstruct)erasedNewType);
                code = Code.METHOD_RETURN_TYPE_ERASURE_CHANGED;
            } else {
                code = Code.METHOD_RETURN_TYPE_CHANGED;
            }
        } else if (!oldR.equals(newR)) {
            code = Code.METHOD_RETURN_TYPE_TYPE_PARAMETERS_CHANGED;
        }
        return code == null ? null : Collections.singletonList(this.createDifference(code, Code.attachmentsFor((JavaElement)((JavaMethodElement)methods.oldElement), (JavaElement)((JavaMethodElement)methods.newElement), (String[])new String[]{"oldType", oldHR, "newType", newHR})));
    }

    private static boolean isPrimitiveOrVoid(TypeMirror type) {
        TypeKind kind = type.getKind();
        switch (kind) {
            case VOID: {
                return true;
            }
            case ARRAY: {
                return ReturnTypeChanged.isPrimitiveOrVoid(((ArrayType)type).getComponentType());
            }
        }
        return kind.isPrimitive();
    }

    private boolean isCovariant(TypeMirror superType, TypeMirror subType) {
        return Util.isSubtype((TypeMirror)subType, Collections.singletonList(superType), (Types)this.getNewTypeEnvironment().getTypeUtils());
    }
}

