/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.faces.FacesException;
import org.ajax4jsf.io.ByteBuffer;
import org.richfaces.request.FileUploadParam;
import org.richfaces.request.FileUploadResource;

final class FileUploadValueParam
implements FileUploadParam {
    private ByteBuffer buffer;
    private String name;
    private String encoding;
    private String value;

    public FileUploadValueParam(String name, String encoding) {
        this.name = name;
        this.encoding = encoding;
    }

    private byte[] getBufferBytes() {
        byte[] bs = new byte[this.buffer.getLast().getTotalSize()];
        int pos = 0;
        for (ByteBuffer currentBuffer = this.buffer; currentBuffer != null; currentBuffer = currentBuffer.getNext()) {
            System.arraycopy(currentBuffer.getBytes(), 0, bs, pos, currentBuffer.getUsedSize());
            pos += currentBuffer.getUsedSize();
        }
        return bs;
    }

    @Override
    public void handle(byte[] bytes, int length) throws IOException {
        this.buffer.append(bytes, 0, length);
    }

    @Override
    public void create() throws IOException {
        this.buffer = new ByteBuffer(256);
    }

    @Override
    public void complete() {
        byte[] bytes = this.getBufferBytes();
        this.buffer = null;
        try {
            this.value = this.encoding != null ? new String(bytes, this.encoding) : new String(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFileParam() {
        return false;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public FileUploadResource getResource() {
        return null;
    }
}

