/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.richfaces.request.ProgressControl;

class ProgressServletInputStream
extends ServletInputStream {
    private ServletInputStream wrappedStream;
    private ProgressControl progressControl;

    protected ProgressServletInputStream(ServletInputStream wrappedStream, ProgressControl progressControl) {
        this.wrappedStream = wrappedStream;
        this.progressControl = progressControl;
    }

    public int read() throws IOException {
        int read = this.wrappedStream.read();
        if (read >= 0) {
            this.progressControl.advance(1L);
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = this.wrappedStream.read(b);
        if (read > 0) {
            this.progressControl.advance(read);
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.wrappedStream.read(b, off, len);
        if (read > 0) {
            this.progressControl.advance(read);
        }
        return read;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        int read = this.wrappedStream.readLine(b, off, len);
        if (read > 0) {
            this.progressControl.advance(read);
        }
        return read;
    }

    public long skip(long n) throws IOException {
        return this.wrappedStream.skip(n);
    }

    public int available() throws IOException {
        return this.wrappedStream.available();
    }

    public void close() throws IOException {
        this.wrappedStream.close();
    }

    public void mark(int readlimit) {
        this.wrappedStream.mark(readlimit);
    }

    public void reset() throws IOException {
        this.wrappedStream.reset();
    }

    public boolean markSupported() {
        return this.wrappedStream.markSupported();
    }
}

