/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets;

import javax.faces.component.UIComponent;
import javax.faces.convert.Converter;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.richfaces.component.TreeModelAdaptor;

public class TreeAdaptorRowKeyConverterRule
extends MetaRule {
    public static final TreeAdaptorRowKeyConverterRule INSTANCE = new TreeAdaptorRowKeyConverterRule();

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(TreeModelAdaptor.class) && "rowKeyConverter".equals(name)) {
            if (attribute.isLiteral()) {
                return new StaticConverterMetadata(attribute.getValue());
            }
            return new DynamicConverterMetaData(attribute);
        }
        return null;
    }

    static final class StaticConverterMetadata
    extends Metadata {
        private final String converterId;

        public StaticConverterMetadata(String converterId) {
            this.converterId = converterId;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            Converter converter = ctx.getFacesContext().getApplication().createConverter(this.converterId);
            ((TreeModelAdaptor)instance).setRowKeyConverter(converter);
        }
    }

    static final class DynamicConverterMetaData
    extends Metadata {
        private final TagAttribute attribute;

        public DynamicConverterMetaData(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueExpression("rowKeyConverter", this.attribute.getValueExpression(ctx, Converter.class));
        }
    }
}

