/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets;

import java.io.IOException;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.richfaces.event.TreeToggleEvent;
import org.richfaces.event.TreeToggleListener;
import org.richfaces.event.TreeToggleSource;

public class TreeToggleListenerHandler
extends TagHandler {
    private TagAttribute binding = this.getAttribute("binding");
    private String listenerType;
    private TagAttribute listenerMethod;

    public TreeToggleListenerHandler(TagConfig config) {
        super(config);
        TagAttribute type = this.getAttribute("type");
        if (type != null) {
            if (!type.isLiteral()) {
                throw new TagAttributeException(type, "Must be a literal class name of type TreeToggleListener");
            }
            this.listenerType = type.getValue();
        } else {
            this.listenerType = null;
        }
        this.listenerMethod = this.getAttribute("listener");
        if (this.listenerMethod != null && this.binding != null) {
            throw new TagException(this.tag, "Attributes 'listener' and 'binding' cannot be used simultaneously");
        }
        if (this.listenerMethod != null && this.listenerType != null) {
            throw new TagException(this.tag, "Attributes 'listener' and 'type' cannot be used simultaneously");
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (null != parent && ComponentHandler.isNew((UIComponent)parent)) {
            if (!(parent instanceof TreeToggleSource)) {
                throw new TagException(this.tag, "Parent is not of type TreeToggleSource, type is: " + parent);
            }
            TreeToggleSource as = (TreeToggleSource)parent;
            if (this.listenerMethod != null) {
                MethodExpression listenerMethodExpression = this.listenerMethod.getMethodExpression(ctx, Void.TYPE, new Class[]{TreeToggleEvent.class});
                as.addTreeToggleListener((TreeToggleListener)new MethodExpressionListener(listenerMethodExpression));
            } else {
                ValueExpression b = null;
                if (this.binding != null) {
                    b = this.binding.getValueExpression(ctx, TreeToggleListener.class);
                }
                LazyListener listener = new LazyListener(this.listenerType, b);
                as.addTreeToggleListener((TreeToggleListener)listener);
            }
        }
    }

    public static final class MethodExpressionListener
    implements TreeToggleListener,
    Serializable {
        private MethodExpression methodExpression;

        public MethodExpressionListener(MethodExpression methodExpression) {
            this.methodExpression = methodExpression;
        }

        public void processTreeToggle(TreeToggleEvent actionEvent) throws AbortProcessingException {
            if (actionEvent == null) {
                throw new NullPointerException();
            }
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            try {
                this.methodExpression.invoke(elContext, new Object[]{actionEvent});
            }
            catch (Exception e) {
                new AbortProcessingException((Throwable)e);
            }
        }
    }

    public static final class LazyListener
    implements TreeToggleListener,
    Serializable {
        private final String type;
        private final ValueExpression binding;

        public LazyListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processTreeToggle(TreeToggleEvent event) throws AbortProcessingException {
            TreeToggleListener instance = null;
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            if (this.binding != null) {
                instance = (TreeToggleListener)this.binding.getValue(faces.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (null == classLoader) {
                        classLoader = TreeToggleListener.class.getClassLoader();
                    }
                    instance = classLoader.loadClass(this.type).asSubclass(TreeToggleListener.class).newInstance();
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Couldn't lazily instantiate TreeToggleListener", (Throwable)e);
                }
                if (this.binding != null) {
                    this.binding.setValue(faces.getELContext(), (Object)instance);
                }
            }
            if (instance != null) {
                instance.processTreeToggle(event);
            }
        }
    }
}

