/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayAdjustments;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=Display.class)
public class ShadowDisplay {
    @RealObject
    Display realObject;
    private int displayId;
    private String name = "Default Display";
    private int flags;
    private int width = 480;
    private int height = 800;
    private int realWidth = 480;
    private int realHeight = 854;
    private float density = 1.5f;
    private int densityDpi = 240;
    private float xdpi = 240.0f;
    private float ydpi = 240.0f;
    private float scaledDensity = 1.0f;
    private float refreshRate = 60.0f;
    private int rotation = 0;
    private int pixelFormat = 7;

    @Implementation
    public int getHeight() {
        return this.height;
    }

    @Implementation
    public void getMetrics(DisplayMetrics outMetrics) {
        outMetrics.density = this.density;
        outMetrics.densityDpi = this.densityDpi;
        outMetrics.scaledDensity = this.scaledDensity;
        outMetrics.widthPixels = this.width;
        outMetrics.heightPixels = this.height;
        outMetrics.xdpi = this.xdpi;
        outMetrics.ydpi = this.ydpi;
    }

    @Implementation
    public void getRealMetrics(DisplayMetrics outMetrics) {
        this.getMetrics(outMetrics);
        outMetrics.widthPixels = this.realWidth;
        outMetrics.heightPixels = this.realHeight;
    }

    @Implementation
    public int getWidth() {
        return this.width;
    }

    @Implementation
    public int getDisplayId() {
        return this.displayId;
    }

    @Implementation
    public String getName() {
        return this.name;
    }

    @Implementation
    public int getFlags() {
        return this.flags;
    }

    @Implementation
    public float getRefreshRate() {
        return this.refreshRate;
    }

    @Implementation
    public int getOrientation() {
        return this.getRotation();
    }

    @Implementation
    public int getRotation() {
        return this.rotation;
    }

    @Implementation
    public int getPixelFormat() {
        return this.pixelFormat;
    }

    @Implementation
    public void getCurrentSizeRange(Point outSmallestSize, Point outLargestSize) {
        int minimum = Math.min(this.width, this.height);
        int maximum = Math.max(this.width, this.height);
        outSmallestSize.set(minimum, minimum);
        outLargestSize.set(maximum, maximum);
    }

    @Implementation
    public void getSize(Point outSize) {
        outSize.set(this.width, this.height);
    }

    @Implementation
    public void getRectSize(Rect outSize) {
        outSize.set(0, 0, this.width, this.height);
    }

    @Implementation
    public void getRealSize(Point outSize) {
        outSize.set(this.realWidth, this.realHeight);
    }

    @Implementation(minSdk=21)
    public int getState() {
        return 2;
    }

    public float getDensity() {
        return this.density;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public int getDensityDpi() {
        return this.densityDpi;
    }

    public void setDensityDpi(int densityDpi) {
        this.densityDpi = densityDpi;
    }

    public float getXdpi() {
        return this.xdpi;
    }

    public void setXdpi(float xdpi) {
        this.xdpi = xdpi;
    }

    public float getYdpi() {
        return this.ydpi;
    }

    public void setYdpi(float ydpi) {
        this.ydpi = ydpi;
    }

    public float getScaledDensity() {
        return this.scaledDensity;
    }

    public void setScaledDensity(float scaledDensity) {
        this.scaledDensity = scaledDensity;
    }

    public void setDisplayId(int displayId) {
        this.displayId = displayId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setRealWidth(int realWidth) {
        this.realWidth = realWidth;
    }

    public void setRealHeight(int realHeight) {
        this.realHeight = realHeight;
    }

    public void setRefreshRate(float refreshRate) {
        this.refreshRate = refreshRate;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    @Implementation(minSdk=19)
    public Object getDisplayAdjustments() {
        return new DisplayAdjustments();
    }
}

