/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.StatFs;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=StatFs.class)
public class ShadowStatFs {
    public static final int BLOCK_SIZE = 4096;
    private static final Stats DEFAULT_STATS = new Stats(0, 0, 0);
    private static Map<String, Stats> stats = new HashMap<String, Stats>();
    private Stats stat;

    public void __constructor__(String path) {
        this.restat(path);
    }

    @Implementation
    public int getBlockSize() {
        return 4096;
    }

    @Implementation
    public int getBlockCount() {
        return this.stat.blockCount;
    }

    @Implementation
    public int getFreeBlocks() {
        return this.stat.freeBlocks;
    }

    @Implementation(minSdk=18)
    public long getFreeBlocksLong() {
        return this.stat.freeBlocks;
    }

    @Implementation(minSdk=18)
    public long getFreeBytes() {
        return this.getBlockSizeLong() * this.getFreeBlocksLong();
    }

    @Implementation(minSdk=18)
    public long getAvailableBytes() {
        return this.getBlockSizeLong() * this.getAvailableBlocksLong();
    }

    @Implementation(minSdk=18)
    public long getTotalBytes() {
        return this.getBlockSizeLong() * this.getBlockCountLong();
    }

    @Implementation
    public int getAvailableBlocks() {
        return this.stat.availableBlocks;
    }

    @Implementation
    public void restat(String path) {
        this.stat = stats.get(path);
        if (this.stat == null) {
            this.stat = DEFAULT_STATS;
        }
    }

    @Implementation(minSdk=18)
    public long getBlockSizeLong() {
        return 4096L;
    }

    @Implementation(minSdk=18)
    public long getBlockCountLong() {
        return this.stat.blockCount;
    }

    @Implementation(minSdk=18)
    public long getAvailableBlocksLong() {
        return this.stat.availableBlocks;
    }

    public static void registerStats(File path, int blockCount, int freeBlocks, int availableBlocks) {
        ShadowStatFs.registerStats(path.getAbsolutePath(), blockCount, freeBlocks, availableBlocks);
    }

    public static void registerStats(String path, int blockCount, int freeBlocks, int availableBlocks) {
        stats.put(path, new Stats(blockCount, freeBlocks, availableBlocks));
    }

    @Resetter
    public static void reset() {
        stats.clear();
    }

    private static class Stats {
        int blockCount;
        int freeBlocks;
        int availableBlocks;

        Stats(int blockCount, int freeBlocks, int availableBlocks) {
            this.blockCount = blockCount;
            this.freeBlocks = freeBlocks;
            this.availableBlocks = availableBlocks;
        }
    }
}

