/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Choreographer;
import android.view.IWindowFocusObserver;
import android.view.IWindowId;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.WindowId;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import java.io.PrintStream;
import java.lang.reflect.Method;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.android.AccessibilityUtil;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowChoreographer;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=View.class)
public class ShadowView {
    @RealObject
    protected View realView;
    private View.OnClickListener onClickListener;
    private View.OnLongClickListener onLongClickListener;
    private View.OnFocusChangeListener onFocusChangeListener;
    private View.OnSystemUiVisibilityChangeListener onSystemUiVisibilityChangeListener;
    private boolean wasInvalidated;
    private View.OnTouchListener onTouchListener;
    protected AttributeSet attributeSet;
    public Point scrollToCoordinates = new Point();
    private boolean didRequestLayout;
    private MotionEvent lastTouchEvent;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private int hapticFeedbackPerformed = -1;
    private boolean onLayoutWasCalled;
    private View.OnCreateContextMenuListener onCreateContextMenuListener;
    private Rect globalVisibleRect;
    private AnimationRunner animationRunner;

    public static boolean clickOn(View view) {
        return Shadows.shadowOf(view).checkedPerformClick();
    }

    public static String visualize(View view) {
        Canvas canvas = new Canvas();
        view.draw(canvas);
        return Shadows.shadowOf(canvas).getDescription();
    }

    public static void dump(View view) {
        Shadows.shadowOf(view).dump();
    }

    public static String innerText(View view) {
        return Shadows.shadowOf(view).innerText();
    }

    public void __constructor__(Context context, AttributeSet attributeSet, int defStyle) {
        if (context == null) {
            throw new NullPointerException("no context");
        }
        this.attributeSet = attributeSet;
        Shadow.invokeConstructor(View.class, (Object)this.realView, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(AttributeSet.class, (Object)attributeSet), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)defStyle)});
    }

    protected Drawable buildDrawable(int resourceId) {
        return this.realView.getResources().getDrawable(resourceId);
    }

    @Deprecated
    protected String getQualifiers() {
        return RuntimeEnvironment.getQualifiers();
    }

    @Deprecated
    public int getBackgroundResourceId() {
        Drawable drawable = this.realView.getBackground();
        return drawable instanceof BitmapDrawable ? Shadows.shadowOf(((BitmapDrawable)drawable).getBitmap()).getCreatedFromResId() : -1;
    }

    @Deprecated
    public int getBackgroundColor() {
        Drawable drawable = this.realView.getBackground();
        return drawable instanceof ColorDrawable ? ((ColorDrawable)drawable).getColor() : 0;
    }

    @HiddenApi
    @Implementation
    public void computeOpaqueFlags() {
    }

    @Implementation
    public void setOnFocusChangeListener(View.OnFocusChangeListener l) {
        this.onFocusChangeListener = l;
        this.directly().setOnFocusChangeListener(l);
    }

    @Implementation
    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
        this.directly().setOnClickListener(onClickListener);
    }

    @Implementation
    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.onLongClickListener = onLongClickListener;
        this.directly().setOnLongClickListener(onLongClickListener);
    }

    @Implementation
    public void setOnSystemUiVisibilityChangeListener(View.OnSystemUiVisibilityChangeListener onSystemUiVisibilityChangeListener) {
        this.onSystemUiVisibilityChangeListener = onSystemUiVisibilityChangeListener;
        this.directly().setOnSystemUiVisibilityChangeListener(onSystemUiVisibilityChangeListener);
    }

    @Implementation
    public void setOnCreateContextMenuListener(View.OnCreateContextMenuListener onCreateContextMenuListener) {
        this.onCreateContextMenuListener = onCreateContextMenuListener;
        this.directly().setOnCreateContextMenuListener(onCreateContextMenuListener);
    }

    @Implementation
    public void draw(Canvas canvas) {
        Drawable background = this.realView.getBackground();
        if (background != null) {
            Shadows.shadowOf(canvas).appendDescription("background:");
            background.draw(canvas);
        }
    }

    @Implementation
    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.onLayoutWasCalled = true;
        Shadow.directlyOn((Object)this.realView, View.class, (String)"onLayout", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)changed), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)left), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)top), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)right), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)bottom)});
    }

    public boolean onLayoutWasCalled() {
        return this.onLayoutWasCalled;
    }

    @Implementation
    public void requestLayout() {
        this.didRequestLayout = true;
        this.directly().requestLayout();
    }

    public boolean didRequestLayout() {
        return this.didRequestLayout;
    }

    public void setDidRequestLayout(boolean didRequestLayout) {
        this.didRequestLayout = didRequestLayout;
    }

    public void setViewFocus(boolean hasFocus) {
        if (this.onFocusChangeListener != null) {
            this.onFocusChangeListener.onFocusChange(this.realView, hasFocus);
        }
    }

    @Implementation
    public void invalidate() {
        this.wasInvalidated = true;
        this.directly().invalidate();
    }

    @Implementation
    public boolean onTouchEvent(MotionEvent event) {
        this.lastTouchEvent = event;
        return this.directly().onTouchEvent(event);
    }

    @Implementation
    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.onTouchListener = onTouchListener;
        this.directly().setOnTouchListener(onTouchListener);
    }

    public MotionEvent getLastTouchEvent() {
        return this.lastTouchEvent;
    }

    public String innerText() {
        return "";
    }

    public void dump() {
        this.dump(System.out, 0);
    }

    public void dump(PrintStream out, int indent) {
        this.dumpFirstPart(out, indent);
        out.println("/>");
    }

    protected void dumpFirstPart(PrintStream out, int indent) {
        this.dumpIndent(out, indent);
        out.print("<" + this.realView.getClass().getSimpleName());
        this.dumpAttributes(out);
    }

    protected void dumpAttributes(PrintStream out) {
        if (this.realView.getId() > 0) {
            this.dumpAttribute(out, "id", this.realView.getContext().getResources().getResourceName(this.realView.getId()));
        }
        switch (this.realView.getVisibility()) {
            case 0: {
                break;
            }
            case 4: {
                this.dumpAttribute(out, "visibility", "INVISIBLE");
                break;
            }
            case 8: {
                this.dumpAttribute(out, "visibility", "GONE");
            }
        }
    }

    protected void dumpAttribute(PrintStream out, String name, String value) {
        out.print(" " + name + "=\"" + (value == null ? null : TextUtils.htmlEncode((String)value)) + "\"");
    }

    protected void dumpIndent(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(" ");
        }
    }

    public boolean wasInvalidated() {
        return this.wasInvalidated;
    }

    public void clearWasInvalidated() {
        this.wasInvalidated = false;
    }

    public boolean checkedPerformClick() {
        if (!this.realView.isShown()) {
            throw new RuntimeException("View is not visible and cannot be clicked");
        }
        if (!this.realView.isEnabled()) {
            throw new RuntimeException("View is not enabled and cannot be clicked");
        }
        AccessibilityUtil.checkViewIfCheckingEnabled(this.realView);
        return this.realView.performClick();
    }

    public View.OnTouchListener getOnTouchListener() {
        return this.onTouchListener;
    }

    public View.OnClickListener getOnClickListener() {
        return this.onClickListener;
    }

    public View.OnLongClickListener getOnLongClickListener() {
        return this.onLongClickListener;
    }

    public View.OnSystemUiVisibilityChangeListener getOnSystemUiVisibilityChangeListener() {
        return this.onSystemUiVisibilityChangeListener;
    }

    public View.OnCreateContextMenuListener getOnCreateContextMenuListener() {
        return this.onCreateContextMenuListener;
    }

    @Implementation
    public Bitmap getDrawingCache() {
        return (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    public void post(Runnable action) {
        ShadowApplication.getInstance().getForegroundThreadScheduler().post(action);
    }

    @Implementation
    public void postDelayed(Runnable action, long delayMills) {
        ShadowApplication.getInstance().getForegroundThreadScheduler().postDelayed(action, delayMills);
    }

    @Implementation
    public void postInvalidateDelayed(long delayMilliseconds) {
        ShadowApplication.getInstance().getForegroundThreadScheduler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ShadowView.this.realView.invalidate();
            }
        }, delayMilliseconds);
    }

    @Implementation
    public void removeCallbacks(Runnable callback) {
        Shadows.shadowOf(Looper.getMainLooper()).getScheduler().remove(callback);
    }

    @Implementation
    public void scrollTo(int x, int y) {
        try {
            Method method = View.class.getDeclaredMethod("onScrollChanged", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.realView, x, y, this.scrollToCoordinates.x, this.scrollToCoordinates.y);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.scrollToCoordinates = new Point(x, y);
    }

    @Implementation
    public int getScrollX() {
        return this.scrollToCoordinates != null ? this.scrollToCoordinates.x : 0;
    }

    @Implementation
    public int getScrollY() {
        return this.scrollToCoordinates != null ? this.scrollToCoordinates.y : 0;
    }

    @Implementation
    public void setScrollX(int scrollX) {
        this.scrollTo(scrollX, this.scrollToCoordinates.y);
    }

    @Implementation
    public void setScrollY(int scrollY) {
        this.scrollTo(this.scrollToCoordinates.x, scrollY);
    }

    @Implementation
    public void setAnimation(Animation animation) {
        this.directly().setAnimation(animation);
        if (animation != null) {
            new AnimationRunner(animation);
        }
    }

    @Implementation
    public boolean isAttachedToWindow() {
        return this.getAttachInfo() != null;
    }

    private Object getAttachInfo() {
        return ReflectionHelpers.getField((Object)this.realView, (String)"mAttachInfo");
    }

    public void callOnAttachedToWindow() {
        this.invokeReflectively("onAttachedToWindow");
    }

    public void callOnDetachedFromWindow() {
        this.invokeReflectively("onDetachedFromWindow");
    }

    @Implementation(minSdk=18)
    public Object getWindowId() {
        return WindowIdHelper.getWindowId(this);
    }

    private void invokeReflectively(String methodName) {
        ReflectionHelpers.callInstanceMethod((Object)this.realView, (String)methodName, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    public boolean performHapticFeedback(int hapticFeedbackType) {
        this.hapticFeedbackPerformed = hapticFeedbackType;
        return true;
    }

    @Implementation
    public boolean getGlobalVisibleRect(Rect rect, Point globalOffset) {
        if (this.globalVisibleRect == null) {
            return this.directly().getGlobalVisibleRect(rect, globalOffset);
        }
        if (!this.globalVisibleRect.isEmpty()) {
            rect.set(this.globalVisibleRect);
            if (globalOffset != null) {
                rect.offset(-globalOffset.x, -globalOffset.y);
            }
            return true;
        }
        rect.setEmpty();
        return false;
    }

    public void setGlobalVisibleRect(Rect rect) {
        if (rect != null) {
            this.globalVisibleRect = new Rect();
            this.globalVisibleRect.set(rect);
        } else {
            this.globalVisibleRect = null;
        }
    }

    public int lastHapticFeedbackPerformed() {
        return this.hapticFeedbackPerformed;
    }

    public void setMyParent(ViewParent viewParent) {
        Shadow.directlyOn((Object)this.realView, View.class, (String)"assignParent", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ViewParent.class, (Object)viewParent)});
    }

    private View directly() {
        return (View)Shadow.directlyOn((Object)this.realView, View.class);
    }

    public static class WindowIdHelper {
        public static Object getWindowId(ShadowView shadowView) {
            Object attachInfo;
            if (shadowView.isAttachedToWindow() && ReflectionHelpers.getField((Object)(attachInfo = shadowView.getAttachInfo()), (String)"mWindowId") == null) {
                MyIWindowIdStub iWindowId = new MyIWindowIdStub();
                ReflectionHelpers.setField((Object)attachInfo, (String)"mWindowId", (Object)new WindowId((IWindowId)iWindowId));
                ReflectionHelpers.setField((Object)attachInfo, (String)"mIWindowId", (Object)((Object)iWindowId));
            }
            return shadowView.directly().getWindowId();
        }

        private static class MyIWindowIdStub
        extends IWindowId.Stub {
            private MyIWindowIdStub() {
            }

            public void registerFocusObserver(IWindowFocusObserver iWindowFocusObserver) throws RemoteException {
            }

            public void unregisterFocusObserver(IWindowFocusObserver iWindowFocusObserver) throws RemoteException {
            }

            public boolean isFocused() throws RemoteException {
                return true;
            }
        }
    }

    private class AnimationRunner
    implements Runnable {
        private final Animation animation;
        private long startTime;
        private long startOffset;
        private long elapsedTime;

        AnimationRunner(Animation animation) {
            this.animation = animation;
            this.start();
        }

        private void start() {
            this.startTime = this.animation.getStartTime();
            this.startOffset = this.animation.getStartOffset();
            Choreographer choreographer = ShadowChoreographer.getInstance();
            if (ShadowView.this.animationRunner != null) {
                choreographer.removeCallbacks(1, (Runnable)ShadowView.this.animationRunner, null);
            }
            ShadowView.this.animationRunner = this;
            int startDelay = this.startTime == -1L ? (int)this.startOffset : (int)(this.startTime + this.startOffset - SystemClock.uptimeMillis());
            choreographer.postCallbackDelayed(1, (Runnable)this, null, (long)startDelay);
        }

        @Override
        public void run() {
            if (this.animation.getStartTime() == this.startTime && this.animation.getStartOffset() == this.startOffset && this.animation.getTransformation(this.startTime == -1L ? SystemClock.uptimeMillis() : this.startTime + this.startOffset + this.elapsedTime, new Transformation()) && (this.animation.getRepeatCount() != -1 || this.elapsedTime < this.animation.getDuration())) {
                this.startTime = this.animation.getStartTime();
                this.elapsedTime += ShadowChoreographer.getFrameInterval() / 1000000L;
                ShadowChoreographer.getInstance().postCallback(1, (Runnable)this, null);
            } else {
                ShadowView.this.animationRunner = null;
            }
        }
    }
}

