/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.dependency;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.robolectric.MavenRoboSettings;
import org.robolectric.internal.dependency.DependencyJar;
import org.robolectric.internal.dependency.DependencyResolver;
import org.robolectric.internal.dependency.MavenArtifactFetcher;
import org.robolectric.internal.dependency.MavenJarArtifact;
import org.robolectric.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenDependencyResolver
implements DependencyResolver {
    private final ExecutorService executorService = this.createExecutorService();
    private final MavenArtifactFetcher mavenArtifactFetcher;
    private final File localRepositoryDir = this.getLocalRepositoryDir();

    public MavenDependencyResolver() {
        this(MavenRoboSettings.getMavenRepositoryUrl(), MavenRoboSettings.getMavenRepositoryId(), MavenRoboSettings.getMavenRepositoryUserName(), MavenRoboSettings.getMavenRepositoryPassword());
    }

    public MavenDependencyResolver(String repositoryUrl, String repositoryId, String repositoryUserName, String repositoryPassword) {
        this.mavenArtifactFetcher = this.createMavenFetcher(repositoryUrl, repositoryUserName, repositoryPassword, this.localRepositoryDir, this.executorService);
    }

    public URL[] getLocalArtifactUrls(DependencyJar dependency) {
        return this.getLocalArtifactUrls(new DependencyJar[]{dependency});
    }

    public URL[] getLocalArtifactUrls(DependencyJar ... dependencies) {
        ArrayList artifacts = new ArrayList(dependencies.length);
        this.whileLocked(() -> {
            for (DependencyJar dependencyJar : dependencies) {
                MavenJarArtifact artifact = new MavenJarArtifact(dependencyJar);
                artifacts.add(artifact);
                this.mavenArtifactFetcher.fetchArtifact(artifact);
            }
        });
        URL[] urls = new URL[dependencies.length];
        try {
            for (int i = 0; i < artifacts.size(); ++i) {
                MavenJarArtifact artifact = (MavenJarArtifact)artifacts.get(i);
                urls[i] = new File(this.localRepositoryDir, artifact.jarPath()).toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        return urls;
    }

    private void whileLocked(Runnable runnable) {
        File lockFile = new File(System.getProperty("user.home"), ".robolectric-download-lock");
        try (RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
             FileChannel channel = raf.getChannel();
             FileLock ignored = channel.lock();){
            runnable.run();
        }
        catch (IOException e) {
            String string = String.valueOf(lockFile);
            throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length()).append("Couldn't create lock file ").append(string).toString(), e);
        }
        finally {
            lockFile.delete();
        }
    }

    public URL getLocalArtifactUrl(DependencyJar dependency) {
        URL[] urls = this.getLocalArtifactUrls(dependency);
        if (urls.length > 0) {
            return urls[0];
        }
        return null;
    }

    protected File getLocalRepositoryDir() {
        String localRepoDir = System.getProperty("maven.repo.local");
        if (!Strings.isNullOrEmpty((String)localRepoDir)) {
            return new File(localRepoDir);
        }
        File mavenHome = new File(System.getProperty("user.home"), ".m2");
        String settingsRepoDir = this.getLocalRepositoryFromSettings(mavenHome);
        if (!Strings.isNullOrEmpty((String)settingsRepoDir)) {
            return new File(settingsRepoDir);
        }
        return new File(mavenHome, "repository");
    }

    private String getLocalRepositoryFromSettings(File mavenHome) {
        File mavenSettings = new File(mavenHome, "settings.xml");
        if (!mavenSettings.exists() || !mavenSettings.isFile()) {
            return null;
        }
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(mavenSettings);
            NodeList nodeList = document.getElementsByTagName("localRepository");
            if (nodeList.getLength() != 0) {
                Node node = nodeList.item(0);
                return node.getTextContent();
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logger.error((String)"Error reading settings.xml", (Throwable)e);
        }
        return null;
    }

    protected MavenArtifactFetcher createMavenFetcher(String repositoryUrl, String repositoryUserName, String repositoryPassword, File localRepositoryDir, ExecutorService executorService) {
        return new MavenArtifactFetcher(repositoryUrl, repositoryUserName, repositoryPassword, localRepositoryDir, executorService);
    }

    protected ExecutorService createExecutorService() {
        return Executors.newFixedThreadPool(2);
    }
}

