/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.NodeHandler;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.StaxLoader;
import org.robolectric.res.StyleData;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XmlContext;

public class StaxStyleLoader
extends StaxLoader {
    private String name;
    private String parent;
    private List<AttributeResource> attributeResources;

    public StaxStyleLoader(PackageResourceTable resourceTable, String attrType, ResType resType) {
        super(resourceTable, attrType, resType);
        this.addHandler("item", new NodeHandler(){
            private String attrName;
            private StringBuilder buf = new StringBuilder();

            @Override
            public void onStart(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
                this.attrName = xml.getAttributeValue(null, "name");
                this.buf.setLength(0);
            }

            @Override
            public void onCharacters(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
                this.buf.append(xml.getText());
            }

            @Override
            public void onEnd(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
                ResName attrResName = ResName.qualifyResName(this.attrName, xmlContext.getPackageName(), "attr");
                StaxStyleLoader.this.attributeResources.add(new AttributeResource(attrResName, this.buf.toString(), xmlContext.getPackageName()));
            }
        });
    }

    @Override
    public void onStart(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
        this.name = xml.getAttributeValue(null, "name");
        this.parent = xml.getAttributeValue(null, "parent");
        this.attributeResources = new ArrayList<AttributeResource>();
    }

    @Override
    public void onEnd(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
        int lastDot;
        String styleParent = this.parent;
        if (styleParent == null && (lastDot = this.name.lastIndexOf(46)) != -1) {
            styleParent = this.name.substring(0, lastDot);
        }
        String styleNameWithUnderscores = this.underscorize(this.name);
        StyleData styleData = new StyleData(xmlContext.getPackageName(), styleNameWithUnderscores, this.underscorize(styleParent), this.attributeResources);
        this.resourceTable.addResource("style", styleData.getName(), new TypedResource<StyleData>(styleData, this.resType, xmlContext));
    }

    private String underscorize(String s) {
        return s == null ? null : s.replace('.', '_');
    }
}

