/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LocaleDataTables {
    static final byte[][] SCRIPT_CODES = new byte[][]{{65, 104, 111, 109}, {65, 114, 97, 98}, {65, 114, 109, 105}, {65, 114, 109, 110}, {65, 118, 115, 116}, {66, 97, 109, 117}, {66, 97, 115, 115}, {66, 101, 110, 103}, {66, 114, 97, 104}, {67, 97, 110, 115}, {67, 97, 114, 105}, {67, 104, 97, 109}, {67, 104, 101, 114}, {67, 111, 112, 116}, {67, 112, 114, 116}, {67, 121, 114, 108}, {68, 101, 118, 97}, {69, 103, 121, 112}, {69, 116, 104, 105}, {71, 101, 111, 114}, {71, 111, 116, 104}, {71, 114, 101, 107}, {71, 117, 106, 114}, {71, 117, 114, 117}, {72, 97, 110, 115}, {72, 97, 110, 116}, {72, 97, 116, 114}, {72, 101, 98, 114}, {72, 108, 117, 119}, {72, 109, 110, 103}, {73, 116, 97, 108}, {74, 112, 97, 110}, {75, 97, 108, 105}, {75, 97, 110, 97}, {75, 104, 97, 114}, {75, 104, 109, 114}, {75, 110, 100, 97}, {75, 111, 114, 101}, {75, 116, 104, 105}, {76, 97, 110, 97}, {76, 97, 111, 111}, {76, 97, 116, 110}, {76, 101, 112, 99}, {76, 105, 110, 97}, {76, 105, 115, 117}, {76, 121, 99, 105}, {76, 121, 100, 105}, {77, 97, 110, 100}, {77, 97, 110, 105}, {77, 101, 114, 99}, {77, 108, 121, 109}, {77, 111, 110, 103}, {77, 114, 111, 111}, {77, 121, 109, 114}, {78, 97, 114, 98}, {78, 107, 111, 111}, {79, 103, 97, 109}, {79, 114, 107, 104}, {79, 114, 121, 97}, {80, 97, 117, 99}, {80, 104, 108, 105}, {80, 104, 110, 120}, {80, 108, 114, 100}, {80, 114, 116, 105}, {82, 117, 110, 114}, {83, 97, 109, 114}, {83, 97, 114, 98}, {83, 97, 117, 114}, {83, 103, 110, 119}, {83, 105, 110, 104}, {83, 111, 114, 97}, {83, 121, 114, 99}, {84, 97, 108, 101}, {84, 97, 108, 117}, {84, 97, 109, 108}, {84, 97, 118, 116}, {84, 101, 108, 117}, {84, 102, 110, 103}, {84, 104, 97, 97}, {84, 104, 97, 105}, {84, 105, 98, 116}, {85, 103, 97, 114}, {86, 97, 105, 105}, {88, 112, 101, 111}, {88, 115, 117, 120}, {89, 105, 105, 105}, {126, 126, 126, 65}, {126, 126, 126, 66}};
    static final Map<Integer, Byte> LIKELY_SCRIPTS;
    static final Set<Long> REPRESENTATIVE_LOCALES;
    static final Map<Integer, Integer> ARAB_PARENTS;
    static final Map<Integer, Integer> HANT_PARENTS;
    static final Map<Integer, Integer> LATN_PARENTS;
    static final Map<String, Map<Integer, Integer>> SCRIPT_PARENTS;
    static final int MAX_PARENT_DEPTH = 3;

    /*
     * Opcode count of 16177 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        Object entries = new int[][]{{0x61610000, 41}, {1633812480, 15}, {-1004535808, 41}, {-1874853888, 41}, {-1673527296, 41}, {-2141192192, 41}, {-530579456, 15}, {1634009088, 4}, {-2071986176, 1}, {0x61660000, 41}, {-1061158912, 41}, {-1193279488, 0}, {1634402304, 41}, {-1455423488, 84}, {-1251999744, 41}, {-849346560, 15}, {1634533376, 18}, {-1182793728, 41}, {-440401920, 41}, {1634861056, 1}, {1634883650, 87}, {-1977614336, 2}, {-1239416832, 41}, {-1172307968, 41}, {-1038090240, 1}, {-501219328, 1}, {-434110464, 1}, {1634926592, 7}, {-2109734912, 41}, {-1841299456, 68}, {-834666496, 41}, {-1503657984, 41}, {1635123200, 15}, {-2101346304, 16}, {1635319808, 41}, {1635385344, 41}, {1635404113, 1}, {1635404114, 1}, {1635406421, 15}, {1650524160, 15}, {-1409220608, 1}, {-1275002880, 41}, {-1140785152, 16}, {-1006567424, 41}, {-939458560, 41}, {-603914240, 5}, {-2011103232, 41}, {-1541341184, 41}, {-1606352896, 41}, {1650786304, 15}, {-1535049728, 1}, {-1333723136, 41}, {-662634496, 41}, {-461307904, 41}, {-1935605760, 41}, {-1063190528, 74}, {-861863936, 1}, {-526319616, 16}, {1650917376, 15}, {-2000617472, 16}, {-1262419968, 1}, {-591331328, 21}, {1650982912, 38}, {-2065629184, 16}, {-1595867136, 16}, {-1461649408, 41}, {-1193213952, 16}, {1651048448, 41}, {-1459552256, 41}, {-1258225664, 41}, {-1524563968, 16}, {-1256128512, 41}, {-1321140224, 41}, {-784269312, 41}, {-849281024, 75}, {1651310592, 41}, {-1048510464, 41}, {1651376128, 7}, {1651441664, 80}, {-505348096, 7}, {-1576992768, 1}, {-704577536, 41}, {1651638272, 41}, {-2111766528, 16}, {-1642004480, 1}, {-568262656, 16}, {1651703808, 41}, {-1035927552, 6}, {-901709824, 41}, {-1168048128, 41}, {-698286080, 16}, {-2105475072, 15}, {-1971257344, 41}, {-1702821888, 41}, {-1300168704, 41}, {-2036269056, 41}, {-1224671232, 18}, {-687800320, 41}, {-1826553856, 41}, {1667301376, 41}, {-1673396224, 41}, {-1136525312, 7}, {1667563520, 15}, {-2071855104, 41}, {-1732116480, 41}, {1667760128, 41}, {-1461583872, 41}, {-1327366144, 15}, {-1193148416, 41}, {-1126039552, 41}, {-991821824, 12}, {-2128478208, 1}, {-1323171840, 11}, {-2059272192, 1}, {1668218880, 41}, {-1111359488, 13}, {-907935744, 41}, {1668415488, 9}, {-1507721216, 9}, {-1440612352, 9}, {-1373503488, 9}, {-1306394624, 9}, {-903741440, 41}, {1668481024, 41}, {-2042494976, 41}, {-633208832, 9}, {-1906180096, 59}, {1668612096, 15}, {1668677632, 15}, {1668874240, 41}, {1684078592, 41}, {-1476198400, 41}, {-1006436352, 15}, {-738000896, 41}, {-2008875008, 1}, {1684340736, 41}, {-1266483200, 41}, {-993853440, 41}, {-1859977216, 41}, {-1516044288, 41}, {-1581056000, 1}, {-2042429440, 41}, {-1302134784, 41}, {-1100808192, 41}, {-2105344000, 41}, {1685454848, 78}, {-1157431296, 41}, {-754778112, 41}, {1685716992, 80}, {-802947072, 41}, {0x65650000, 41}, {-1599864832, 41}, {-1396441088, 41}, {-524025856, 17}, {-515637248, 32}, {1701576704, 21}, {1701707776, 41}, {1701730369, 86}, {1701773312, 41}, {1702035456, 41}, {-767295488, 41}, {1702100992, 41}, {-832307200, 30}, {1702166528, 41}, {-1161560064, 41}, {-823918592, 41}, {0x66610000, 1}, {-1274740736, 41}, {0x66660000, 41}, {-1331363840, 41}, {0x66690000, 41}, {-2130378752, 1}, {-1392181248, 41}, {-855310336, 41}, {0x666A0000, 41}, {0x666F0000, 41}, {-1245380608, 41}, {1718747136, 41}, {-1977286656, 41}, {-1104871424, 41}, {-970653696, 41}, {-903544832, 41}, {-1903886336, 41}, {-1031471104, 41}, {-964362240, 41}, {-695926784, 41}, {-962265088, 41}, {1719205888, 41}, {1734410240, 41}, {-2147090432, 41}, {-1744437248, 41}, {-1274675200, 24}, {-536477696, 41}, {-1339686912, 16}, {-467271680, 1}, {-1002045440, 41}, {1734606848, 41}, {-460980224, 18}, {-1262092288, 16}, {-1392115712, 41}, {-1457127424, 1}, {-786038784, 1}, {1735131136, 41}, {-1452933120, 1}, {1735262208, 41}, {-1312423936, 16}, {-1245315072, 76}, {-976879616, 41}, {-909770752, 41}, {-842661888, 20}, {-1977221120, 14}, {-836370432, 7}, {-632946688, 41}, {1735720960, 22}, {-2038038528, 41}, {-1970929664, 41}, {-964296704, 41}, {-427425792, 41}, {0x67760000, 41}, {-962199552, 16}, {-1564082176, 41}, {1751187456, 41}, {1751204685, 1}, {1751208772, 1}, {-1475936256, 24}, {-670629888, 41}, {-469303296, 1}, {1751449600, 27}, {1751711744, 16}, {-1794703360, 41}, {-1392050176, 41}, {-781778944, 28}, {-1920532480, 62}, {-1918435328, 1}, {-1851326464, 16}, {-1515782144, 29}, {-1247346688, 41}, {-1180237824, 1}, {1752104960, 41}, {-1983447040, 16}, {-1513684992, 16}, {1752301568, 41}, {-2042167296, 41}, {-1236860928, 24}, {1752432640, 41}, {1752498176, 41}, {1752760320, 3}, {1752825856, 41}, {1767964672, 41}, {-2144862208, 41}, {-2077753344, 41}, {1768161280, 41}, {1768357888, 41}, {0x69690000, 85}, {1768620032, 41}, {-850919424, 41}, {-1184366592, 41}, {1768816640, 41}, {-1649934336, 15}, {1769144320, 41}, {1769209856, 41}, {1769275392, 9}, {1769406464, 27}, {-1624768512, 41}, {1784741888, 31}, {-1341587456, 41}, {-1194786816, 41}, {1785266176, 27}, {-1987510272, 41}, {-1383530496, 16}, {-829882368, 41}, {1786118144, 41}, {1786183680, 41}, {1801519104, 19}, {-2146828288, 15}, {-2079719424, 41}, {-2012610560, 41}, {-1542848512, 41}, {-1341521920, 41}, {-1207304192, 41}, {-1943404544, 15}, {-1739980800, 41}, {-1471545344, 41}, {-1872101376, 41}, {-865468416, 79}, {-2138439680, 41}, {-1266024448, 41}, {-1196818432, 41}, {-995491840, 16}, {-525729792, 16}, {1801912320, 41}, {-1865809920, 41}, {-1127612416, 41}, {-2132148224, 41}, {-2065039360, 73}, {-1259732992, 16}, {-1058406400, 41}, {-857079808, 53}, {-655753216, 1}, {1802043392, 41}, {-787873792, 41}, {1802108928, 41}, {-1725300736, 40}, {0x6B6B0000, 15}, {1802191174, 1}, {1802191694, 1}, {1802193234, 1}, {1802194254, 1}, {-1521876992, 41}, {1802240000, 41}, {-1251344384, 41}, {1802305536, 35}, {-2054553600, 41}, {1802371072, 36}, {1802436608, 37}, {-1580597248, 15}, {-1446379520, 16}, {-909508608, 41}, {-1846935552, 41}, {-1976958976, 15}, {-1574305792, 41}, {-1507196928, 41}, {-1372979200, 41}, {-768999424, 16}, {1802698752, 1}, {-2041970688, 41}, {-1773535232, 41}, {-1639317504, 41}, {1802829824, 41}, {1802848594, 1}, {1802849346, 1}, {-1299578880, 15}, {1802895360, 15}, {-961937408, 41}, {-559284224, 1}, {1802960896, 41}, {-1293287424, 79}, {-1091960832, 1}, {1803091968, 15}, {1803109198, 1}, {1803113554, 41}, {1818296320, 41}, {-2079653888, 43}, {-1945436160, 27}, {-1744109568, 41}, {-1677000704, 1}, {-1542782976, 41}, {1818361856, 41}, {-1876230144, 15}, {-668270592, 41}, {-1135935488, 79}, {-1131741184, 42}, {-460652544, 15}, {1818689536, 41}, {1818820608, 41}, {-1794441216, 16}, {-1526005760, 41}, {-922025984, 44}, {-1121255424, 41}, {-1588920320, 1}, {-850722816, 41}, {-1249181696, 76}, {-1182072832, 41}, {1819148288, 41}, {1819213824, 40}, {-1379205120, 41}, {-439681024, 41}, {-1976893440, 1}, {1819541504, 41}, {-1704263680, 41}, {1819607040, 41}, {-2104819712, 41}, {-1165295616, 41}, {-494206976, 41}, {-427098112, 1}, {1819672576, 41}, {-1362427904, 79}, {-1624571904, 24}, {-416612352, 41}, {-1945370624, 41}, {-1811152896, 41}, {-1744044032, 16}, {-1609826304, 16}, {-1475608576, 41}, {-1274281984, 41}, {-1274263730, 55}, {-938737664, 41}, {-468975616, 41}, {-1804861440, 15}, {-1670643712, 41}, {-999555072, 41}, {-1265893376, 41}, {-997457920, 41}, {-2136211456, 1}, {-1867776000, 41}, {1835466752, 41}, {-1664352256, 41}, {-1194590208, 41}, {-1127481344, 16}, {-523501568, 41}, {1835532288, 41}, {1835597824, 41}, {-1257504768, 41}, {-921960448, 26}, {1835728896, 15}, {1835794432, 50}, {-915668992, 41}, {1835925504, 15}, {1835942734, 51}, {-1582563328, 7}, {-643039232, 53}, {-1848901632, 41}, {-1647575040, 41}, {-909377536, 41}, {1836187648, 16}, {-1909719040, 16}, {-1507065856, 15}, {-768868352, 52}, {1836253184, 41}, {1836270403, 1}, {1836271940, 1}, {1836318720, 41}, {-966000640, 16}, {-2104754176, 41}, {-896794624, 41}, {-492044288, 1}, {-1429471232, 41}, {-959709184, 16}, {-691273728, 41}, {-1964244992, 41}, {1836646400, 53}, {-687079424, 15}, {-552861696, 41}, {-418643968, 47}, {-1221853184, 1}, {1851850752, 41}, {-1274216448, 24}, {-1139998720, 41}, {-1072889856, 41}, {1851916288, 41}, {-1672675328, 41}, {1852047360, 41}, {-2006122496, 41}, {-932380672, 41}, {1852112896, 16}, {-661848064, 16}, {1852243968, 41}, {-1395851264, 41}, {-1863516160, 41}, {-655556608, 41}, {-1525874688, 41}, {-787677184, 41}, {-1188233216, 41}, {1852571648, 41}, {-1718812672, 41}, {0x6E6E0000, 41}, {-1649606656, 41}, {1852768256, 41}, {-1915944960, 39}, {-1848836096, 16}, {-1244856320, 64}, {-1173553152, 55}, {1852964864, 41}, {-1437794304, 9}, {-1169358848, 41}, {-896729088, 41}, {1853227008, 41}, {-1024655360, 41}, {1853423616, 41}, {-1290993664, 41}, {-1223884800, 41}, {-1557331968, 41}, {1868759040, 41}, {1869414400, 41}, {1869742080, 58}, {1869807616, 15}, {-1435631616, 57}, {1885405184, 23}, {1885425739, 1}, {-1743847424, 41}, {-1408303104, 60}, {-1341194240, 41}, {-1139867648, 41}, {-804323328, 41}, {-1940979712, 41}, {-1336999936, 41}, {-2005991424, 41}, {-865140736, 41}, {-1198587904, 83}, {-1397817344, 41}, {-1259405312, 61}, {-2125529088, 8}, {-1186004992, 41}, {1886126080, 41}, {-913375232, 41}, {-844169216, 21}, {-1244725248, 41}, {-2110849024, 34}, {-1909522432, 1}, {-1708195840, 41}, {0x70730000, 1}, {0x70740000, 41}, {-762380288, 41}, {1903493120, 41}, {-1970274304, 41}, {-1701838848, 41}, {-1542389760, 16}, {-1806630912, 41}, {-1534001152, 41}, {-1261371392, 41}, {-2129592320, 41}, {-1794048000, 77}, {-1794027956, 41}, {-919535616, 16}, {-850329600, 7}, {1919746048, 41}, {-1785659392, 41}, {-1181679616, 41}, {-846135296, 1}, {-779026432, 41}, {1919811584, 41}, {-1716453376, 41}, {1919877120, 41}, {-2049900544, 41}, {-1781465088, 41}, {-1301217280, 41}, {1920270336, 15}, {-1835991040, 15}, {-1701773312, 41}, {0x72770000, 41}, {-1429143552, 41}, {-753860608, 33}, {1935736832, 16}, {-1810759680, 41}, {-1676541952, 15}, {-1072562176, 41}, {-938344448, 41}, {-871235584, 41}, {-468582400, 67}, {-1137573888, 41}, {1935867904, 41}, {-1471021056, 16}, {-1269694464, 41}, {-1202585600, 41}, {-934150144, 41}, {1935933440, 1}, {-2005794816, 41}, {-1670250496, 1}, {1935998976, 41}, {-1802371072, 41}, {-1668153344, 41}, {-1601044480, 41}, {-929955840, 41}, {1936130048, 41}, {-2133721088, 56}, {-925761536, 41}, {1936195584, 41}, {-1594753024, 77}, {-1259208704, 53}, {1936261120, 69}, {-1928200192, 41}, {1936392192, 41}, {-984481792, 1}, {1936457728, 41}, {-1586364416, 41}, {-512622592, 41}, {1936523264, 41}, {-2121138176, 41}, {-1517158400, 41}, {-1248722944, 41}, {-1114505216, 65}, {-913178624, 41}, {1936588800, 41}, {-1447952384, 41}, {1936654336, 41}, {-774766592, 79}, {1936785408, 41}, {1936850944, 15}, {1936870725, 41}, {1936872015, 41}, {1936872021, 41}, {1936872530, 41}, {-2043543552, 70}, {-1238237184, 41}, {-969801728, 41}, {-567148544, 16}, {0x73730000, 41}, {-497942528, 41}, {1936982016, 41}, {-1032716288, 41}, {1937047552, 41}, {-1433272320, 41}, {-896401408, 41}, {1937113088, 41}, {0x73770000, 41}, {-2033057792, 1}, {-1965948928, 41}, {-1697513472, 41}, {-690880512, 16}, {-1225654272, 41}, {-1357774848, 7}, {-955121664, 71}, {-1355677696, 41}, {1952514048, 74}, {-1542258688, 16}, {-667746304, 41}, {-531431424, 36}, {-1938620416, 72}, {-1737293824, 16}, {-1670184960, 16}, {1952776192, 76}, {-1332543488, 41}, {-1198325760, 41}, {-862781440, 41}, {1952907264, 15}, {1952927819, 1}, {1952972800, 79}, {-1393360896, 16}, {-1057816576, 16}, {-990707712, 16}, {1953038336, 18}, {-1726808064, 18}, {-720175104, 41}, {1953169408, 41}, {-1387069440, 41}, {-984416256, 41}, {-850198528, 16}, {1953234944, 41}, {-512557056, 41}, {-1651310592, 41}, {1953366016, 41}, {1953431552, 41}, {-1714225152, 41}, {-1577910272, 41}, {1953628160, 41}, {-768409600, 41}, {-701300736, 41}, {1953693696, 41}, {-1907163136, 21}, {-1772945408, 16}, {-1705836544, 41}, {-1504509952, 80}, {0x74740000, 15}, {-1502412800, 41}, {-898433024, 79}, {-831324160, 41}, {-1298989056, 41}, {-1364000768, 41}, {-1026359296, 41}, {1954086912, 41}, {-686620672, 15}, {-1288503296, 41}, {-1334575104, 15}, {1969684480, 1}, {1969703770, 15}, {1969704270, 15}, {-2133590016, 81}, {1969946624, 15}, {-1586233344, 41}, {-2053898240, 41}, {-978059264, 7}, {-978039216, 16}, {-575406080, 7}, {1970405376, 1}, {1970929664, 41}, {1970946374, 1}, {1970946894, 15}, {-1609236480, 82}, {1986330624, 41}, {-2003501056, 41}, {-1131085824, 41}, {1986592768, 41}, {-1995112448, 41}, {-915079168, 41}, {-1785397248, 41}, {-644546560, 41}, {1986985984, 41}, {-841678848, 41}, {-1170931712, 41}, {-1231749120, 41}, {2002845696, 41}, {-1877606400, 41}, {-1407844352, 18}, {-1005191168, 41}, {-1137311744, 41}, {-1070202880, 76}, {-1003094016, 16}, {-915013632, 41}, {-1581907968, 1}, {2003763200, 41}, {-1300889600, 16}, {-761921536, 24}, {-736690176, 41}, {-1000931328, 10}, {2020081664, 41}, {-1988689920, 45}, {-1921581056, 46}, {-1785266176, 19}, {-1248395264, 48}, {-979959808, 49}, {-2118713344, 54}, {-977862656, 16}, {-1713963008, 41}, {-973668352, 63}, {-2108227584, 66}, {-967376896, 16}, {-1206386688, 41}, {-1139277824, 41}, {-736624640, 41}, {-2076704768, 41}, {2036924416, 27}, {2037317632, 41}, {-1372061696, 41}, {-2103967744, 41}, {2053177344, 41}, {-1743192064, 41}, {-1535574016, 1}, {-2137456640, 41}, {-1663500288, 77}, {2053636096, 24}, {2053652821, 25}, {2053653070, 25}, {2053654338, 25}, {2053654342, 25}, {2053654603, 25}, {2053654852, 25}, {2053655887, 25}, {2053655897, 25}, {2053656641, 25}, {2053656646, 25}, {2053656648, 25}, {2053657426, 25}, {2053657672, 25}, {2053657687, 25}, {2053657939, 25}, {2053658190, 25}, {-1583808512, 41}, {2054488064, 41}, {-2093416448, 41}};
        HashMap<Integer, Number> buildMap = new HashMap<Integer, Number>();
        for (int[] entry : entries) {
            buildMap.put(entry[0], (byte)entry[1]);
        }
        LIKELY_SCRIPTS = Collections.unmodifiableMap(buildMap);
        entries = new long[]{7016965922780968046L, 7017249532207002220L, -4314370067176262546L, -8052355576050387858L, -7187651240570817426L, -9196272063245880210L, -2278730885291740564L, 7018096211961213812L, -8899020168601902750L, 7018396305804325998L, -4557568823625943954L, -5125015775493984403L, 7019782820031722606L, -6250915669065108104L, -5377200874653125522L, -3647825172012371348L, 7020343622385297513L, -5079974311542819730L, -1891431285807549330L, 7021750941367034210L, -8493708279586591383L, -8493707192742813324L, -8493697254154998675L, -5323180764573895570L, -5034951475048909714L, -4458488476661030558L, -2152635679216869022L, -1864414073388375710L, 7022036844470955623L, -9061149703464192914L, -7908227129292657033L, -3584789079320857490L, -6458087917915900818L, 7022891195088597612L, -9025133052746697119L, 7023718002212303982L, 7024007186471870818L, 7023998424922027118L, 7089037814615601772L, -6052468140058451614L, -5476015114217753490L, -4899548812950538655L, -4323102336984451986L, -4034869791874255762L, -2593717911283470987L, -8637542052631841682L, -6619935977984920466L, -6899159172061760402L, 7090146139516269164L, -6592896826872798878L, -5728197962998123410L, -2845912931833383826L, -1981209614261062546L, -8313289437876226962L, -4566287946405024404L, -3701589134571052702L, -2260444937459501471L, 7090709012160279148L, -8592506013542418847L, -5421964192226582174L, -2539656002497518229L, 7090998213917042793L, -8871729190439389599L, -6854116557377407391L, -6277648134128438162L, -5124734300467136927L, 7091294012625220718L, -6268640934873697170L, -5403952009736784786L, -6547871782716213663L, -5394950320925084562L, -5674180056237116306L, -3368322774847097746L, -3647539328770279820L, 7092409978272707694L, -4503233162299476882L, 7092679324094262887L, 7092961941834523252L, -2170372944945648025L, -6773051746954354334L, -3026063492523133842L, 7093809682344670318L, -9069887574043691423L, -7052267257334701726L, -2440588922554321311L, 7094086686260425838L, -4449191040680627341L, -3872740205288917906L, -5016640238464699282L, -2999027592651770271L, -9042856050625514900L, -8466387605886241682L, -7313483762184915858L, -5584108063689706386L, -8745630586877414290L, -5259846670137137047L, -2954005881305336722L, -7844904085808384914L, 7161081106561856622L, -7187095987198790546L, -4881258445645975961L, -4881266185160529043L, 7162221308560372332L, -8898461642281356178L, -7439289869750143890L, 7163053639012021358L, -6277377632793168786L, -5700903652139896212L, -5124439609742101394L, -4836229102109100946L, -4259748481437506190L, -9141661519900941982L, -5682884885649792659L, -8844426104863039134L, 7165022851452466286L, -4773176482682933132L, -3899466055900105618L, 7165863904682274419L, -6475539366622957965L, -6187308990471246221L, -5899078614319534477L, -5610848238167822733L, -3881448380330576786L, 7166145487184163950L, -8772360835535113106L, -2719537277395964301L, -8186896178149755549L, 7166724908187742828L, 7166707255938408807L, 7167006383164453484L, 7167838632011723886L, 7233137566728418414L, -6340130034155424658L, -4322520691187813780L, -3169606951732415378L, -8627971860657446558L, 7234263440865457262L, -5439429977200036754L, -4268494074083707794L, -7988455254483962770L, -6511286654154476434L, -6790503212690284190L, -8772092584762706834L, -5592541322169715602L, -4727850137880005522L, -9042309627556826002L, 7239058484223304033L, -4971037967932885906L, -3241674437080026002L, 7240172280912372340L, -3448548653652675474L, 7306324346323170414L, -6871281063329434514L, -5997588177343122322L, -2250597741369001616L, -2214560122386944919L, 7308294714027042155L, 7308857595343762542L, 7308873061520995438L, 7308857595461656951L, 7310262844218504302L, 7310271661786362990L, 7310280436404548718L, -3295415211076258706L, 7310544259065672814L, -3574651577866886804L, 7310825794171925614L, -4988788487946668946L, -3538627183140309906L, 7377258282243744098L, -5474891357499591570L, 7378676635247146094L, -5718079161782668178L, 7379506745051280494L, -9149815515312397982L, -5979284658815142802L, -3673438363951467410L, 7379788224322958446L, 7381195620681348206L, -5348796095556127634L, 7382040058496382062L, -8492287706085100434L, -4745309313082231698L, -4168850815636638610L, -3880620439484926866L, -8177033588980485010L, -4430048598907849618L, -4141823655889767314L, -2988896709559356306L, -4132805530238225298L, 7384019153656575086L, 7449315820630537326L, -9221604811149839250L, -7492215974349671314L, -5474614293521404301L, -2304073601665371026L, -5753830873415453087L, -2006835966312816286L, -4303674026651192210L, 7450158033652511854L, -1979818757937928087L, -5420558994841962911L, -5979008677101603730L, -6258226348033941150L, -3375922586516823710L, 7452407707457385582L, -6240219616041082526L, 7452982777808516206L, -5636737283103820191L, -5348506906683675531L, -4195585445160979346L, -3907349537091390354L, -3619111511685893016L, -8492025996697898380L, -8492021628565623198L, -3592103052311171481L, -2718411347273354130L, 7454945358736878194L, -8753235904511773586L, -8465004441733335954L, -4141544431475919762L, -1835697037100616594L, 7455226829501199470L, -4132529501414001055L, -6717607846443125650L, 7521378920816538734L, -6339023946999828877L, -2880239620428041106L, -2015570538223476382L, 7522499344573227634L, 7523625253002901089L, -7708114952298335122L, -5978721708861721490L, -3357622284802296457L, -8248550188869979548L, -8239528709100248734L, -7951306016595544479L, -6510150893069046169L, -5357224960284593042L, -5068994571431419550L, 7525321769513743470L, -8518759569644226975L, -6501146936582244767L, 7526157445595493486L, -8770966684855864210L, -5312203231959355789L, 7526720404138849390L, 7527001883410527342L, 7528120052192800110L, 7528415769464501358L, 7593427766006084718L, -9212027991857466258L, -8923796593503538066L, 7594275429341557870L, 7595125364714730606L, 7595676250323642729L, 7596259012742575214L, -3654597149877767058L, -5086727507665652626L, 7597090179108664430L, -7086323487509745044L, 7598497618416727150L, 7598779097688405102L, 7599053893839974003L, 7599623488191947378L, -6978237096303430546L, 7665489749468012910L, -5761992552389446546L, -5131496301138971538L, 7667753579450819186L, -8536198871898819474L, -5942132126686808479L, -3564242539892345746L, 7671399572960277614L, 7671681047936988270L, 7737543997675368306L, -9220463440920219028L, -8932251756316756882L, -8644011540394970002L, -6626397833591163794L, -5761710012260846482L, -5185247030869396370L, -8346768433220062612L, -7473074563536817042L, -6320139796070960018L, -8040521437911354258L, -3717065872810417815L, -9184454452141001618L, -5437459600823454610L, -5140222042596871058L, -4275524295731087775L, -2257911662669105567L, 7739228445277779054L, -8013512029264317330L, -4842985528047340434L, -9157426291666750354L, -8869202512450589579L, -5410431401828452767L, -4545735883782785938L, -3681049144765878926L, -2816350332816039582L, 7739800195619189870L, -3383799457569999762L, 7740084951950914670L, -7410026393546690705L, 7740354387950854498L, 7740363235617501804L, -6536337909901855634L, 7740640252567581806L, -5374400444306983826L, 7740926108394614130L, -8824168711039388562L, 7741205410118263905L, 7741489101298168421L, -6788522962149870996L, -6212072135500401055L, -3906232428982602642L, -7932443877307222930L, -8490883621295918484L, -6761500303379303314L, -6473273242942344082L, -5896810235781090194L, -3302746776219060639L, 7742612784834306402L, -8770104577545374610L, -7617201820470774674L, -7040740003015461778L, 7743175747672629602L, 7743187846778942574L, -5581558262014578068L, 7743467135467876972L, -4131409150470949778L, -2402019167097953950L, 7743736434361726062L, -5554534520777580183L, -4689847777802165918L, 7744295037624803682L, 7744303803687072364L, 7744313746685785198L, 7809618067291468910L, -8931967017164378527L, -8355504091674877326L, -7490800808395443090L, -7202574894898192030L, -6626108662033058706L, 7809888633051247726L, -8058256582091640212L, -2870119779830500242L, -4878731767623163543L, -4860710772178325405L, -1978397085141470612L, 7811305843409908846L, 7811861118256772206L, -7706980230662621599L, -7706985736676217502L, -6554064206300089234L, -3959997443773729931L, -4815674818854554514L, -6824280192715693726L, -3653732856428923794L, -5365113930309604235L, -5076883528522566546L, 7813256364152681582L, 7813547721849139055L, -5923566924257463186L, -1888316330711354258L, -8490612054842777246L, 7814955178337072238L, -7319672835828255634L, 7815226688989656174L, -9040057866397846418L, -5004823799885892498L, -2122520038368775058L, -1834291805589184158L, 7815518136880428142L, -5851490621207322263L, -6977409194179596685L, -1789243714504133522L, -8355222650991053714L, -7778768457102691218L, -7490531479720200607L, -6914070727416777119L, -6337610017929071506L, -5472921049842486162L, -5472921045513310353L, -4031764805397154706L, -2014149891707538322L, -7751730332453735828L, -7175271834858720146L, -4292975787102866322L, -5436879062978956178L, -4283966384529902482L, -9174865671548149406L, -8021951807504681874L, 7883354641354814574L, -7148253458319969170L, -5130651876208839570L, -4842409392678275487L, -2248329367159475090L, 7883636120626492526L, 7883918772424242286L, -5400861295436008338L, -3959709358909983630L, 7884480558292103788L, 7884757648274127213L, -3932676821796948882L, 7885324996107137644L, 7885314001157975655L, -6796977137138700697L, -2761747477077332622L, -7940898095227636626L, -7076206966772501394L, -3905673907140463506L, 7886446497982936673L, -8202094714696665503L, -6472708038280514964L, -3302191565644861585L, 7886732418384753774L, 7887013871886627950L, -4148860556211292575L, -9039776352766430098L, -3851609765056514962L, -2113225840992820894L, -6139447201918520210L, -4121838958447069599L, -2968917496655940498L, -8436268670981671826L, 7888421216723758450L, -2950893129676787092L, -2374429138818599826L, -1797981533393293724L, -5247738848159309470L, 7953724532288746606L, -5472643968684429709L, -4896176593474325394L, -4607940801368853394L, 7954005994380555374L, -7184000788952157074L, 7954582172833248366L, -8616145461866040210L, -4004469429237615506L, 7954850423471699553L, -2842529683149064607L, 7955413309134566510L, -5995050478736411538L, -8003655921133587346L, -2815509150402775954L, -6553501325066144658L, -3382961616824732562L, -5103342202103171986L, 7956820731262760046L, -7382170214917376914L, 7957383694101083246L, -7084932639510924178L, 7957665169077793902L, -8228828274640195999L, -7940609967480539551L, -5346525625417634190L, -5040294006309032081L, 7958522728017917038L, -6175205566472688013L, -5022258772947405714L, -3851330489103059858L, 7959643207676032110L, -4400787257303141266L, 7960478853693011054L, -5544682819417967506L, -5256451425359006610L, -6688611495730645906L, 8026336280187073646L, 8029149939032487022L, 8030561686244194657L, 8030840923342074476L, -6165905841087943832L, 8097841889139646818L, 8097834205544018549L, -7489679383844522898L, -6048535156650120087L, -6048541770899755920L, -5760297126934252434L, -4895622426729024402L, -3454454053296049042L, -8336367065956780946L, -5742284931742993298L, -8615573745884367762L, -3715677219823979410L, -5147815231041280657L, -6003504713836694418L, -5409020779748102536L, -9128997319185637016L, -5093769892526459794L, 8100938118361871470L, -3922836124008876946L, -3625600756298390165L, -5345976934857608082L, -9065939240555617934L, -8201255778784222878L, 8102891924571185506L, 8103174550782571630L, -3274320058295159698L, 8175528957125424238L, -8462185272444881810L, -7309266039875734418L, -6624432976381512095L, -7759330225394977682L, -6588404222178266002L, -5417468250342460306L, -9146448767575034770L, -7705292544469995929L, -3949289291575363999L, -3652064961881608601L, 8245320470583407726L, -7669271409807231890L, -5075201327271676818L, -3634042806677118622L, -3345801491060263826L, 8245600850343457902L, -7372026064804940690L, 8245899943276016750L, -8804175238844550034L, -7651241545120517010L, -5588608377667095442L, 8247588818756661868L, -7885427733755760020L, -7308969176031202194L, 8248151777449440366L, -6138032070324030354L, -3237724948380160415L, 8314006987606423137L, -7777075230670752658L, -7200602328054271380L, -4606536707840314258L, -4030078158855113618L, -3741847739753728914L, -2012465482726017678L, -4885749898938321810L, 8314569963463603310L, -6317906726743607711L, -5453215572384713618L, -5164987472565668754L, -4012070370300300178L, 8314859096183562594L, 8314851412536555105L, 8314851412654190442L, 8314851412788473444L, -8614742510798801810L, -7173590638813617822L, 8315138389500327022L, -7741050827403332498L, -7164579006969187218L, -6876348639407410066L, -3994044929429900178L, 8315689206171137134L, -9164181729711791763L, -3976031596072307602L, -6849327140292891033L, -5408175208110920334L, 8316262073322008168L, -8281480536419896210L, 8316832719738860654L, -4228228815996690078L, 8317114186125636718L, -6813294997628947346L, -2201616710142692242L, 8317400102098531438L, -9110127539117788050L, -6516054153752382354L, -5363146925616827282L, -4786682861776179854L, -3921995044858268562L, 8317684892789994606L, -6218823145350925202L, 8317958636825572462L, -3327504505042869911L, 8318501782684791918L, 8318801979274523244L, 8318801979423945838L, -8776872123035585951L, -5318096597037255570L, -4165175109610277778L, -2435803847950240159L, 8319092173184267374L, -2138570653276474258L, 8319373648160978030L, -4435407618581629842L, 8319636444324918382L, -6155764993856801682L, -3849936329833876370L, 8319928918712874094L, 8320211583395525742L, -8731818509107830430L, -8443612390747966354L, -7290689782334524306L, -2967228603979958687L, -5264064456754629522L, -5831525706552218009L, -4102135696939453853L, -5822503079607438226L, 8386064581912522092L, -6623864520280017311L, -2867860266255551378L, -2282399985524906911L, -8326237282375734171L, -7461534050970929567L, -7173303674819217823L, 8387190481819626613L, -5723139114293693330L, -5146676184441850770L, -3705525381720083346L, 8387761115151622498L, 8387765508937183852L, 8388046975608054121L, -5984353373193406879L, -4543201492434848159L, -4254971116283136415L, 8388312009199085673L, -7416507941694183319L, -3093042450942299026L, 8388891421878350958L, -5957325199700298642L, -4227963769086446482L, -3651488766215489951L, 8389168477333714030L, -2201343936769723282L, -7092238928637234066L, 8389742392338642030L, 8390017330375128174L, -7362455928481680274L, -6776984747108109202L, 8390861768190162030L, -3300201389486934930L, -3011970991860386706L, 8391149767222195310L, -8191124878545230485L, -7614656438301526431L, -7326423897352342418L, -6461748110385651084L, 8391422531855807084L, -6452720076379294610L, -3858647786095877783L, -3570438223490354066L, -5579030476042963858L, -5858245960653507474L, -4408093550724418450L, 8392827643441017966L, -2948922804839812500L, -5533994574258539410L, -5731865899578068372L, 8459804428423291234L, 8459813276089938540L, -9163607698642083470L, 8460950063738876524L, -6812743038496836498L, -8821353961272282002L, -4200651951959609753L, -4200646445777979807L, -2471269695049339289L, 8462914933933367650L, 8465150219597799778L, 8465172295913141358L, -6911534136609904279L, 8531324305624101998L, -8604890886613928850L, -4857886096742058898L, 8532445863319008366L, -8568851077298817938L, -3930162234409257874L, -7668147726103514002L, -2768221345725451154L, -3614892599587802002L, -5029037244952775570L, -5290229440471534482L, 8602229628655989870L, -8064184104962132882L, -6046569221453485975L, -4317174921338719122L, -4884644911227243410L, -4596405768912802699L, -4308175393029523871L, -3929857665393396626L, -6794160192659234462L, 8606189008682316910L, -5587197687202744735L, -3272354075737231757L, -3163987291968277394L, -4298874607007337879L, 8676283918630089838L, -8541265455837781143L, -8253035079686069143L, -7667581477698834574L, -5361742827776545175L, -4208803773933063581L, -9099712982125809054L, -4199807526995921311L, -7361321301201292178L, -4181793111104392087L, -9054670371518582174L, -4154766024574142879L, -5181306321065905042L, -4893083697330162578L, -3163704738954775442L, -8919305062734269330L, 8750298669135262830L, -5892887191178087314L, -9036387610684984210L, 8818403548936107118L, -7486861352722402194L, -6595157384124800670L, -9180220275812109202L, -7144594390862369177L, 8820392603958603887L, 8820373873705971315L, 8820392604058349172L, -6802320716237540242L, 8824058281403184238L, -8991062468622977938L};
        HashSet<Long> buildSet = new HashSet<Long>();
        for (int[] entry : entries) {
            buildSet.add((long)entry);
        }
        REPRESENTATIVE_LOCALES = Collections.unmodifiableSet(buildSet);
        entries = new int[][]{{1634878554, 1634898976}, {1634878792, 1634898976}, {1634880601, 1634898976}, {1634880833, 1634898976}, {1634882638, 1634898976}};
        buildMap = new HashMap();
        for (int[] entry : entries) {
            buildMap.put(entry[0], entry[1]);
        }
        ARAB_PARENTS = Collections.unmodifiableMap(buildMap);
        entries = new int[][]{{2053655887, 2053654603}};
        buildMap = new HashMap();
        for (int[] entry : entries) {
            buildMap.put(entry[0], entry[1]);
        }
        HANT_PARENTS = Collections.unmodifiableMap(buildMap);
        entries = new int[][]{{1701740705, 1701741568}, {1701724487, 1701741568}, {1701724489, 1701741568}, {1701724500, 1701740705}, {1701724501, 1701741568}, {1701724738, 1701741568}, {1701724741, 1701741568}, {1701724749, 1701741568}, {1701724755, 1701741568}, {1701724759, 1701741568}, {1701724762, 1701741568}, {1701724993, 1701741568}, {1701724995, 1701741568}, {1701725000, 1701740705}, {1701725003, 1701741568}, {1701725005, 1701741568}, {1701725016, 1701741568}, {1701725017, 1701741568}, {1701725253, 1701740705}, {1701725255, 1701741568}, {1701725259, 1701740705}, {1701725261, 1701741568}, {1701725522, 1701741568}, {1701725769, 1701740705}, {1701725770, 1701741568}, {1701725771, 1701741568}, {1701725773, 1701741568}, {1701726018, 1701741568}, {1701726020, 1701741568}, {1701726023, 1701741568}, {1701726024, 1701741568}, {1701726025, 1701741568}, {1701726029, 1701741568}, {1701726041, 1701741568}, {1701726283, 1701741568}, {1701726533, 1701741568}, {1701726540, 1701741568}, {1701726541, 1701741568}, {1701726542, 1701741568}, {1701726543, 1701741568}, {1701726789, 1701741568}, {1701726797, 1701741568}, {1701727045, 1701741568}, {1701727049, 1701741568}, {1701727054, 1701741568}, {1701727065, 1701741568}, {1701727299, 1701741568}, {1701727314, 1701741568}, {1701727315, 1701741568}, {1701727559, 1701741568}, {1701727567, 1701741568}, {1701727571, 1701741568}, {1701727572, 1701741568}, {1701727573, 1701741568}, {1701727575, 1701741568}, {1701727577, 1701741568}, {1701727809, 1701741568}, {1701727814, 1701741568}, {1701727815, 1701741568}, {1701727820, 1701740705}, {1701727826, 1701741568}, {1701727829, 1701741568}, {1701727834, 1701741568}, {1701728327, 1701741568}, {1701728328, 1701741568}, {1701728331, 1701741568}, {1701728334, 1701741568}, {1701728343, 1701741568}, {1701728855, 1701741568}, {1701729090, 1701741568}, {1701729091, 1701741568}, {1701729092, 1701741568}, {1701729093, 1701740705}, {1701729095, 1701741568}, {1701729096, 1701741568}, {1701729097, 1701740705}, {1701729100, 1701741568}, {1701729107, 1701741568}, {1701729112, 1701741568}, {1701729114, 1701741568}, {1701729347, 1701741568}, {1701729355, 1701741568}, {1701729359, 1701741568}, {1701729364, 1701741568}, {1701729366, 1701741568}, {1701729370, 1701741568}, {1701729607, 1701741568}, {1701729859, 1701741568}, {1701729863, 1701741568}, {0x656E5655, 1701741568}, {1701730131, 1701741568}, {1701730881, 1701741568}, {1701730893, 1701741568}, {1701730903, 1701741568}, {1702052178, 1702077476}, {1702052431, 1702077476}, {1702052684, 1702077476}, {1702052687, 1702077476}, {1702052690, 1702077476}, {1702052693, 1702077476}, {1702052943, 1702077476}, {1702053187, 1702077476}, {1702053716, 1702077476}, {1702053966, 1702077476}, {1702055256, 1702077476}, {1702055497, 1702077476}, {1702056001, 1702077476}, {1702056005, 1702077476}, {1702056018, 1702077476}, {1702056025, 1702077476}, {1702056790, 1702077476}, {1702057299, 1702077476}, {1702057305, 1702077476}, {1702057541, 1702077476}, {1886667087, 1886670932}, {1886667606, 1886670932}, {1886668631, 1886670932}, {1886670159, 1886670932}, {1886670170, 1886670932}, {1886671700, 1886670932}, {1886671948, 1886670932}};
        buildMap = new HashMap();
        for (int[] entry : entries) {
            buildMap.put(entry[0], entry[1]);
        }
        LATN_PARENTS = Collections.unmodifiableMap(buildMap);
        HashMap<String, Map<Integer, Integer>> buildMap2 = new HashMap<String, Map<Integer, Integer>>();
        buildMap2.put("Arab", ARAB_PARENTS);
        buildMap2.put("Hant", HANT_PARENTS);
        buildMap2.put("Latn", LATN_PARENTS);
        SCRIPT_PARENTS = Collections.unmodifiableMap(buildMap2);
    }
}

