/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.jetbrains.annotations.NotNull;
import org.robolectric.res.FsFile;
import org.robolectric.res.XmlLoader;
import org.w3c.dom.Document;

public abstract class DrawableNode {
    public abstract FsFile getFsFile();

    public static class ImageFile
    extends DrawableNode {
        private final FsFile fsFile;
        public final boolean isNinePatch;

        ImageFile(FsFile fsFile, boolean ninePatch) {
            this.fsFile = fsFile;
            this.isNinePatch = ninePatch;
        }

        @Override
        public FsFile getFsFile() {
            return this.fsFile;
        }
    }

    public static class Xml
    extends DrawableNode {
        @NotNull
        public final Document document;
        @NotNull
        public final XmlLoader.XmlContext xmlContext;

        Xml(@NotNull Document document, @NotNull XmlLoader.XmlContext xmlContext) {
            this.document = document;
            this.xmlContext = xmlContext;
        }

        @Override
        public FsFile getFsFile() {
            return this.xmlContext.getXmlFile();
        }
    }
}

