/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Resources;
import android.util.TypedValue;
import java.util.LinkedHashMap;
import java.util.Map;
import org.robolectric.res.AttrData;
import org.robolectric.res.Attribute;
import org.robolectric.res.DrawableNode;
import org.robolectric.res.DrawableResourceLoader;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourceLoader;
import org.robolectric.res.TypedResource;
import org.robolectric.shadows.ResourceHelper;
import org.robolectric.util.Util;

public class Converter<T> {
    private static int nextStringCookie = 764581;
    private static final Map<String, ResType> ATTR_TYPE_MAP = new LinkedHashMap<String, ResType>();

    private static synchronized int getNextStringCookie() {
        return nextStringCookie++;
    }

    public static void convertAndFill(Attribute attribute, TypedValue outValue, ResourceLoader resourceLoader, String qualifiers, boolean resolveRefs) {
        if (attribute == null || attribute.isNull()) {
            outValue.type = 0;
            return;
        }
        TypedResource attrTypeData = resourceLoader.getValue(attribute.resName, qualifiers);
        if (attrTypeData == null) {
            return;
        }
        AttrData attrData = (AttrData)attrTypeData.getData();
        Converter.convertAndFill(attribute, outValue, resourceLoader, qualifiers, attrData, resolveRefs);
    }

    public static void convertAndFill(Attribute attribute, TypedValue outValue, ResourceLoader resourceLoader, String qualifiers, AttrData attrData, boolean resolveRefs) {
        outValue.assetCookie = Converter.getNextStringCookie();
        String format = attrData.getFormat();
        String[] types = format.split("\\|");
        if (attribute.isStyleReference()) {
            return;
        }
        ResourceIndex resourceIndex = resourceLoader.getResourceIndex();
        while (attribute.isResourceReference()) {
            ResName resName = attribute.getResourceReference();
            Integer resourceId = resourceIndex.getResourceId(resName);
            if (resourceId == null) {
                throw new Resources.NotFoundException("unknown resource " + resName);
            }
            outValue.type = 1;
            outValue.resourceId = resourceId;
            TypedResource dereferencedRef = resourceLoader.getValue(resName, qualifiers);
            if (dereferencedRef == null) {
                if (resName.type.equals("id")) {
                    return;
                }
                if (resName.type.equals("layout")) {
                    return;
                }
                if (resName.type.equals("dimen")) {
                    return;
                }
                if (resName.type.equals("transition")) {
                    return;
                }
                if (resName.type.equals("interpolator")) {
                    return;
                }
                if (resName.type.equals("menu")) {
                    return;
                }
                if (DrawableResourceLoader.isStillHandledHere(resName)) {
                    DrawableNode drawableNode = resourceLoader.getDrawableNode(resName, qualifiers);
                    if (drawableNode == null) {
                        throw new Resources.NotFoundException("can't find file for " + resName);
                    }
                    outValue.type = 3;
                    outValue.data = 0;
                    outValue.assetCookie = Converter.getNextStringCookie();
                    outValue.string = drawableNode.getFsFile().getPath();
                    return;
                }
                throw new RuntimeException("huh? " + resName);
            }
            if (dereferencedRef.isFile()) {
                outValue.type = 3;
                outValue.data = 0;
                outValue.assetCookie = Converter.getNextStringCookie();
                outValue.string = dereferencedRef.asString();
                return;
            }
            if (!(dereferencedRef.getData() instanceof String)) break;
            attribute = new Attribute(attribute.resName, dereferencedRef.asString(), resName.packageName);
            if (attribute.isResourceReference()) continue;
            if (!resolveRefs) break;
            Converter.getConverter(dereferencedRef.getResType()).fillTypedValue(attribute.value, outValue);
            return;
        }
        if (attribute.isNull()) {
            outValue.type = 0;
            return;
        }
        if (format.equals("integer|enum") || format.equals("dimension|enum")) {
            types = attribute.value.matches("^\\d.*") ? new String[]{types[0]} : new String[]{"enum"};
        }
        for (String type : types) {
            Converter converter;
            if ("reference".equals(type)) continue;
            Converter converter2 = converter = ATTR_TYPE_MAP.containsKey(type) ? Converter.getConverter(ATTR_TYPE_MAP.get(type)) : null;
            if (converter == null) {
                if (type.equals("enum")) {
                    converter = new EnumConverter(attrData);
                } else if (type.equals("flag")) {
                    converter = new FlagConverter(attrData);
                }
            }
            if (converter == null) continue;
            try {
                converter.fillTypedValue(attribute.value, outValue);
            }
            catch (Exception e) {
                throw new RuntimeException("error converting " + attribute.value + " using " + converter.getClass().getSimpleName(), e);
            }
            return;
        }
    }

    public static Converter getConverter(ResType resType) {
        switch (resType) {
            case ATTR_DATA: {
                return new FromAttrData();
            }
            case BOOLEAN: {
                return new FromBoolean();
            }
            case CHAR_SEQUENCE: {
                return new FromCharSequence();
            }
            case COLOR: {
                return new FromColor();
            }
            case COLOR_STATE_LIST: {
                return new FromFilePath();
            }
            case DIMEN: {
                return new FromDimen();
            }
            case FILE: {
                return new FromFile();
            }
            case FLOAT: {
                return new FromFloat();
            }
            case INTEGER: {
                return new FromInt();
            }
            case FRACTION: {
                return new FromFraction();
            }
            case DRAWABLE: {
                return new FromDrawableValue();
            }
            case LAYOUT: {
                return new FromFilePath();
            }
            case CHAR_SEQUENCE_ARRAY: 
            case INTEGER_ARRAY: {
                return new FromArray();
            }
        }
        throw new UnsupportedOperationException(resType.name());
    }

    public CharSequence asCharSequence(TypedResource typedResource) {
        throw this.cantDo("asCharSequence");
    }

    public int asInt(TypedResource typedResource) {
        throw this.cantDo("asInt");
    }

    public TypedResource[] getItems(TypedResource typedResource) {
        throw this.cantDo("getItems");
    }

    public void fillTypedValue(T data, TypedValue typedValue) {
        throw this.cantDo("fillTypedValue");
    }

    private UnsupportedOperationException cantDo(String operation) {
        return new UnsupportedOperationException(this.getClass().getName() + " doesn't support " + operation);
    }

    private static int convertInt(String rawValue) {
        try {
            return (int)Long.parseLong(rawValue);
        }
        catch (NumberFormatException nfe) {
            try {
                return Long.decode(rawValue).intValue();
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(rawValue + " is not an integer.", nfe);
            }
        }
    }

    private static boolean convertBool(String rawValue) {
        if ("true".equalsIgnoreCase(rawValue)) {
            return true;
        }
        if ("false".equalsIgnoreCase(rawValue)) {
            return false;
        }
        try {
            int intValue = Integer.parseInt(rawValue);
            return intValue != 0;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ATTR_TYPE_MAP.put("boolean", ResType.BOOLEAN);
        ATTR_TYPE_MAP.put("color", ResType.COLOR);
        ATTR_TYPE_MAP.put("dimension", ResType.DIMEN);
        ATTR_TYPE_MAP.put("float", ResType.FLOAT);
        ATTR_TYPE_MAP.put("integer", ResType.INTEGER);
        ATTR_TYPE_MAP.put("string", ResType.CHAR_SEQUENCE);
        ATTR_TYPE_MAP.put("fraction", ResType.FRACTION);
    }

    private static class EnumOrFlagConverter
    extends Converter<String> {
        private final AttrData attrData;

        public EnumOrFlagConverter(AttrData attrData) {
            this.attrData = attrData;
        }

        protected int findValueFor(String key) {
            String valueFor = this.attrData.getValueFor(key);
            if (valueFor == null) {
                if (this.attrData.isValue(key)) {
                    valueFor = key;
                } else {
                    throw new RuntimeException("no value found for " + key);
                }
            }
            return Util.parseInt((String)valueFor);
        }
    }

    private static class FlagConverter
    extends EnumOrFlagConverter {
        public FlagConverter(AttrData attrData) {
            super(attrData);
        }

        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            int flags = 0;
            for (String key : data.split("\\|")) {
                flags |= this.findValueFor(key);
            }
            typedValue.type = 17;
            typedValue.data = flags;
            typedValue.assetCookie = 0;
        }
    }

    private static class EnumConverter
    extends EnumOrFlagConverter {
        public EnumConverter(AttrData attrData) {
            super(attrData);
        }

        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 17;
            typedValue.data = this.findValueFor(data);
            typedValue.assetCookie = 0;
        }
    }

    private static class FromDimen
    extends Converter<String> {
        private FromDimen() {
        }

        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            ResourceHelper.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromBoolean
    extends Converter<String> {
        private FromBoolean() {
        }

        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 18;
            typedValue.data = Converter.convertBool(data) ? 1 : 0;
            typedValue.assetCookie = 0;
        }
    }

    private static class FromFloat
    extends Converter<String> {
        private FromFloat() {
        }

        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            ResourceHelper.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromFile
    extends Converter<FsFile> {
        private FromFile() {
        }

        @Override
        public void fillTypedValue(FsFile data, TypedValue typedValue) {
            typedValue.type = 3;
            typedValue.data = 0;
            typedValue.string = data.getPath();
            typedValue.assetCookie = Converter.getNextStringCookie();
        }
    }

    private static class FromFraction
    extends Converter<String> {
        private FromFraction() {
        }

        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            ResourceHelper.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromInt
    extends Converter<String> {
        private FromInt() {
        }

        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 17;
            typedValue.data = Converter.convertInt(data);
            typedValue.assetCookie = 0;
        }

        @Override
        public int asInt(TypedResource typedResource) {
            return Converter.convertInt(typedResource.asString().trim());
        }
    }

    public static class FromArray
    extends Converter {
        @Override
        public TypedResource[] getItems(TypedResource typedResource) {
            return (TypedResource[])typedResource.getData();
        }
    }

    private static class FromFilePath
    extends Converter<String> {
        private FromFilePath() {
        }

        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 3;
            typedValue.data = 0;
            typedValue.string = data;
            typedValue.assetCookie = Converter.getNextStringCookie();
        }
    }

    public static class FromDrawableValue
    extends Converter<String> {
        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 28;
            typedValue.data = ResourceHelper.getColor(data);
            typedValue.assetCookie = 0;
        }

        @Override
        public int asInt(TypedResource typedResource) {
            return ResourceHelper.getColor(typedResource.asString().trim());
        }
    }

    public static class FromColor
    extends Converter<String> {
        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 28;
            typedValue.data = ResourceHelper.getColor(data);
            typedValue.assetCookie = 0;
        }

        @Override
        public int asInt(TypedResource typedResource) {
            return ResourceHelper.getColor(typedResource.asString().trim());
        }
    }

    public static class FromCharSequence
    extends Converter<String> {
        @Override
        public CharSequence asCharSequence(TypedResource typedResource) {
            return typedResource.asString().trim();
        }

        @Override
        public int asInt(TypedResource typedResource) {
            return Converter.convertInt(typedResource.asString().trim());
        }

        @Override
        public void fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 3;
            typedValue.data = 0;
            typedValue.assetCookie = Converter.getNextStringCookie();
            typedValue.string = data;
        }
    }

    public static class FromAttrData
    extends Converter<AttrData> {
        @Override
        public CharSequence asCharSequence(TypedResource typedResource) {
            return typedResource.asString();
        }

        @Override
        public void fillTypedValue(AttrData data, TypedValue typedValue) {
            typedValue.type = 3;
            throw new RuntimeException("huh?");
        }
    }
}

