/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowNetworkInfo;

@Implements(value=ConnectivityManager.class)
public class ShadowConnectivityManager {
    private NetworkInfo activeNetwork;
    private boolean backgroundDataSetting;
    private int networkPreference = 1;
    private final Map<Integer, NetworkInfo> networkTypeToNetworkInfo = new HashMap<Integer, NetworkInfo>();

    public ShadowConnectivityManager() {
        NetworkInfo wifi = ShadowNetworkInfo.newInstance(NetworkInfo.DetailedState.DISCONNECTED, 1, 0, true, false);
        this.networkTypeToNetworkInfo.put(1, wifi);
        NetworkInfo mobile = ShadowNetworkInfo.newInstance(NetworkInfo.DetailedState.CONNECTED, 0, 2, true, true);
        this.networkTypeToNetworkInfo.put(0, mobile);
        this.activeNetwork = mobile;
    }

    @Implementation
    public NetworkInfo getActiveNetworkInfo() {
        return this.activeNetwork;
    }

    @Implementation
    public NetworkInfo[] getAllNetworkInfo() {
        return this.networkTypeToNetworkInfo.values().toArray(new NetworkInfo[this.networkTypeToNetworkInfo.size()]);
    }

    @Implementation
    public NetworkInfo getNetworkInfo(int networkType) {
        return this.networkTypeToNetworkInfo.get(networkType);
    }

    @Implementation
    public boolean getBackgroundDataSetting() {
        return this.backgroundDataSetting;
    }

    @Implementation
    public void setNetworkPreference(int preference) {
        this.networkPreference = preference;
    }

    @Implementation
    public int getNetworkPreference() {
        return this.networkPreference;
    }

    public void setNetworkInfo(int networkType, NetworkInfo networkInfo) {
        this.networkTypeToNetworkInfo.put(networkType, networkInfo);
    }

    @HiddenApi
    @Implementation
    public void setBackgroundDataSetting(boolean b) {
        this.backgroundDataSetting = b;
    }

    public void setActiveNetworkInfo(NetworkInfo info) {
        this.activeNetwork = info;
        if (info != null) {
            this.networkTypeToNetworkInfo.put(info.getType(), info);
        } else {
            this.networkTypeToNetworkInfo.clear();
        }
    }
}

