/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.MediaPlayer;
import android.net.Uri;
import android.widget.VideoView;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowSurfaceView;

@Implements(value=VideoView.class)
public class ShadowVideoView
extends ShadowSurfaceView {
    private MediaPlayer.OnCompletionListener completionListner;
    private MediaPlayer.OnErrorListener errorListener;
    private MediaPlayer.OnPreparedListener preparedListener;
    private Uri uri;
    private String path;
    public static final int STOP = 0;
    public static final int START = 1;
    public static final int SUSPEND = 2;
    public static final int PAUSE = 3;
    public static final int RESUME = 4;
    private int currentState = -1;
    private int prevState;
    private int currentPosition;

    @Implementation
    public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        this.preparedListener = l;
    }

    @Implementation
    public void setOnErrorListener(MediaPlayer.OnErrorListener l) {
        this.errorListener = l;
    }

    @Implementation
    public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        this.completionListner = l;
    }

    @Implementation
    public void setVideoPath(String path) {
        this.path = path;
    }

    @Implementation
    public void setVideoURI(Uri uri) {
        this.uri = uri;
    }

    @Implementation
    public void start() {
        this.savePrevState();
        this.currentState = 1;
    }

    @Implementation
    public void stopPlayback() {
        this.savePrevState();
        this.currentState = 0;
    }

    @Implementation
    public void suspend() {
        this.savePrevState();
        this.currentState = 2;
    }

    @Implementation
    public void pause() {
        this.savePrevState();
        this.currentState = 3;
    }

    @Implementation
    public void resume() {
        this.savePrevState();
        this.currentState = 4;
    }

    @Implementation
    public boolean isPlaying() {
        return this.currentState == 1;
    }

    @Implementation
    public boolean canPause() {
        return this.currentState != 3 && this.currentState != 0 && this.currentState != 2;
    }

    @Implementation
    public void seekTo(int msec) {
        this.currentPosition = msec;
    }

    @Implementation
    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public MediaPlayer.OnPreparedListener getOnPreparedListener() {
        return this.preparedListener;
    }

    public MediaPlayer.OnErrorListener getOnErrorListener() {
        return this.errorListener;
    }

    public MediaPlayer.OnCompletionListener getOnCompletionListener() {
        return this.completionListner;
    }

    public String getVideoPath() {
        return this.path;
    }

    public String getVideoURIString() {
        return this.uri == null ? null : this.uri.toString();
    }

    public int getCurrentVideoState() {
        return this.currentState;
    }

    public int getPrevVideoState() {
        return this.prevState;
    }

    private void savePrevState() {
        this.prevState = this.currentState;
    }
}

