/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.LayoutAnimationController;
import java.io.PrintStream;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ViewGroup.class)
public class ShadowViewGroup
extends ShadowView {
    @RealObject
    protected ViewGroup realViewGroup;
    private Animation.AnimationListener animListener;
    private LayoutAnimationController layoutAnim;
    private boolean disallowInterceptTouchEvent = false;
    private MotionEvent interceptedTouchEvent;

    @Implementation
    public void addView(final View child, final int index, final ViewGroup.LayoutParams params) {
        Shadows.shadowOf(Looper.getMainLooper()).runPaused(new Runnable(){

            @Override
            public void run() {
                Shadow.directlyOn((Object)ShadowViewGroup.this.realViewGroup, ViewGroup.class, (String)"addView", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(View.class, (Object)child), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)index), ReflectionHelpers.ClassParameter.from(ViewGroup.LayoutParams.class, (Object)params)});
            }
        });
    }

    @Override
    public String innerText() {
        String innerText = "";
        String delimiter = "";
        for (int i = 0; i < this.realViewGroup.getChildCount(); ++i) {
            View child = this.realViewGroup.getChildAt(i);
            String childText = Shadows.shadowOf(child).innerText();
            if (childText.length() > 0) {
                innerText = innerText + delimiter;
                delimiter = " ";
            }
            innerText = innerText + childText;
        }
        return innerText;
    }

    @Override
    public void dump(PrintStream out, int indent) {
        this.dumpFirstPart(out, indent);
        if (this.realViewGroup.getChildCount() > 0) {
            out.println(">");
            for (int i = 0; i < this.realViewGroup.getChildCount(); ++i) {
                View child = this.realViewGroup.getChildAt(i);
                Shadows.shadowOf(child).dump(out, indent + 2);
            }
            this.dumpIndent(out, indent);
            out.println("</" + this.realView.getClass().getSimpleName() + ">");
        } else {
            out.println("/>");
        }
    }

    @Implementation
    public void setLayoutAnimationListener(Animation.AnimationListener listener) {
        this.animListener = listener;
    }

    @Implementation
    public Animation.AnimationListener getLayoutAnimationListener() {
        return this.animListener;
    }

    @Implementation
    public void setLayoutAnimation(LayoutAnimationController layoutAnim) {
        this.layoutAnim = layoutAnim;
    }

    @Implementation
    public LayoutAnimationController getLayoutAnimation() {
        return this.layoutAnim;
    }

    @Implementation
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        this.disallowInterceptTouchEvent = disallowIntercept;
    }

    public boolean getDisallowInterceptTouchEvent() {
        return this.disallowInterceptTouchEvent;
    }

    protected void removedChild(View child) {
        if (this.isAttachedToWindow()) {
            Shadows.shadowOf(child).callOnDetachedFromWindow();
        }
    }

    public MotionEvent getInterceptedTouchEvent() {
        return this.interceptedTouchEvent;
    }

    @Implementation
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.interceptedTouchEvent = ev;
        return false;
    }

    @Implements(value=ViewGroup.MarginLayoutParams.class)
    public static class ShadowMarginLayoutParams
    extends ShadowLayoutParams {
        @RealObject
        private ViewGroup.MarginLayoutParams realMarginLayoutParams;

        @Implementation
        public void setMargins(int left, int top, int right, int bottom) {
            this.realMarginLayoutParams.leftMargin = left;
            this.realMarginLayoutParams.topMargin = top;
            this.realMarginLayoutParams.rightMargin = right;
            this.realMarginLayoutParams.bottomMargin = bottom;
        }
    }

    @Implements(value=ViewGroup.LayoutParams.class)
    public static class ShadowLayoutParams {
        @RealObject
        private ViewGroup.LayoutParams realLayoutParams;

        public void __constructor__(int w, int h) {
            this.realLayoutParams.width = w;
            this.realLayoutParams.height = h;
        }

        public void __constructor__(ViewGroup.LayoutParams source) {
            this.__constructor__(source.width, source.height);
        }
    }
}

