package org.robolectric.fakes;

import android.webkit.WebSettings;

/**
 * Robolectric implementation of {@link android.webkit.WebSettings}.
 */
public class RoboWebSettings extends WebSettings {
  private boolean allowContentAccess = true;
  private boolean allowFileAccess = true;
  private boolean allowFileAccessFromFile = true;
  private boolean allowUniversalAccessFromFile = true;
  private boolean appCacheEnabled = false;
  private boolean blockNetworkImage = false;
  private boolean blockNetworkLoads = false;
  private boolean builtInZoomControls = true;
  private boolean databaseEnabled = false;
  private boolean domStorageEnabled = false;
  private boolean geolocationEnabled = false;
  private boolean javaScriptEnabled = false;
  private boolean javaScriptCanOpenWindowAutomatically = false;
  private boolean lightTouchEnabled = false;
  private boolean loadWithOverviewMode = false;
  private boolean needInitialFocus = false;
  private RenderPriority renderPriority = RenderPriority.NORMAL;
  private boolean pluginsEnabled = false;
  private boolean saveFormData = false;
  private String appCachePath = "appcache";
  private String databasePath = "database";
  private String geolocationDatabasePath = "geolocation";
  private WebSettings.PluginState pluginState = WebSettings.PluginState.OFF;
  private boolean supportMultipleWindows = false;
  private boolean supportZoom = true;
  private String userAgentString = "Mozilla/5.0 (Linux; U; Android 4.0.3; ko-kr; LG-L160L Build/IML74K) AppleWebkit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30";
  private boolean useWideViewPort = false;
  private int cacheMode;
  private long appCacheMaxSize;
  private int textZoom = 100;
  private boolean displayZoomControls;
  private WebSettings.LayoutAlgorithm layoutAlgorithm = WebSettings.LayoutAlgorithm.NARROW_COLUMNS;
  private String defaultTextEncoding = "UTF-8";
  private int defaultFontSize = 16;

  @Override
  public void setAllowContentAccess(boolean allow) {
    allowContentAccess = allow;
  }

  @Override
  public boolean getAllowContentAccess() {
    return allowContentAccess;
  }

  @Override
  public boolean getAllowFileAccessFromFileURLs() {
    return allowFileAccessFromFile;
  }

  @Override
  public boolean getAllowUniversalAccessFromFileURLs() {
    return allowUniversalAccessFromFile;
  }

  @Override
  public void setAllowFileAccessFromFileURLs(boolean allow) {
    allowFileAccessFromFile = allow;
  }

  @Override
  public void setAllowUniversalAccessFromFileURLs(boolean allow) {
    allowUniversalAccessFromFile = allow;
  }

  @Override
  public boolean getAllowFileAccess() {
    return allowFileAccess;
  }

  @Override
  public void setAllowFileAccess(boolean allow) {
    allowFileAccess = allow;
  }

  @Override
  public synchronized boolean getBlockNetworkImage() {
    return blockNetworkImage;
  }

  @Override
  public synchronized void setBlockNetworkImage(boolean flag) {
    blockNetworkImage = flag;
  }

  @Override
  public synchronized boolean getBlockNetworkLoads() {
    return blockNetworkLoads;
  }

  @Override
  public synchronized void setBlockNetworkLoads(boolean flag) {
    blockNetworkLoads = flag;
  }

  @Override
  public boolean getBuiltInZoomControls() {
    return builtInZoomControls;
  }

  @Override
  public void setBuiltInZoomControls(boolean enabled) {
    builtInZoomControls = enabled;
  }

  @Override
  public synchronized boolean getDatabaseEnabled() {
    return databaseEnabled;
  }

  @Override
  public synchronized void setDatabaseEnabled(boolean flag) {
    databaseEnabled = flag;
  }

  @Override
  public synchronized boolean getDomStorageEnabled() {
    return domStorageEnabled;
  }

  @Override
  public synchronized void setDomStorageEnabled(boolean flag) {
    domStorageEnabled = flag;
  }

  @Override
  public synchronized boolean getJavaScriptEnabled() {
    return javaScriptEnabled;
  }

  @Override
  public synchronized void setJavaScriptEnabled(boolean flag) {
    javaScriptEnabled = flag;
  }

  @Override
  public boolean getLightTouchEnabled() {
    return lightTouchEnabled;
  }

  @Override
  public void setLightTouchEnabled(boolean flag) {
    lightTouchEnabled = flag;
  }

  @Override
  public boolean getLoadWithOverviewMode() {
    return loadWithOverviewMode;
  }

  @Override
  public void setLoadWithOverviewMode(boolean flag) {
    loadWithOverviewMode = flag;
  }

  // > API 17
  private boolean mediaPlaybackRequiresUserGesture = true;

  @Override
  public boolean getMediaPlaybackRequiresUserGesture() {
    return mediaPlaybackRequiresUserGesture;
  }

  @Override
  public void setMediaPlaybackRequiresUserGesture(boolean require) {
    mediaPlaybackRequiresUserGesture = require;
  }

  public boolean getNeedInitialFocus() {
    return needInitialFocus;
  }

  @Override
  public void setNeedInitialFocus(boolean flag) {
    needInitialFocus = flag;
  }

  @Override
  public synchronized void setRenderPriority(RenderPriority priority) {
    renderPriority = priority;
  }

  public RenderPriority getRenderPriority() {
    return renderPriority;
  }

  @Override
  public synchronized boolean getPluginsEnabled() {
    return pluginsEnabled;
  }

  @Override
  public synchronized void setPluginsEnabled(boolean flag) {
    pluginsEnabled = flag;
  }

  @Override
  public synchronized WebSettings.PluginState getPluginState() {
    return pluginState;
  }

  @Override
  public synchronized void setPluginState(WebSettings.PluginState state) {
    pluginState = state;
  }

  public boolean getSupportMultipleWindows() {
    return supportMultipleWindows;
  }

  @Override
  public synchronized void setDatabasePath(String path) {
    databasePath = path;
  }

  @Override
  public synchronized String getDatabasePath() {
    return databasePath;
  }

  @Override
  public synchronized void setSupportMultipleWindows(boolean support) {
    supportMultipleWindows = support;
  }

  public boolean getSupportZoom() {
    return supportZoom;
  }

  @Override
  public void setSupportZoom(boolean support) {
    supportZoom = support;
  }

  @Override
  public synchronized void setUserAgentString(String ua) {
    userAgentString = ua;
  }

  @Override
  public synchronized String getUserAgentString() {
    return userAgentString;
  }

  @Override
  public void setCacheMode(int mode) {
    this.cacheMode = mode;
  }

  @Override
  public int getCacheMode() {
    return cacheMode;
  }


  // API 21
  private int mixedContentMode;

  @Override
  public void setMixedContentMode(int mixedContentMode) {
    this.mixedContentMode = mixedContentMode;
  }

  @Override
  public int getMixedContentMode() {
    return mixedContentMode;
  }

  @Override
  public void setVideoOverlayForEmbeddedEncryptedVideoEnabled(boolean b) {

  }

  @Override
  public boolean getVideoOverlayForEmbeddedEncryptedVideoEnabled() {
    return false;
  }
  // End API 21

  @Override
  public boolean getUseWideViewPort() {
    return useWideViewPort;
  }

  @Override
  public void setUseWideViewPort(boolean useWideViewPort) {
    this.useWideViewPort = useWideViewPort;
  }

  @Override
  public void setAppCacheMaxSize(long appCacheMaxSize) {
    this.appCacheMaxSize = appCacheMaxSize;
  }

  public long getAppCacheMaxSize() {
    return appCacheMaxSize;
  }

  public String getAppCachePath() {
    return appCachePath;
  }

  @Override
  public void setAppCachePath(String appCachePath) {
    this.appCachePath = appCachePath;
  }

  public boolean getAppCacheEnabled() {
    return appCacheEnabled;
  }

  @Override
  public void setAppCacheEnabled(boolean appCacheEnabled) {
    this.appCacheEnabled = appCacheEnabled;
  }

  @Override
  public boolean getSaveFormData() {
    return saveFormData;
  }

  @Override
  public void setSaveFormData(boolean saveFormData) {
    this.saveFormData = saveFormData;
  }

  public String getGeolocationDatabasePath() {
    return geolocationDatabasePath;
  }

  @Override
  public void setGeolocationDatabasePath(String geolocationDatabasePath) {
    this.geolocationDatabasePath = geolocationDatabasePath;
  }

  public boolean getGeolocationEnabled() {
    return geolocationEnabled;
  }

  @Override
  public void setGeolocationEnabled(boolean geolocationEnabled) {
    this.geolocationEnabled = geolocationEnabled;
  }

  @Override
  public void setJavaScriptCanOpenWindowsAutomatically(boolean javaScriptCanOpenWindowAutomatically) {
    this.javaScriptCanOpenWindowAutomatically = javaScriptCanOpenWindowAutomatically;
  }

  @Override
  public boolean getJavaScriptCanOpenWindowsAutomatically() {
    return this.javaScriptCanOpenWindowAutomatically;
  }

  @Override
  public int getTextZoom() {
    return textZoom;
  }

  @Override
  public void setTextZoom(int textZoom) {
    this.textZoom = textZoom;
  }

  @Override
  public synchronized void setLayoutAlgorithm(WebSettings.LayoutAlgorithm algorithm) {
    this.layoutAlgorithm = algorithm;
  }

  @Override
  public void setDisplayZoomControls(boolean enabled) {
    displayZoomControls = enabled;
  }

  @Override
  public boolean getDisplayZoomControls() {
    return displayZoomControls;
  }

  @Override
  public String getDefaultTextEncodingName() {
    return this.defaultTextEncoding;
  }

  @Override
  public void setDefaultTextEncodingName(String defaultTextEncoding) {
    this.defaultTextEncoding = defaultTextEncoding;
  }

  @Override
  public int getDefaultFontSize() {
    return defaultFontSize;
  }

  @Override
  public void setDefaultFontSize(int defaultFontSize) {
    this.defaultFontSize = defaultFontSize;
  }
}
