/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.res.Attribute;
import org.robolectric.res.DrawableNode;
import org.robolectric.res.DrawableResourceLoader;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourceLoader;
import org.robolectric.res.Style;
import org.robolectric.res.StyleData;
import org.robolectric.res.TypedResource;
import org.robolectric.res.builder.ResourceParser;
import org.robolectric.shadows.Converter;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowResources;
import org.robolectric.util.Strings;

@Implements(value=AssetManager.class)
public final class ShadowAssetManager {
    public static final int STYLE_NUM_ENTRIES = 6;
    public static final int STYLE_TYPE = 0;
    public static final int STYLE_DATA = 1;
    public static final int STYLE_ASSET_COOKIE = 2;
    public static final int STYLE_RESOURCE_ID = 3;
    public static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    public static final int STYLE_DENSITY = 5;
    private String qualifiers = "";
    private Map<Long, Resources.Theme> themesById = new LinkedHashMap<Long, Resources.Theme>();
    private Map<Long, List<OverlayedStyle>> appliedStyles = new HashMap<Long, List<OverlayedStyle>>();
    private int nextInternalThemeId = 1000;
    private AndroidManifest appManifest;
    private ResourceLoader resourceLoader;

    static AssetManager bind(AssetManager assetManager, AndroidManifest androidManifest, ResourceLoader resourceLoader) {
        ShadowAssetManager shadowAssetManager = Shadows.shadowOf(assetManager);
        if (shadowAssetManager.appManifest != null) {
            throw new RuntimeException("ResourceLoader already set!");
        }
        shadowAssetManager.appManifest = androidManifest;
        shadowAssetManager.resourceLoader = resourceLoader;
        return assetManager;
    }

    @HiddenApi
    @Implementation
    public CharSequence getResourceText(int ident) {
        TypedResource value = this.getAndResolve(ident, this.getQualifiers(), true);
        if (value == null) {
            return null;
        }
        return (CharSequence)value.getData();
    }

    @HiddenApi
    @Implementation
    public CharSequence getResourceBagText(int ident, int bagEntryId) {
        throw new UnsupportedOperationException();
    }

    @HiddenApi
    @Implementation
    public String[] getResourceStringArray(int id2) {
        CharSequence[] resourceTextArray = this.getResourceTextArray(id2);
        if (resourceTextArray == null) {
            return null;
        }
        String[] strings = new String[resourceTextArray.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = resourceTextArray[i].toString();
        }
        return strings;
    }

    @HiddenApi
    @Implementation
    public int getResourceIdentifier(String name, String defType, String defPackage) {
        ResName resName;
        ResourceIndex resourceIndex = this.resourceLoader.getResourceIndex();
        Integer resourceId = resourceIndex.getResourceId(resName = ResName.qualifyResName((String)name, (String)defPackage, (String)defType));
        if (resourceId == null) {
            return 0;
        }
        return resourceId;
    }

    @HiddenApi
    @Implementation
    public boolean getResourceValue(int ident, int density, TypedValue outValue, boolean resolveRefs) {
        TypedResource value = this.getAndResolve(ident, this.getQualifiers(), resolveRefs);
        if (value == null) {
            return false;
        }
        this.getConverter(value).fillTypedValue(value.getData(), outValue);
        return true;
    }

    private Converter getConverter(TypedResource value) {
        return Converter.getConverter((ResType)value.getResType());
    }

    @HiddenApi
    @Implementation
    public CharSequence[] getResourceTextArray(int id2) {
        ResName resName = this.resourceLoader.getResourceIndex().getResName(id2);
        if (resName == null) {
            throw new Resources.NotFoundException("unknown resource " + id2);
        }
        TypedResource value = this.getAndResolve(resName, this.getQualifiers(), true);
        if (value == null) {
            return null;
        }
        TypedResource[] items = this.getConverter(value).getItems(value);
        CharSequence[] charSequences = new CharSequence[items.length];
        for (int i = 0; i < items.length; ++i) {
            TypedResource typedResource = this.resolve(items[i], this.getQualifiers(), resName);
            charSequences[i] = this.getConverter(typedResource).asCharSequence(typedResource);
        }
        return charSequences;
    }

    @HiddenApi
    @Implementation
    public boolean getThemeValue(long theme, int ident, TypedValue outValue, boolean resolveRefs) {
        ResourceIndex resourceIndex = this.resourceLoader.getResourceIndex();
        ResName resName = resourceIndex.getResName(ident);
        Resources.Theme theTheme = this.getThemeByInternalId(theme);
        int styleResourceId = Shadows.shadowOf(theTheme).getStyleResourceId();
        ResName themeStyleName = resourceIndex.getResName(styleResourceId);
        if (themeStyleName == null) {
            return false;
        }
        Style themeStyle = ShadowAssetManager.resolveStyle(this.resourceLoader, null, themeStyleName, this.getQualifiers());
        if (themeStyle != null) {
            List<OverlayedStyle> overlayThemeStyles = this.getOverlayThemeStyles(styleResourceId);
            Attribute attrValue = ShadowResources.getOverlayedThemeValue(resName, themeStyle, overlayThemeStyles);
            while (resolveRefs && attrValue != null && attrValue.isStyleReference()) {
                ResName attrResName = new ResName(attrValue.contextPackageName, "attr", attrValue.value.substring(1));
                attrValue = ShadowResources.getOverlayedThemeValue(attrResName, themeStyle, overlayThemeStyles);
            }
            if (attrValue != null) {
                Converter.convertAndFill((Attribute)attrValue, (TypedValue)outValue, (ResourceLoader)this.resourceLoader, (String)this.getQualifiers(), (boolean)resolveRefs);
                return true;
            }
        }
        return false;
    }

    @HiddenApi
    @Implementation
    public void ensureStringBlocks() {
    }

    @Implementation
    public final InputStream open(String fileName) throws IOException {
        return this.appManifest.getAssetsDirectory().join(new String[]{fileName}).getInputStream();
    }

    @Implementation
    public final InputStream open(String fileName, int accessMode) throws IOException {
        return this.appManifest.getAssetsDirectory().join(new String[]{fileName}).getInputStream();
    }

    @Implementation
    public final String[] list(String path) throws IOException {
        FsFile file = this.appManifest.getAssetsDirectory().join(new String[]{path});
        if (file.isDirectory()) {
            return file.listFileNames();
        }
        return new String[0];
    }

    @HiddenApi
    @Implementation
    public final InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        ResName resName = this.qualifyFromNonAssetFileName(fileName);
        DrawableNode drawableNode = this.resourceLoader.getDrawableNode(resName, this.getQualifiers());
        if (drawableNode == null) {
            throw new IOException("Unable to find resource for " + fileName);
        }
        if (accessMode == 2) {
            return drawableNode.getFsFile().getInputStream();
        }
        return new ByteArrayInputStream(drawableNode.getFsFile().getBytes());
    }

    private ResName qualifyFromNonAssetFileName(String fileName) {
        if (fileName.startsWith("jar:")) {
            return ResName.qualifyFromFilePath((String)"android", (String)fileName.replaceFirst("jar:", ""));
        }
        return ResName.qualifyFromFilePath((String)this.appManifest.getPackageName(), (String)fileName);
    }

    @HiddenApi
    @Implementation
    public final AssetFileDescriptor openNonAssetFd(int cookie, String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Implementation
    public final XmlResourceParser openXmlResourceParser(int cookie, String fileName) throws IOException {
        return ResourceParser.create((String)fileName, (String)"fixme", (String)"fixme", null);
    }

    @HiddenApi
    @Implementation
    public int addAssetPath(String path) {
        return 1;
    }

    @HiddenApi
    @Implementation
    public boolean isUpToDate() {
        return true;
    }

    @HiddenApi
    @Implementation
    public void setLocale(String locale) {
    }

    @Implementation
    public String[] getLocales() {
        return new String[0];
    }

    @HiddenApi
    @Implementation
    public void setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int majorVersion) {
    }

    @HiddenApi
    @Implementation
    public int[] getArrayIntResource(int arrayRes) {
        ResName resName = this.resourceLoader.getResourceIndex().getResName(arrayRes);
        if (resName == null) {
            throw new Resources.NotFoundException("unknown resource " + arrayRes);
        }
        TypedResource value = this.getAndResolve(resName, this.getQualifiers(), true);
        if (value == null) {
            return null;
        }
        TypedResource[] items = this.getConverter(value).getItems(value);
        int[] ints = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            TypedResource typedResource = this.resolve(items[i], this.getQualifiers(), resName);
            ints[i] = this.getConverter(typedResource).asInt(typedResource);
        }
        return ints;
    }

    @HiddenApi
    @Implementation
    public synchronized int createTheme() {
        return this.nextInternalThemeId++;
    }

    @HiddenApi
    @Implementation
    public synchronized void releaseTheme(long theme) {
        this.themesById.remove(theme);
    }

    @HiddenApi
    @Implementation
    public static void applyThemeStyle(long theme, int styleRes, boolean force) {
        ResourceLoader resourceLoader = ShadowApplication.getInstance().getResourceLoader();
        ShadowAssetManager assetManager = Shadows.shadowOf(ShadowApplication.getInstance().getAssets());
        Map<Long, List<OverlayedStyle>> appliedStyles = assetManager.appliedStyles;
        if (!appliedStyles.containsKey(theme)) {
            appliedStyles.put(theme, new LinkedList());
        }
        ResourceIndex resourceIndex = resourceLoader.getResourceIndex();
        ResName resName = resourceIndex.getResName(styleRes);
        Style style = ShadowAssetManager.resolveStyle(resourceLoader, null, resName, assetManager.getQualifiers());
        List<OverlayedStyle> overlayedStyleList = appliedStyles.get(theme);
        OverlayedStyle styleToAdd = new OverlayedStyle(style, force);
        for (int i = 0; i < overlayedStyleList.size(); ++i) {
            if (!styleToAdd.equals(overlayedStyleList.get(i))) continue;
            overlayedStyleList.remove(i);
            break;
        }
        overlayedStyleList.add(styleToAdd);
    }

    List<OverlayedStyle> getOverlayThemeStyles(long themeResourceId) {
        return this.appliedStyles.get(themeResourceId);
    }

    @HiddenApi
    @Implementation
    public static void copyTheme(long dest, long source) {
        throw new UnsupportedOperationException();
    }

    public synchronized void setTheme(long internalThemeId, Resources.Theme theme) {
        this.themesById.put(internalThemeId, theme);
    }

    private synchronized Resources.Theme getThemeByInternalId(long internalThemeId) {
        return this.themesById.get(internalThemeId);
    }

    static Style resolveStyle(ResourceLoader resourceLoader, Style appTheme, @NotNull ResName themeStyleName, String qualifiers) {
        TypedResource themeStyleResource = resourceLoader.getValue(themeStyleName, qualifiers);
        if (themeStyleResource == null) {
            return null;
        }
        StyleData themeStyleData = (StyleData)themeStyleResource.getData();
        return new StyleResolver(resourceLoader, themeStyleData, appTheme, themeStyleName, qualifiers);
    }

    TypedResource getAndResolve(int resId, String qualifiers, boolean resolveRefs) {
        ResName resName = this.resourceLoader.getResourceIndex().getResName(resId);
        if (resName == null) {
            throw new Resources.NotFoundException("unknown resource " + resId);
        }
        return this.getAndResolve(resName, qualifiers, resolveRefs);
    }

    TypedResource getAndResolve(@NotNull ResName resName, String qualifiers, boolean resolveRefs) {
        TypedResource value = this.resourceLoader.getValue(resName, qualifiers);
        if (resolveRefs) {
            value = this.resolve(value, qualifiers, resName);
        }
        if (value == null && DrawableResourceLoader.isStillHandledHere((ResName)resName)) {
            DrawableNode drawableNode = this.resourceLoader.getDrawableNode(resName, qualifiers);
            return new TypedResource((Object)drawableNode.getFsFile(), ResType.FILE);
        }
        if (value == null && "layout".equals(resName.type)) {
            throw new UnsupportedOperationException("ugh, this doesn't work still?");
        }
        return value;
    }

    TypedResource resolve(TypedResource value, String qualifiers, ResName contextResName) {
        return this.resolveResource((TypedResource)value, (String)qualifiers, (ResName)contextResName).value;
    }

    ResName resolveResName(int resId, String qualifiers) {
        ResName resName = this.resourceLoader.getResourceIndex().getResName(resId);
        if (resName == null) {
            return null;
        }
        TypedResource value = this.resourceLoader.getValue(resName, qualifiers);
        return this.resolveResource((TypedResource)value, (String)qualifiers, (ResName)resName).resName;
    }

    private Resource resolveResource(TypedResource value, String qualifiers, ResName resName) {
        while (this.isReference(value)) {
            String s = value.asString();
            if (s.equals("@null")) {
                value = null;
                continue;
            }
            String refStr = s.substring(1).replace("+", "");
            resName = ResName.qualifyResName((String)refStr, (ResName)resName);
            value = this.resourceLoader.getValue(resName, qualifiers);
        }
        return new Resource(value, resName);
    }

    private boolean isReference(TypedResource value) {
        Object data;
        if (value != null && (data = value.getData()) instanceof String) {
            String s = (String)data;
            return !s.isEmpty() && s.charAt(0) == '@';
        }
        return false;
    }

    public FsFile getAssetsDirectory() {
        return this.appManifest.getAssetsDirectory();
    }

    public String getQualifiers() {
        return RuntimeEnvironment.getQualifiers();
    }

    public void setQualifiers(String qualifiers) {
        RuntimeEnvironment.setQualifiers((String)qualifiers);
    }

    static class StyleResolver
    implements Style {
        private final ResourceLoader resourceLoader;
        private final List<StyleData> styles = new ArrayList<StyleData>();
        private final Style theme;
        private final ResName myResName;
        private final String qualifiers;

        public StyleResolver(ResourceLoader resourceLoader, StyleData styleData, Style theme, ResName myResName, String qualifiers) {
            this.resourceLoader = resourceLoader;
            this.theme = theme;
            this.myResName = myResName;
            this.qualifiers = qualifiers;
            this.styles.add(styleData);
        }

        public Attribute getAttrValue(ResName resName) {
            Attribute value;
            StyleData parent;
            resName.mustBe("attr");
            for (StyleData style : this.styles) {
                Attribute value2 = style.getAttrValue(resName);
                if (value2 == null) continue;
                return value2;
            }
            int initialSize = this.styles.size();
            while (StyleResolver.hasParent(this.styles.get(this.styles.size() - 1)) && (parent = this.getParent(this.styles.get(this.styles.size() - 1))) != null) {
                this.styles.add(parent);
            }
            for (int i = initialSize; i < this.styles.size(); ++i) {
                StyleData style = this.styles.get(i);
                Attribute value3 = style.getAttrValue(resName);
                if (value3 == null) continue;
                return value3;
            }
            if (this.theme != null && (value = this.theme.getAttrValue(resName)) != null) {
                return value;
            }
            return null;
        }

        private static String getParentStyleName(StyleData style) {
            if (style == null) {
                return null;
            }
            String parent = style.getParent();
            if (parent == null || parent.isEmpty()) {
                parent = null;
                String name = style.getName();
                if (name.contains(".") && (parent = name.substring(0, name.lastIndexOf(46))).isEmpty()) {
                    return null;
                }
            }
            return parent;
        }

        private static boolean hasParent(StyleData style) {
            if (style == null) {
                return false;
            }
            String parent = style.getParent();
            return parent != null && !parent.isEmpty();
        }

        private StyleData getParent(StyleData style) {
            String parent = StyleResolver.getParentStyleName(style);
            if (parent == null) {
                return null;
            }
            if (parent.startsWith("@")) {
                parent = parent.substring(1);
            }
            ResName styleRef = ResName.qualifyResName((String)parent, (String)style.getPackageName(), (String)"style");
            TypedResource typedResource = this.resourceLoader.getValue(styleRef = this.dereferenceResName(styleRef), this.qualifiers);
            if (typedResource == null) {
                StringBuilder builder = new StringBuilder("Could not find any resource ").append(" from reference ").append(styleRef).append(" from style ").append(style).append(" with theme ").append(this.theme);
                throw new RuntimeException(builder.toString());
            }
            Object data = typedResource.getData();
            if (data instanceof StyleData) {
                return (StyleData)data;
            }
            StringBuilder builder = new StringBuilder(styleRef.toString()).append(" does not resolve to a Style.").append(" got ").append(data).append(" instead. ").append(" from style ").append(style).append(" with theme ").append(this.theme);
            throw new RuntimeException(builder.toString());
        }

        private ResName dereferenceResName(ResName res) {
            ResName styleRef = res;
            boolean dereferencing = true;
            while ("attr".equals(styleRef.type) && dereferencing) {
                Attribute value;
                dereferencing = false;
                for (StyleData parentStyle : this.styles) {
                    Attribute value2 = parentStyle.getAttrValue(styleRef);
                    if (value2 == null) continue;
                    styleRef = this.dereferenceAttr(value2);
                    dereferencing = true;
                    break;
                }
                if (dereferencing || this.theme == null || (value = this.theme.getAttrValue(styleRef)) == null) continue;
                styleRef = this.dereferenceAttr(value);
                dereferencing = true;
            }
            return styleRef;
        }

        private ResName dereferenceAttr(Attribute attr) {
            if (attr.isResourceReference()) {
                return attr.getResourceReference();
            }
            if (attr.isStyleReference()) {
                return attr.getStyleReference();
            }
            throw new RuntimeException("Found a " + attr + " but can't cast it :(");
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StyleResolver)) {
                return false;
            }
            StyleResolver other = (StyleResolver)obj;
            return (this.theme == null && other.theme == null || this.theme != null && this.theme.equals(other.theme)) && (this.myResName == null && other.myResName == null || this.myResName != null && this.myResName.equals((Object)other.myResName)) && Strings.equals((String)this.qualifiers, (String)other.qualifiers);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.theme != null ? this.theme.hashCode() : 0);
            hashCode = 31 * hashCode + (this.myResName != null ? this.myResName.hashCode() : 0);
            hashCode = 31 * hashCode + Strings.nullToEmpty((String)this.qualifiers).hashCode();
            return hashCode;
        }

        public String toString() {
            return "StyleResolver{name=" + this.myResName + ", of=" + this.styles.get(0) + "}";
        }
    }

    private static class Resource {
        public final ResName resName;
        public final TypedResource<?> value;

        public Resource(TypedResource<?> value, ResName resName) {
            this.value = value;
            this.resName = resName;
        }
    }

    static class OverlayedStyle {
        Style style;
        boolean force;

        public OverlayedStyle(Style style, boolean force) {
            this.style = style;
            this.force = force;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OverlayedStyle)) {
                return false;
            }
            OverlayedStyle overlayedStyle = (OverlayedStyle)obj;
            return this.style.equals(overlayedStyle.style);
        }

        public int hashCode() {
            return this.style.hashCode();
        }
    }
}

