/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.IBinder;
import android.os.ResultReceiver;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.internal.Shadow;

@Implements(value=InputMethodManager.class, callThroughByDefault=false)
public class ShadowInputMethodManager {
    private boolean softInputVisible;

    @HiddenApi
    @Implementation
    public static InputMethodManager peekInstance() {
        return (InputMethodManager)Shadow.newInstanceOf(InputMethodManager.class);
    }

    @Implementation
    public boolean showSoftInput(View view, int flags) {
        return this.showSoftInput(view, flags, null);
    }

    @Implementation
    public boolean showSoftInput(View view, int flags, ResultReceiver resultReceiver) {
        this.softInputVisible = true;
        return true;
    }

    @Implementation
    public boolean hideSoftInputFromWindow(IBinder windowToken, int flags) {
        return this.hideSoftInputFromWindow(windowToken, flags, null);
    }

    @Implementation
    public boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver) {
        this.softInputVisible = false;
        return true;
    }

    @Implementation
    public void toggleSoftInput(int showFlags, int hideFlags) {
        this.softInputVisible = !this.softInputVisible;
    }

    public boolean isSoftInputVisible() {
        return this.softInputVisible;
    }
}

