/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Matrix;
import android.graphics.RectF;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=Matrix.class)
public class ShadowMatrix {
    public static final String TRANSLATE = "translate";
    public static final String SCALE = "scale";
    public static final String ROTATE = "rotate";
    public static final String SINCOS = "sincos";
    public static final String SKEW = "skew";
    public static final String MATRIX = "matrix";
    private final Deque<String> preOps = new ArrayDeque<String>();
    private final Deque<String> postOps = new ArrayDeque<String>();
    private final Map<String, String> setOps = new LinkedHashMap<String, String>();

    public void __constructor__(Matrix src) {
        this.set(src);
    }

    public List<String> getPreOperations() {
        return Collections.unmodifiableList(new ArrayList<String>(this.preOps));
    }

    public List<String> getPostOperations() {
        return Collections.unmodifiableList(new ArrayList<String>(this.postOps));
    }

    public Map<String, String> getSetOperations() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.setOps));
    }

    @Implementation
    public boolean isIdentity() {
        return this.preOps.isEmpty() && this.postOps.isEmpty() && this.setOps.isEmpty();
    }

    @Implementation
    public void set(Matrix src) {
        this.reset();
        if (src != null) {
            ShadowMatrix shadowMatrix = Shadows.shadowOf(src);
            this.preOps.addAll(shadowMatrix.preOps);
            this.postOps.addAll(shadowMatrix.postOps);
            this.setOps.putAll(shadowMatrix.setOps);
        }
    }

    @Implementation
    public void reset() {
        this.preOps.clear();
        this.postOps.clear();
        this.setOps.clear();
    }

    @Implementation
    public void setTranslate(float dx, float dy) {
        this.setOps.put(TRANSLATE, dx + " " + dy);
    }

    @Implementation
    public void setScale(float sx, float sy, float px, float py) {
        this.setOps.put(SCALE, sx + " " + sy + " " + px + " " + py);
    }

    @Implementation
    public void setScale(float sx, float sy) {
        this.setOps.put(SCALE, sx + " " + sy);
    }

    @Implementation
    public void setRotate(float degrees, float px, float py) {
        this.setOps.put(ROTATE, degrees + " " + px + " " + py);
    }

    @Implementation
    public void setRotate(float degrees) {
        this.setOps.put(ROTATE, Float.toString(degrees));
    }

    @Implementation
    public void setSinCos(float sinValue, float cosValue, float px, float py) {
        this.setOps.put(SINCOS, sinValue + " " + cosValue + " " + px + " " + py);
    }

    @Implementation
    public void setSinCos(float sinValue, float cosValue) {
        this.setOps.put(SINCOS, sinValue + " " + cosValue);
    }

    @Implementation
    public void setSkew(float kx, float ky, float px, float py) {
        this.setOps.put(SKEW, kx + " " + ky + " " + px + " " + py);
    }

    @Implementation
    public void setSkew(float kx, float ky) {
        this.setOps.put(SKEW, kx + " " + ky);
    }

    @Implementation
    public void preTranslate(float dx, float dy) {
        this.preOps.addFirst("translate " + dx + " " + dy);
    }

    @Implementation
    public void preScale(float sx, float sy, float px, float py) {
        this.preOps.addFirst("scale " + sx + " " + sy + " " + px + " " + py);
    }

    @Implementation
    public void preScale(float sx, float sy) {
        this.preOps.addFirst("scale " + sx + " " + sy);
    }

    @Implementation
    public void preRotate(float degrees, float px, float py) {
        this.preOps.addFirst("rotate " + degrees + " " + px + " " + py);
    }

    @Implementation
    public void preRotate(float degrees) {
        this.preOps.addFirst("rotate " + Float.toString(degrees));
    }

    @Implementation
    public void preSkew(float kx, float ky, float px, float py) {
        this.preOps.addFirst("skew " + kx + " " + ky + " " + px + " " + py);
    }

    @Implementation
    public void preSkew(float kx, float ky) {
        this.preOps.addFirst("skew " + kx + " " + ky);
    }

    @Implementation
    public void preConcat(Matrix other) {
        this.preOps.addFirst("matrix " + other);
    }

    @Implementation
    public void postTranslate(float dx, float dy) {
        this.postOps.addLast("translate " + dx + " " + dy);
    }

    @Implementation
    public void postScale(float sx, float sy, float px, float py) {
        this.postOps.addLast("scale " + sx + " " + sy + " " + px + " " + py);
    }

    @Implementation
    public void postScale(float sx, float sy) {
        this.postOps.addLast("scale " + sx + " " + sy);
    }

    @Implementation
    public void postRotate(float degrees, float px, float py) {
        this.postOps.addLast("rotate " + degrees + " " + px + " " + py);
    }

    @Implementation
    public void postRotate(float degrees) {
        this.postOps.addLast("rotate " + Float.toString(degrees));
    }

    @Implementation
    public void postSkew(float kx, float ky, float px, float py) {
        this.postOps.addLast("skew " + kx + " " + ky + " " + px + " " + py);
    }

    @Implementation
    public void postSkew(float kx, float ky) {
        this.postOps.addLast("skew " + kx + " " + ky);
    }

    @Implementation
    public void postConcat(Matrix other) {
        this.postOps.addLast("matrix " + other);
    }

    @Implementation
    public String toString() {
        return "Matrix[pre=" + this.preOps + ", set=" + this.setOps + ", post=" + this.postOps + "]";
    }

    @Implementation
    public boolean mapRect(RectF destination, RectF source) {
        destination.set(source);
        return true;
    }
}

