/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.ParcelFileDescriptor;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.LongSparseArray;
import android.util.TypedValue;
import android.view.Display;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.internal.Shadow;
import org.robolectric.res.Attribute;
import org.robolectric.res.Plural;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourceLoader;
import org.robolectric.res.StringResources;
import org.robolectric.res.Style;
import org.robolectric.res.TypedResource;
import org.robolectric.res.builder.ResourceParser;
import org.robolectric.res.builder.XmlBlock;
import org.robolectric.shadows.Converter;
import org.robolectric.shadows.RoboAttributeSet;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.shadows.ShadowTypedArray;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Resources.class)
public class ShadowResources {
    private static Resources system = null;
    private float density = 1.0f;
    private DisplayMetrics displayMetrics;
    private Display display;
    @RealObject
    Resources realResources;
    private ResourceLoader resourceLoader;

    @Resetter
    public static void reset() {
        for (Field field : Resources.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(LongSparseArray.class)) continue;
            try {
                field.setAccessible(true);
                LongSparseArray longSparseArray = (LongSparseArray)field.get(null);
                if (longSparseArray == null) continue;
                longSparseArray.clear();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setSystemResources(ResourceLoader systemResourceLoader) {
        AssetManager assetManager = new AssetManager();
        ShadowAssetManager.bind(assetManager, null, systemResourceLoader);
        DisplayMetrics metrics = new DisplayMetrics();
        Configuration config = new Configuration();
        system = ShadowResources.bind(new Resources(assetManager, metrics, config), systemResourceLoader);
    }

    static Resources bind(Resources resources, ResourceLoader resourceLoader) {
        ShadowResources shadowResources = Shadows.shadowOf(resources);
        if (shadowResources.resourceLoader != null) {
            throw new RuntimeException("ResourceLoader already set!");
        }
        shadowResources.resourceLoader = resourceLoader;
        return resources;
    }

    @Implementation
    public static Resources getSystem() {
        return system;
    }

    public static Resources createFor(ResourceLoader resourceLoader) {
        AssetManager assetManager = ShadowAssetManager.bind((AssetManager)ReflectionHelpers.callConstructor(AssetManager.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]), null, resourceLoader);
        return ShadowResources.bind(new Resources(assetManager, new DisplayMetrics(), new Configuration()), resourceLoader);
    }

    /*
     * WARNING - void declaration
     */
    private TypedArray attrsToTypedArray(AttributeSet set, int[] attrs, int defStyleAttr, int themeResourceId, int defStyleRes) {
        int styleAttrResId;
        ResourceLoader resourceLoader = this.getResourceLoader();
        ShadowAssetManager shadowAssetManager = Shadows.shadowOf(this.realResources.getAssets());
        if (set == null) {
            set = new RoboAttributeSet(new ArrayList(), ShadowApplication.getInstance().getResourceLoader());
        }
        Style defStyleFromAttr = null;
        Style defStyleFromRes = null;
        Style styleAttrStyle = null;
        Style theme = null;
        List<ShadowAssetManager.OverlayedStyle> overlayedStyles = shadowAssetManager.getOverlayThemeStyles(themeResourceId);
        if (themeResourceId != 0) {
            ResName defStyleName;
            Attribute attribute;
            ResName themeStyleName = this.getResName(themeResourceId);
            theme = ShadowAssetManager.resolveStyle(resourceLoader, null, themeStyleName, shadowAssetManager.getQualifiers());
            if (defStyleAttr != 0 && (attribute = ShadowResources.getOverlayedThemeValue(defStyleName = this.getResName(defStyleAttr), theme, overlayedStyles)) != null) {
                void var15_17;
                while (var15_17.isStyleReference()) {
                    Attribute other = ShadowResources.getOverlayedThemeValue(var15_17.getStyleReference(), theme, overlayedStyles);
                    if (other == null) {
                        throw new RuntimeException("couldn't dereference " + var15_17);
                    }
                    Attribute attribute2 = other;
                }
                if (var15_17.isResourceReference()) {
                    ResName defStyleResName = var15_17.getResourceReference();
                    defStyleFromAttr = ShadowAssetManager.resolveStyle(resourceLoader, theme, defStyleResName, shadowAssetManager.getQualifiers());
                }
            }
        }
        if ((styleAttrResId = set.getStyleAttribute()) != 0) {
            ResName styleAttributeResName = this.getResName(styleAttrResId);
            while (styleAttributeResName.type.equals("attr")) {
                Attribute attribute = ShadowResources.getOverlayedThemeValue(styleAttributeResName, theme, overlayedStyles);
                if (attribute.isResourceReference()) {
                    styleAttributeResName = attribute.getResourceReference();
                    continue;
                }
                if (!attribute.isStyleReference()) continue;
                styleAttributeResName = attribute.getStyleReference();
            }
            styleAttrStyle = ShadowAssetManager.resolveStyle(resourceLoader, theme, styleAttributeResName, shadowAssetManager.getQualifiers());
        }
        if (defStyleRes != 0) {
            Attribute attribute;
            ResName resName = this.getResName(defStyleRes);
            if (resName.type.equals("attr") && (attribute = this.findAttributeValue(this.getResName(defStyleRes), set, styleAttrStyle, defStyleFromAttr, defStyleFromAttr, theme, overlayedStyles)) != null) {
                if (attribute.isStyleReference()) {
                    resName = ShadowResources.getOverlayedThemeValue(attribute.getStyleReference(), theme, overlayedStyles).getResourceReference();
                } else if (attribute.isResourceReference()) {
                    resName = attribute.getResourceReference();
                }
            }
            defStyleFromRes = ShadowAssetManager.resolveStyle(resourceLoader, theme, resName, shadowAssetManager.getQualifiers());
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (attrs == null) {
            attrs = new int[]{};
        }
        for (int attr : attrs) {
            ResName attrName = this.tryResName(attr);
            if (attrName == null) continue;
            Attribute attribute = this.findAttributeValue(attrName, set, styleAttrStyle, defStyleFromAttr, defStyleFromRes, theme, overlayedStyles);
            while (attribute != null && attribute.isStyleReference()) {
                ResName otherAttrName = attribute.getStyleReference();
                if (theme == null) break;
                attribute = ShadowResources.getOverlayedThemeValue(otherAttrName, theme, overlayedStyles);
                if (attribute == null) continue;
                attribute = new Attribute(attrName, attribute.value, attribute.contextPackageName);
            }
            if (attribute == null) continue;
            Attribute.put(attributes, (Attribute)attribute);
        }
        TypedArray typedArray = this.createTypedArray(attributes, attrs);
        Shadows.shadowOf((TypedArray)typedArray).positionDescription = set.getPositionDescription();
        return typedArray;
    }

    public TypedArray createTypedArray(List<Attribute> set, int[] attrs) {
        ResourceLoader resourceLoader = this.getResourceLoader();
        ResourceIndex resourceIndex = resourceLoader.getResourceIndex();
        String qualifiers = Shadows.shadowOf(this.realResources.getAssets()).getQualifiers();
        CharSequence[] stringData = new CharSequence[attrs.length];
        int[] data = new int[attrs.length * 6];
        int[] indices = new int[attrs.length + 1];
        int nextIndex = 0;
        for (int i = 0; i < attrs.length; ++i) {
            int offset = i * 6;
            int attr = attrs[i];
            ResName attrName = resourceIndex.getResName(attr);
            if (attrName == null) continue;
            Attribute attribute = Attribute.find(set, (ResName)attrName);
            TypedValue typedValue = new TypedValue();
            Converter.convertAndFill((Attribute)attribute, (TypedValue)typedValue, (ResourceLoader)resourceLoader, (String)qualifiers, (boolean)true);
            if (attribute == null || attribute.isNull()) continue;
            data[offset + 0] = typedValue.type;
            data[offset + 1] = typedValue.type == 3 ? i : typedValue.data;
            data[offset + 2] = typedValue.assetCookie;
            data[offset + 3] = typedValue.resourceId;
            data[offset + 4] = typedValue.changingConfigurations;
            data[offset + 5] = typedValue.density;
            stringData[i] = typedValue.string;
            indices[nextIndex + 1] = i;
            ++nextIndex;
        }
        indices[0] = nextIndex;
        return ShadowTypedArray.create(this.realResources, attrs, data, indices, nextIndex, stringData);
    }

    private Attribute findAttributeValue(ResName attrName, AttributeSet attributeSet, Style styleAttrStyle, Style defStyleFromAttr, Style defStyleFromRes, Style theme, List<ShadowAssetManager.OverlayedStyle> overlayedStyles) {
        Attribute attribute;
        String attrValue = attributeSet.getAttributeValue(attrName.getNamespaceUri(), attrName.name);
        if (attrValue != null) {
            return new Attribute(attrName, attrValue, "fixme!!!");
        }
        if (styleAttrStyle != null && (attribute = styleAttrStyle.getAttrValue(attrName)) != null) {
            return attribute;
        }
        if (defStyleFromAttr != null && (attribute = defStyleFromAttr.getAttrValue(attrName)) != null) {
            return attribute;
        }
        if (defStyleFromRes != null && (attribute = defStyleFromRes.getAttrValue(attrName)) != null) {
            return attribute;
        }
        if (theme != null) {
            return ShadowResources.getOverlayedThemeValue(attrName, theme, overlayedStyles);
        }
        return null;
    }

    static Attribute getOverlayedThemeValue(ResName attrName, Style theme, List<ShadowAssetManager.OverlayedStyle> overlayedStyles) {
        Attribute attribute = theme.getAttrValue(attrName);
        if (overlayedStyles != null) {
            for (ShadowAssetManager.OverlayedStyle overlayedStyle : overlayedStyles) {
                Attribute overlayedAttribute = overlayedStyle.style.getAttrValue(attrName);
                if (overlayedAttribute == null || attribute != null && !overlayedStyle.force) continue;
                attribute = overlayedAttribute;
            }
        }
        return attribute;
    }

    @Implementation
    public TypedArray obtainAttributes(AttributeSet set, int[] attrs) {
        return this.attrsToTypedArray(set, attrs, 0, 0, 0);
    }

    @Implementation
    public String getResourceName(int resId) throws Resources.NotFoundException {
        return this.getResName(resId).getFullyQualifiedName();
    }

    @Implementation
    public String getResourcePackageName(int resId) throws Resources.NotFoundException {
        return this.getResName((int)resId).packageName;
    }

    @Implementation
    public String getResourceTypeName(int resId) throws Resources.NotFoundException {
        return this.getResName((int)resId).type;
    }

    @Implementation
    public String getResourceEntryName(int resId) throws Resources.NotFoundException {
        return this.getResName((int)resId).name;
    }

    @NotNull
    private ResName getResName(int id2) {
        ResName resName = this.getResourceLoader().getResourceIndex().getResName(id2);
        return this.checkResName(id2, resName);
    }

    @NotNull
    private ResName resolveResName(int id2) {
        ResName resName = Shadows.shadowOf(this.realResources.getAssets()).resolveResName(id2, this.getQualifiers());
        return this.checkResName(id2, resName);
    }

    private ResName checkResName(int id2, ResName resName) {
        if (resName == null) {
            throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(id2));
        }
        return resName;
    }

    private ResName tryResName(int id2) {
        return this.getResourceLoader().getResourceIndex().getResName(id2);
    }

    private String getQualifiers() {
        return Shadows.shadowOf(this.realResources.getAssets()).getQualifiers();
    }

    @Implementation
    public CharSequence getText(int id2) throws Resources.NotFoundException {
        CharSequence text = ((Resources)Shadow.directlyOn((Object)this.realResources, Resources.class)).getText(id2);
        return StringResources.escape((String)text.toString());
    }

    @Implementation
    public String getQuantityString(int id2, int quantity, Object ... formatArgs) throws Resources.NotFoundException {
        String raw = this.getQuantityString(id2, quantity);
        return String.format(Locale.ENGLISH, raw, formatArgs);
    }

    @Implementation
    public String getQuantityString(int id2, int quantity) throws Resources.NotFoundException {
        ResName resName = this.getResName(id2);
        Plural plural = this.getResourceLoader().getPlural(resName, quantity, this.getQualifiers());
        String string = plural.getString();
        ShadowAssetManager shadowAssetManager = Shadows.shadowOf(this.realResources.getAssets());
        TypedResource typedResource = shadowAssetManager.resolve(new TypedResource((Object)string, ResType.CHAR_SEQUENCE), this.getQualifiers(), new ResName(resName.packageName, "string", resName.name));
        return typedResource == null ? null : typedResource.asString();
    }

    @Implementation
    public InputStream openRawResource(int id2) throws Resources.NotFoundException {
        return this.getResourceLoader().getRawValue(this.getResName(id2));
    }

    @Implementation
    public AssetFileDescriptor openRawResourceFd(int id2) throws Resources.NotFoundException {
        try {
            FileInputStream fis = (FileInputStream)this.openRawResource(id2);
            return new AssetFileDescriptor(ParcelFileDescriptor.dup((FileDescriptor)fis.getFD()), 0L, fis.getChannel().size());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setDensity(float density) {
        this.density = density;
        if (this.displayMetrics != null) {
            this.displayMetrics.density = density;
        }
    }

    public void setScaledDensity(float scaledDensity) {
        if (this.displayMetrics != null) {
            this.displayMetrics.scaledDensity = scaledDensity;
        }
    }

    public void setDisplay(Display display) {
        this.display = display;
        this.displayMetrics = null;
    }

    @Implementation
    public DisplayMetrics getDisplayMetrics() {
        if (this.displayMetrics == null) {
            if (this.display == null) {
                this.display = (Display)ReflectionHelpers.callConstructor(Display.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            }
            this.displayMetrics = new DisplayMetrics();
            this.display.getMetrics(this.displayMetrics);
        }
        this.displayMetrics.density = this.density;
        return this.displayMetrics;
    }

    @HiddenApi
    @Implementation
    public XmlResourceParser loadXmlResourceParser(int id2, String type) throws Resources.NotFoundException {
        ResName resName = this.resolveResName(id2);
        XmlBlock block = this.getResourceLoader().getXml(resName, this.getQualifiers());
        if (block == null) {
            throw new Resources.NotFoundException();
        }
        return ResourceParser.from((XmlBlock)block, (String)resName.packageName, (ResourceIndex)this.getResourceLoader().getResourceIndex());
    }

    @HiddenApi
    @Implementation
    public XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        return this.loadXmlResourceParser(id2, type);
    }

    public ResourceLoader getResourceLoader() {
        if (this.resourceLoader == null) {
            this.resourceLoader = Shadows.shadowOf(RuntimeEnvironment.application).getResourceLoader();
        }
        return this.resourceLoader;
    }

    @Implementation
    public final Resources.Theme newTheme() {
        Resources.Theme theme = ((Resources)Shadow.directlyOn((Object)this.realResources, Resources.class)).newTheme();
        int themeId = Integer.valueOf(ReflectionHelpers.getField((Object)theme, (String)"mTheme").toString());
        Shadows.shadowOf(this.realResources.getAssets()).setTheme(themeId, theme);
        return theme;
    }

    @HiddenApi
    @Implementation
    public Drawable loadDrawable(TypedValue value, int id2) {
        ResName resName = this.tryResName(id2);
        Drawable drawable = (Drawable)Shadow.directlyOn((Object)this.realResources, Resources.class, (String)"loadDrawable", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(TypedValue.class, (Object)value), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)id2)});
        if (drawable != null) {
            Bitmap bitmap;
            Shadows.shadowOf((Drawable)drawable).createdFromResId = id2;
            if (drawable instanceof BitmapDrawable && (bitmap = ((BitmapDrawable)drawable).getBitmap()) != null) {
                ShadowBitmap shadowBitmap = Shadows.shadowOf(bitmap);
                if (shadowBitmap.createdFromResId == -1) {
                    shadowBitmap.setCreatedFromResId(id2, resName);
                }
            }
        }
        return drawable;
    }

    @Implementation
    public Drawable loadDrawable(TypedValue value, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        ResName resName = this.tryResName(id2);
        Drawable drawable = (Drawable)Shadow.directlyOn((Object)this.realResources, Resources.class, (String)"loadDrawable", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(TypedValue.class, (Object)value), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)id2), ReflectionHelpers.ClassParameter.from(Resources.Theme.class, (Object)theme)});
        if (drawable != null) {
            Bitmap bitmap;
            Shadows.shadowOf((Drawable)drawable).createdFromResId = id2;
            if (drawable instanceof BitmapDrawable && (bitmap = ((BitmapDrawable)drawable).getBitmap()) != null) {
                ShadowBitmap shadowBitmap = Shadows.shadowOf(bitmap);
                if (shadowBitmap.createdFromResId == -1) {
                    shadowBitmap.setCreatedFromResId(id2, resName);
                }
            }
        }
        return drawable;
    }

    @Implements(value=Resources.NotFoundException.class)
    public static class ShadowNotFoundException {
        @RealObject
        Resources.NotFoundException realObject;
        private String message;

        public void __constructor__() {
        }

        public void __constructor__(String name) {
            this.message = name;
        }

        @Implementation
        public String toString() {
            return this.realObject.getClass().getName() + ": " + this.message;
        }
    }

    @Implements(value=Resources.Theme.class)
    public static class ShadowTheme {
        @RealObject
        Resources.Theme realTheme;
        protected Resources resources;
        private int styleResourceId;

        @Implementation
        public void applyStyle(int resid, boolean force) {
            if (this.styleResourceId == 0) {
                this.styleResourceId = resid;
            }
            ShadowAssetManager.applyThemeStyle(this.styleResourceId, resid, force);
        }

        @Implementation
        public void setTo(Resources.Theme other) {
            this.styleResourceId = Shadows.shadowOf((Resources.Theme)other).styleResourceId;
        }

        public int getStyleResourceId() {
            return this.styleResourceId;
        }

        @Implementation
        public TypedArray obtainStyledAttributes(int[] attrs) {
            return this.obtainStyledAttributes(0, attrs);
        }

        @Implementation
        public TypedArray obtainStyledAttributes(int resid, int[] attrs) throws Resources.NotFoundException {
            return this.obtainStyledAttributes(null, attrs, 0, resid);
        }

        @Implementation
        public TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            return Shadows.shadowOf(this.getResources()).attrsToTypedArray(set, attrs, defStyleAttr, this.styleResourceId, defStyleRes);
        }

        @Implementation
        public Resources getResources() {
            return (Resources)ReflectionHelpers.getField((Object)this.realTheme, (String)"this$0");
        }
    }
}

