/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Canvas.class)
public class ShadowCanvas {
    private List<PathPaintHistoryEvent> pathPaintEvents = new ArrayList<PathPaintHistoryEvent>();
    private List<CirclePaintHistoryEvent> circlePaintEvents = new ArrayList<CirclePaintHistoryEvent>();
    private List<ArcPaintHistoryEvent> arcPaintEvents = new ArrayList<ArcPaintHistoryEvent>();
    private List<RectPaintHistoryEvent> rectPaintEvents = new ArrayList<RectPaintHistoryEvent>();
    private List<LinePaintHistoryEvent> linePaintEvents = new ArrayList<LinePaintHistoryEvent>();
    private List<OvalPaintHistoryEvent> ovalPaintEvents = new ArrayList<OvalPaintHistoryEvent>();
    private List<TextHistoryEvent> drawnTextEventHistory = new ArrayList<TextHistoryEvent>();
    private Paint drawnPaint;
    private Bitmap targetBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    private float translateX;
    private float translateY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private int height;
    private int width;

    public static String visualize(Canvas canvas) {
        return Shadows.shadowOf(canvas).getDescription();
    }

    @Implementation
    public void __constructor__(Bitmap bitmap) {
        this.targetBitmap = bitmap;
    }

    public void appendDescription(String s) {
        Shadows.shadowOf(this.targetBitmap).appendDescription(s);
    }

    public String getDescription() {
        return Shadows.shadowOf(this.targetBitmap).getDescription();
    }

    @Implementation
    public void setBitmap(Bitmap bitmap) {
        this.targetBitmap = bitmap;
    }

    @Implementation
    public void drawText(String text, float x, float y, Paint paint) {
        this.drawnTextEventHistory.add(new TextHistoryEvent(x, y, paint, text));
    }

    @Implementation
    public void translate(float x, float y) {
        this.translateX = x;
        this.translateY = y;
    }

    @Implementation
    public void scale(float sx, float sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    @Implementation
    public void scale(float sx, float sy, float px, float py) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    @Implementation
    public void drawPaint(Paint paint) {
        this.drawnPaint = paint;
    }

    @Implementation
    public void drawColor(int color) {
        this.appendDescription("draw color " + color);
    }

    @Implementation
    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        this.describeBitmap(bitmap, paint);
        int x = (int)(left + this.translateX);
        int y = (int)(top + this.translateY);
        if (x != 0 || y != 0) {
            this.appendDescription(" at (" + x + "," + y + ")");
        }
        if (this.scaleX != 1.0f && this.scaleY != 1.0f) {
            this.appendDescription(" scaled by (" + this.scaleX + "," + this.scaleY + ")");
        }
    }

    @Implementation
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        this.describeBitmap(bitmap, paint);
        StringBuilder descriptionBuilder = new StringBuilder();
        if (dst != null) {
            descriptionBuilder.append(" at (").append(dst.left).append(",").append(dst.top).append(") with height=").append(dst.height()).append(" and width=").append(dst.width());
        }
        if (src != null) {
            descriptionBuilder.append(" taken from ").append(src.toString());
        }
        this.appendDescription(descriptionBuilder.toString());
    }

    @Implementation
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        this.describeBitmap(bitmap, paint);
        StringBuilder descriptionBuilder = new StringBuilder();
        if (dst != null) {
            descriptionBuilder.append(" at (").append(dst.left).append(",").append(dst.top).append(") with height=").append(dst.height()).append(" and width=").append(dst.width());
        }
        if (src != null) {
            descriptionBuilder.append(" taken from ").append(src.toString());
        }
        this.appendDescription(descriptionBuilder.toString());
    }

    @Implementation
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        this.describeBitmap(bitmap, paint);
        this.appendDescription(" transformed by " + Shadows.shadowOf(matrix).getDescription());
    }

    @Implementation
    public void drawPath(Path path, Paint paint) {
        this.pathPaintEvents.add(new PathPaintHistoryEvent(new Path(path), new Paint(paint)));
        this.separateLines();
        this.appendDescription("Path " + Shadows.shadowOf(path).getPoints().toString());
    }

    @Implementation
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        this.circlePaintEvents.add(new CirclePaintHistoryEvent(cx, cy, radius, paint));
    }

    @Implementation
    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        this.arcPaintEvents.add(new ArcPaintHistoryEvent(oval, startAngle, sweepAngle, useCenter, paint));
    }

    @Implementation
    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        this.rectPaintEvents.add(new RectPaintHistoryEvent(left, top, right, bottom, paint));
    }

    @Implementation
    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        this.linePaintEvents.add(new LinePaintHistoryEvent(startX, startY, stopX, stopY, paint));
    }

    @Implementation
    public void drawOval(RectF oval, Paint paint) {
        this.ovalPaintEvents.add(new OvalPaintHistoryEvent(oval, paint));
    }

    @Implementation
    public void restore() {
    }

    private void describeBitmap(Bitmap bitmap, Paint paint) {
        ColorFilter colorFilter;
        this.separateLines();
        this.appendDescription(Shadows.shadowOf(bitmap).getDescription());
        if (paint != null && (colorFilter = paint.getColorFilter()) != null) {
            this.appendDescription(" with " + colorFilter);
        }
    }

    private void separateLines() {
        if (this.getDescription().length() != 0) {
            this.appendDescription("\n");
        }
    }

    public int getPathPaintHistoryCount() {
        return this.pathPaintEvents.size();
    }

    public int getCirclePaintHistoryCount() {
        return this.circlePaintEvents.size();
    }

    public int getArcPaintHistoryCount() {
        return this.arcPaintEvents.size();
    }

    public boolean hasDrawnPath() {
        return this.getPathPaintHistoryCount() > 0;
    }

    public boolean hasDrawnCircle() {
        return this.circlePaintEvents.size() > 0;
    }

    public Paint getDrawnPathPaint(int i) {
        return this.pathPaintEvents.get(i).pathPaint;
    }

    public Path getDrawnPath(int i) {
        return this.pathPaintEvents.get(i).drawnPath;
    }

    public CirclePaintHistoryEvent getDrawnCircle(int i) {
        return this.circlePaintEvents.get(i);
    }

    public ArcPaintHistoryEvent getDrawnArc(int i) {
        return this.arcPaintEvents.get(i);
    }

    public void resetCanvasHistory() {
        this.drawnTextEventHistory.clear();
        this.pathPaintEvents.clear();
        this.circlePaintEvents.clear();
        this.rectPaintEvents.clear();
        this.linePaintEvents.clear();
        this.ovalPaintEvents.clear();
        Shadows.shadowOf(this.targetBitmap).setDescription("");
    }

    public Paint getDrawnPaint() {
        return this.drawnPaint;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Implementation
    public int getWidth() {
        return this.width;
    }

    @Implementation
    public int getHeight() {
        return this.height;
    }

    public TextHistoryEvent getDrawnTextEvent(int i) {
        return this.drawnTextEventHistory.get(i);
    }

    public int getTextHistoryCount() {
        return this.drawnTextEventHistory.size();
    }

    public RectPaintHistoryEvent getDrawnRect(int i) {
        return this.rectPaintEvents.get(i);
    }

    public RectPaintHistoryEvent getLastDrawnRect() {
        return this.rectPaintEvents.get(this.rectPaintEvents.size() - 1);
    }

    public int getRectPaintHistoryCount() {
        return this.rectPaintEvents.size();
    }

    public LinePaintHistoryEvent getDrawnLine(int i) {
        return this.linePaintEvents.get(i);
    }

    public int getLinePaintHistoryCount() {
        return this.linePaintEvents.size();
    }

    public int getOvalPaintHistoryCount() {
        return this.ovalPaintEvents.size();
    }

    public OvalPaintHistoryEvent getDrawnOval(int i) {
        return this.ovalPaintEvents.get(i);
    }

    public static class TextHistoryEvent {
        public final float x;
        public final float y;
        public final Paint paint;
        public final String text;

        private TextHistoryEvent(float x, float y, Paint paint, String text) {
            this.x = x;
            this.y = y;
            this.paint = paint;
            this.text = text;
        }
    }

    public static class ArcPaintHistoryEvent {
        public final RectF oval;
        public final float startAngle;
        public final float sweepAngle;
        public final boolean useCenter;
        public final Paint paint;

        public ArcPaintHistoryEvent(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
            this.oval = oval;
            this.startAngle = startAngle;
            this.sweepAngle = sweepAngle;
            this.useCenter = useCenter;
            this.paint = paint;
        }
    }

    public static class CirclePaintHistoryEvent {
        public final float centerX;
        public final float centerY;
        public final float radius;
        public final Paint paint;

        private CirclePaintHistoryEvent(float centerX, float centerY, float radius, Paint paint) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.radius = radius;
            this.paint = paint;
        }
    }

    private static class PathPaintHistoryEvent {
        private final Path drawnPath;
        private final Paint pathPaint;

        PathPaintHistoryEvent(Path drawnPath, Paint pathPaint) {
            this.drawnPath = drawnPath;
            this.pathPaint = pathPaint;
        }
    }

    public static class RectPaintHistoryEvent {
        public final Paint paint;
        public final RectF rect;
        public final float left;
        public final float top;
        public final float right;
        public final float bottom;

        private RectPaintHistoryEvent(float left, float top, float right, float bottom, Paint paint) {
            this.rect = new RectF(left, top, right, bottom);
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
            this.paint.setTextSize(paint.getTextSize());
            this.paint.setStyle(paint.getStyle());
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }
    }

    public static class OvalPaintHistoryEvent {
        public final RectF oval;
        public final Paint paint;

        private OvalPaintHistoryEvent(RectF oval, Paint paint) {
            this.oval = new RectF(oval);
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
        }
    }

    public static class LinePaintHistoryEvent {
        public Paint paint;
        public float startX;
        public float startY;
        public float stopX;
        public float stopY;

        private LinePaintHistoryEvent(float startX, float startY, float stopX, float stopY, Paint paint) {
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
            this.startX = startX;
            this.startY = startY;
            this.stopX = stopX;
            this.stopY = stopY;
        }
    }
}

