/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageDecoder;
import android.graphics.Point;
import java.io.IOException;
import java.io.InputStream;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ImageUtil;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ImageDecoder.class, isInAndroidSdk=false, minSdk=10000)
public class ShadowImageDecoder {
    @RealObject
    private ImageDecoder realObject;

    @Implementation
    protected static ImageDecoder nCreate(long asset) {
        return (ImageDecoder)ReflectionHelpers.callConstructor(ImageDecoder.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)1), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false)});
    }

    @Implementation
    protected static ImageDecoder nCreate(InputStream is, byte[] storage) {
        Point size = ImageUtil.getImageSizeFromStream(is);
        int width = size == null ? 0 : size.x;
        int height = size == null ? 0 : size.y;
        return (ImageDecoder)ReflectionHelpers.callConstructor(ImageDecoder.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)1), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)width), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)height), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false)});
    }

    @Implementation
    protected Bitmap decodeBitmap() throws IOException {
        InputStream stream = (InputStream)ReflectionHelpers.getField((Object)this.realObject, (String)"mInputStream");
        if (stream != null) {
            return BitmapFactory.decodeStream((InputStream)stream);
        }
        return null;
    }
}

