/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.ParcelFileDescriptor;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.LongSparseArray;
import android.util.TypedValue;
import android.view.Display;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.Plural;
import org.robolectric.res.PluralRules;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.TypedResource;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.shadows.ShadowDrawable;
import org.robolectric.shadows.ShadowResourcesImpl;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Resources.class)
public class ShadowResources {
    private static Resources system = null;
    private static List<LongSparseArray<?>> resettableArrays;
    @RealObject
    Resources realResources;

    @Resetter
    public static void reset() {
        if (resettableArrays == null) {
            resettableArrays = ShadowResources.obtainResettableArrays();
        }
        for (LongSparseArray<?> sparseArray : resettableArrays) {
            sparseArray.clear();
        }
        system = null;
    }

    private static List<LongSparseArray<?>> obtainResettableArrays() {
        Field[] allFields;
        ArrayList resettableArrays = new ArrayList();
        for (Field field : allFields = Resources.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(LongSparseArray.class)) continue;
            field.setAccessible(true);
            try {
                LongSparseArray longSparseArray = (LongSparseArray)field.get(null);
                if (longSparseArray == null) continue;
                resettableArrays.add(longSparseArray);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return resettableArrays;
    }

    @Implementation
    public static Resources getSystem() {
        if (system == null) {
            AssetManager assetManager = AssetManager.getSystem();
            DisplayMetrics metrics = new DisplayMetrics();
            Configuration config = new Configuration();
            system = new Resources(assetManager, metrics, config);
        }
        return system;
    }

    @Implementation
    public TypedArray obtainAttributes(AttributeSet set, int[] attrs) {
        return Shadows.shadowOf(this.realResources.getAssets()).attrsToTypedArray(this.realResources, set, attrs, 0, 0L, 0);
    }

    @Implementation
    public String getQuantityString(int id2, int quantity, Object ... formatArgs) throws Resources.NotFoundException {
        String raw = this.getQuantityString(id2, quantity);
        return String.format(Locale.ENGLISH, raw, formatArgs);
    }

    @Implementation
    public String getQuantityString(int resId, int quantity) throws Resources.NotFoundException {
        ShadowAssetManager shadowAssetManager = Shadows.shadowOf(this.realResources.getAssets());
        TypedResource typedResource = shadowAssetManager.getResourceTable().getValue(resId, shadowAssetManager.config);
        if (typedResource != null && typedResource instanceof PluralRules) {
            PluralRules pluralRules = (PluralRules)typedResource;
            Plural plural = pluralRules.find(quantity);
            if (plural == null) {
                return null;
            }
            TypedResource resolvedTypedResource = shadowAssetManager.resolve(new TypedResource((Object)plural.getString(), ResType.CHAR_SEQUENCE, pluralRules.getXmlContext()), shadowAssetManager.config, resId);
            return resolvedTypedResource == null ? null : resolvedTypedResource.asString();
        }
        return null;
    }

    @Implementation
    public InputStream openRawResource(int id2) throws Resources.NotFoundException {
        ShadowAssetManager shadowAssetManager = Shadows.shadowOf(this.realResources.getAssets());
        ResourceTable resourceTable = shadowAssetManager.getResourceTable();
        InputStream inputStream = resourceTable.getRawValue(id2, shadowAssetManager.config);
        if (inputStream == null) {
            throw this.newNotFoundException(id2);
        }
        return inputStream;
    }

    @Implementation
    public AssetFileDescriptor openRawResourceFd(int id2) throws Resources.NotFoundException {
        InputStream inputStream = this.openRawResource(id2);
        if (!(inputStream instanceof FileInputStream)) {
            return null;
        }
        FileInputStream fis = (FileInputStream)inputStream;
        try {
            return new AssetFileDescriptor(ParcelFileDescriptor.dup((FileDescriptor)fis.getFD()), 0L, fis.getChannel().size());
        }
        catch (IOException e) {
            throw this.newNotFoundException(id2);
        }
    }

    private Resources.NotFoundException newNotFoundException(int id2) {
        ResourceTable resourceTable = Shadows.shadowOf(this.realResources.getAssets()).getResourceTable();
        ResName resName = resourceTable.getResName(id2);
        if (resName == null) {
            return new Resources.NotFoundException("resource ID #0x" + Integer.toHexString(id2));
        }
        return new Resources.NotFoundException(resName.getFullyQualifiedName());
    }

    @Implementation
    public TypedArray obtainTypedArray(int id2) throws Resources.NotFoundException {
        ShadowAssetManager shadowAssetManager = Shadows.shadowOf(this.realResources.getAssets());
        TypedArray typedArray = shadowAssetManager.getTypedArrayResource(this.realResources, id2);
        if (typedArray != null) {
            return typedArray;
        }
        throw this.newNotFoundException(id2);
    }

    @Deprecated
    public void setDensity(float density) {
        this.realResources.getDisplayMetrics().density = density;
    }

    @Deprecated
    public void setScaledDensity(float scaledDensity) {
        this.realResources.getDisplayMetrics().scaledDensity = scaledDensity;
    }

    @Deprecated
    public void setDisplay(Display display) {
        DisplayMetrics displayMetrics = this.realResources.getDisplayMetrics();
        display.getMetrics(displayMetrics);
    }

    @HiddenApi
    @Implementation
    public XmlResourceParser loadXmlResourceParser(int resId, String type) throws Resources.NotFoundException {
        ShadowAssetManager shadowAssetManager = Shadows.shadowOf(this.realResources.getAssets());
        return shadowAssetManager.loadXmlResourceParser(resId, type);
    }

    @HiddenApi
    @Implementation
    public XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        return this.loadXmlResourceParser(id2, type);
    }

    @HiddenApi
    @Implementation
    public Drawable loadDrawable(TypedValue value, int id2) {
        Drawable drawable = (Drawable)Shadow.directlyOn((Object)this.realResources, Resources.class, (String)"loadDrawable", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(TypedValue.class, (Object)value), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)id2)});
        ShadowResources.setCreatedFromResId(this.realResources, id2, drawable);
        return drawable;
    }

    @Implementation
    public Drawable loadDrawable(TypedValue value, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        Drawable drawable = (Drawable)Shadow.directlyOn((Object)this.realResources, Resources.class, (String)"loadDrawable", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(TypedValue.class, (Object)value), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)id2), ReflectionHelpers.ClassParameter.from(Resources.Theme.class, (Object)theme)});
        ShadowResources.setCreatedFromResId(this.realResources, id2, drawable);
        return drawable;
    }

    static void setCreatedFromResId(Resources resources, int id2, Drawable drawable) {
        if (drawable != null && Shadow.extract((Object)drawable) instanceof ShadowDrawable) {
            Bitmap bitmap;
            Shadows.shadowOf((Drawable)drawable).createdFromResId = id2;
            if (drawable instanceof BitmapDrawable && (bitmap = ((BitmapDrawable)drawable).getBitmap()) != null && Shadow.extract((Object)bitmap) instanceof ShadowBitmap) {
                ShadowBitmap shadowBitmap = Shadows.shadowOf(bitmap);
                if (shadowBitmap.createdFromResId == -1) {
                    shadowBitmap.setCreatedFromResId(id2, Shadows.shadowOf(resources.getAssets()).getResourceName(id2));
                }
            }
        }
    }

    @Implements(value=Resources.NotFoundException.class)
    public static class ShadowNotFoundException {
        @RealObject
        Resources.NotFoundException realObject;
        private String message;

        @Implementation
        public void __constructor__() {
        }

        @Implementation
        public void __constructor__(String name) {
            this.message = name;
        }

        @Implementation
        public String toString() {
            return this.realObject.getClass().getName() + ": " + this.message;
        }
    }

    @Implements(value=Resources.Theme.class)
    public static class ShadowTheme {
        @RealObject
        Resources.Theme realTheme;

        long getNativePtr() {
            if (RuntimeEnvironment.getApiLevel() >= 24) {
                ResourcesImpl.ThemeImpl themeImpl = (ResourcesImpl.ThemeImpl)ReflectionHelpers.getField((Object)this.realTheme, (String)"mThemeImpl");
                return ((ShadowResourcesImpl.ShadowThemeImpl)Shadow.extract((Object)themeImpl)).getNativePtr();
            }
            return ((Number)ReflectionHelpers.getField((Object)this.realTheme, (String)"mTheme")).longValue();
        }

        @Implementation(maxSdk=23)
        public TypedArray obtainStyledAttributes(int[] attrs) {
            return this.obtainStyledAttributes(0, attrs);
        }

        @Implementation(maxSdk=23)
        public TypedArray obtainStyledAttributes(int resid, int[] attrs) throws Resources.NotFoundException {
            return this.obtainStyledAttributes(null, attrs, 0, resid);
        }

        @Implementation(maxSdk=23)
        public TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            return this.getShadowAssetManager().attrsToTypedArray(this.getResources(), set, attrs, defStyleAttr, this.getNativePtr(), defStyleRes);
        }

        private ShadowAssetManager getShadowAssetManager() {
            return Shadows.shadowOf(this.getResources().getAssets());
        }

        private Resources getResources() {
            return (Resources)ReflectionHelpers.getField((Object)this.realTheme, (String)"this$0");
        }
    }
}

