/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.util;

import com.almworks.sqlite4java.SQLite;
import com.almworks.sqlite4java.SQLiteException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robolectric.res.Fs;

public class SQLiteLibraryLoader {
    private static SQLiteLibraryLoader instance;
    private static final String SQLITE4JAVA = "sqlite4java";
    private static final String OS_WIN = "windows";
    private static final String OS_LINUX = "linux";
    private static final String OS_MAC = "mac";
    private final LibraryNameMapper libraryNameMapper;
    private boolean loaded;
    private static final LibraryNameMapper DEFAULT_MAPPER;

    public SQLiteLibraryLoader() {
        this(DEFAULT_MAPPER);
    }

    public SQLiteLibraryLoader(LibraryNameMapper mapper) {
        this.libraryNameMapper = mapper;
    }

    public static synchronized void load() {
        if (instance == null) {
            instance = new SQLiteLibraryLoader();
        }
        instance.doLoad();
    }

    public void doLoad() {
        if (this.loaded) {
            return;
        }
        long startTime = System.currentTimeMillis();
        File extractedLibrary = this.getNativeLibraryPath();
        if (this.isExtractedLibUptodate(extractedLibrary)) {
            this.loadFromDirectory(extractedLibrary.getParentFile());
        } else {
            this.extractAndLoad(this.getLibraryStream(), extractedLibrary);
        }
        this.logWithTime("SQLite natives prepared in", startTime);
    }

    public File getNativeLibraryPath() {
        String tempPath = System.getProperty("java.io.tmpdir");
        if (tempPath == null) {
            throw new IllegalStateException("Java temporary directory is not defined (java.io.tmpdir)");
        }
        return new File(Fs.fileFromPath((String)tempPath).join(new String[]{"robolectric-libs", this.getLibName()}).getPath());
    }

    public void mustReload() {
        this.loaded = false;
    }

    public String getLibClasspathResourceName() {
        return "/" + this.getNativesResourcesPathPart() + "/" + this.getNativesResourcesFilePart();
    }

    private InputStream getLibraryStream() {
        String classpathResourceName = this.getLibClasspathResourceName();
        InputStream libraryStream = SQLiteLibraryLoader.class.getResourceAsStream(classpathResourceName);
        if (libraryStream == null) {
            throw new RuntimeException("Cannot find '" + classpathResourceName + "' in classpath");
        }
        return libraryStream;
    }

    private void logWithTime(String message, long startTime) {
        this.log(message + " " + (System.currentTimeMillis() - startTime));
    }

    private void log(String message) {
        org.robolectric.util.Logger.debug((String)message, (Object[])new Object[0]);
    }

    private boolean isExtractedLibUptodate(File extractedLib) {
        if (extractedLib.exists()) {
            try {
                String existingMd5 = this.md5sum(new FileInputStream(extractedLib));
                String actualMd5 = this.md5sum(this.getLibraryStream());
                return existingMd5.equals(actualMd5);
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private void extractAndLoad(InputStream input, File output) {
        File libPath = output.getParentFile();
        if (!libPath.exists() && !libPath.mkdirs()) {
            throw new RuntimeException("could not create " + libPath);
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(output);
            SQLiteLibraryLoader.copy(input, outputStream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Cannot extractAndLoad SQLite library into " + output, e);
            }
            catch (Throwable throwable) {
                SQLiteLibraryLoader.closeQuietly(outputStream);
                SQLiteLibraryLoader.closeQuietly(input);
                throw throwable;
            }
        }
        SQLiteLibraryLoader.closeQuietly(outputStream);
        SQLiteLibraryLoader.closeQuietly(input);
        this.loadFromDirectory(libPath);
    }

    private void loadFromDirectory(File libPath) {
        Logger.getLogger("com.almworks.sqlite4java").setLevel(Level.WARNING);
        SQLite.setLibraryPath((String)libPath.getAbsolutePath());
        try {
            this.log("SQLite version: library " + SQLite.getLibraryVersion() + " / core " + SQLite.getSQLiteVersion());
        }
        catch (SQLiteException e) {
            throw new RuntimeException(e);
        }
        this.loaded = true;
    }

    private String getLibName() {
        return this.libraryNameMapper.mapLibraryName(SQLITE4JAVA);
    }

    private String getNativesResourcesPathPart() {
        return this.getOsPrefix() + "-" + this.getArchitectureSuffix();
    }

    private String getNativesResourcesFilePart() {
        return this.getLibName().replace(".dylib", ".jnilib");
    }

    private String getOsPrefix() {
        String name = System.getProperty("os.name").toLowerCase(Locale.US);
        if (name.contains("win")) {
            return OS_WIN;
        }
        if (name.contains(OS_LINUX)) {
            return OS_LINUX;
        }
        if (name.contains(OS_MAC)) {
            return OS_MAC;
        }
        throw new UnsupportedOperationException("Architecture '" + name + "' is not supported by SQLite library");
    }

    private String getArchitectureSuffix() {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.US).replaceAll("\\W", "");
        if ("i386".equals(arch) || "x86".equals(arch)) {
            return "x86";
        }
        return "x86_64";
    }

    private String md5sum(InputStream input) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(input);){
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(in, digest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream md5out = new ByteArrayOutputStream();
            md5out.write(digest.digest());
            String string = new BigInteger(md5out.toByteArray()).toString();
            return string;
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        DEFAULT_MAPPER = new LibraryNameMapper(){

            @Override
            public String mapLibraryName(String name) {
                return System.mapLibraryName(name);
            }
        };
    }

    public static interface LibraryNameMapper {
        public String mapLibraryName(String var1);
    }
}

