/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageParser;
import android.content.pm.PathPermission;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.Process;
import android.util.Pair;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.manifest.ActivityData;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.manifest.IntentFilterData;
import org.robolectric.manifest.PackageItemData;
import org.robolectric.manifest.PathPermissionData;
import org.robolectric.manifest.PermissionGroupItemData;
import org.robolectric.manifest.PermissionItemData;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.ResName;
import org.robolectric.util.ReflectionHelpers;

public class LegacyManifestParser {
    private static final List<Pair<String, Integer>> APPLICATION_FLAGS = Arrays.asList(Pair.create((Object)"android:allowBackup", (Object)32768), Pair.create((Object)"android:allowClearUserData", (Object)64), Pair.create((Object)"android:allowTaskReparenting", (Object)32), Pair.create((Object)"android:debuggable", (Object)2), Pair.create((Object)"android:hasCode", (Object)4), Pair.create((Object)"android:killAfterRestore", (Object)65536), Pair.create((Object)"android:persistent", (Object)8), Pair.create((Object)"android:resizeable", (Object)4096), Pair.create((Object)"android:restoreAnyVersion", (Object)131072), Pair.create((Object)"android:largeScreens", (Object)2048), Pair.create((Object)"android:normalScreens", (Object)1024), Pair.create((Object)"android:anyDensity", (Object)8192), Pair.create((Object)"android:smallScreens", (Object)512), Pair.create((Object)"android:testOnly", (Object)256), Pair.create((Object)"android:vmSafeMode", (Object)16384));
    private static final List<Pair<String, Integer>> CONFIG_OPTIONS = Arrays.asList(Pair.create((Object)"mcc", (Object)1), Pair.create((Object)"mnc", (Object)2), Pair.create((Object)"locale", (Object)4), Pair.create((Object)"touchscreen", (Object)8), Pair.create((Object)"keyboard", (Object)16), Pair.create((Object)"keyboardHidden", (Object)32), Pair.create((Object)"navigation", (Object)64), Pair.create((Object)"screenLayout", (Object)256), Pair.create((Object)"fontScale", (Object)0x40000000), Pair.create((Object)"uiMode", (Object)512), Pair.create((Object)"orientation", (Object)128), Pair.create((Object)"screenSize", (Object)1024), Pair.create((Object)"smallestScreenSize", (Object)2048));

    public static PackageParser.Package createPackage(AndroidManifest androidManifest) {
        PackageParser.ActivityIntentInfo outInfo;
        ProviderInfo info;
        PackageParser.Package pkg = new PackageParser.Package(androidManifest.getPackageName());
        pkg.mVersionName = androidManifest.getVersionName();
        pkg.mVersionCode = androidManifest.getVersionCode();
        Map permissionItemData = androidManifest.getPermissions();
        for (Object itemData : permissionItemData.values()) {
            PackageParser.Permission permission2 = new PackageParser.Permission(pkg, LegacyManifestParser.createPermissionInfo(pkg, (PermissionItemData)itemData));
            permission2.metaData = permission2.info.metaData;
            pkg.permissions.add(permission2);
        }
        Map permissionGroupItemData = androidManifest.getPermissionGroups();
        for (PermissionGroupItemData itemData : permissionGroupItemData.values()) {
            PackageParser.PermissionGroup permissionGroup = new PackageParser.PermissionGroup(pkg, LegacyManifestParser.createPermissionGroupInfo(pkg, itemData));
            permissionGroup.metaData = permissionGroup.info.metaData;
            pkg.permissionGroups.add(permissionGroup);
        }
        pkg.requestedPermissions.addAll(androidManifest.getUsedPermissions());
        if (RuntimeEnvironment.getApiLevel() < 23) {
            List permissionsRequired = (List)ReflectionHelpers.getField((Object)pkg, (String)"requestedPermissionsRequired");
            permissionsRequired.addAll(LegacyManifestParser.buildBooleanList(pkg.requestedPermissions.size(), true));
        }
        pkg.applicationInfo.flags = LegacyManifestParser.decodeFlags(androidManifest.getApplicationAttributes());
        pkg.applicationInfo.targetSdkVersion = androidManifest.getTargetSdkVersion();
        pkg.applicationInfo.packageName = androidManifest.getPackageName();
        pkg.applicationInfo.processName = androidManifest.getProcessName();
        if (!Strings.isNullOrEmpty((String)androidManifest.getApplicationName())) {
            pkg.applicationInfo.className = LegacyManifestParser.buildClassName(pkg.applicationInfo.packageName, androidManifest.getApplicationName());
            if (RuntimeEnvironment.getApiLevel() >= 25) {
                pkg.applicationInfo.name = pkg.applicationInfo.className;
            }
        }
        pkg.applicationInfo.metaData = LegacyManifestParser.metaDataToBundle(androidManifest.getApplicationMetaData());
        pkg.applicationInfo.uid = Process.myUid();
        if (androidManifest.getThemeRef() != null) {
            pkg.applicationInfo.theme = RuntimeEnvironment.getAppResourceTable().getResourceId(ResName.qualifyResName((String)androidManifest.getThemeRef().replace("@", ""), (String)pkg.packageName, (String)"style"));
        }
        int labelRes = 0;
        if (androidManifest.getLabelRef() != null) {
            String fullyQualifiedName = ResName.qualifyResName((String)androidManifest.getLabelRef(), (String)androidManifest.getPackageName());
            Integer id2 = fullyQualifiedName == null ? null : RuntimeEnvironment.getAppResourceTable().getResourceId(new ResName(fullyQualifiedName));
            labelRes = id2 != null ? id2 : 0;
        }
        pkg.applicationInfo.labelRes = labelRes;
        String labelRef = androidManifest.getLabelRef();
        if (labelRef != null && !labelRef.startsWith("@")) {
            pkg.applicationInfo.nonLocalizedLabel = labelRef;
        }
        Map activityDatas = androidManifest.getActivityDatas();
        for (ActivityData data : activityDatas.values()) {
            ActivityInfo activityInfo = new ActivityInfo();
            activityInfo.name = LegacyManifestParser.buildClassName(pkg.packageName, data.getName());
            activityInfo.packageName = pkg.packageName;
            activityInfo.configChanges = LegacyManifestParser.getConfigChanges(data);
            activityInfo.parentActivityName = data.getParentActivityName();
            activityInfo.metaData = LegacyManifestParser.metaDataToBundle(data.getMetaData().getValueMap());
            activityInfo.applicationInfo = pkg.applicationInfo;
            activityInfo.targetActivity = data.getTargetActivityName();
            activityInfo.exported = data.isExported();
            activityInfo.permission = data.getPermission();
            activityInfo.enabled = data.isEnabled();
            String themeRef = data.getThemeRef() != null ? data.getThemeRef() : androidManifest.getThemeRef();
            if (themeRef != null) {
                activityInfo.theme = RuntimeEnvironment.getAppResourceTable().getResourceId(ResName.qualifyResName((String)themeRef.replace("@", ""), (String)pkg.packageName, (String)"style"));
            }
            if (data.getLabel() != null) {
                activityInfo.labelRes = RuntimeEnvironment.getAppResourceTable().getResourceId(ResName.qualifyResName((String)data.getLabel().replace("@", ""), (String)pkg.packageName, (String)"string"));
                if (activityInfo.labelRes == 0) {
                    activityInfo.nonLocalizedLabel = data.getLabel();
                }
            }
            PackageParser.Activity activity = LegacyManifestParser.createActivity(pkg, activityInfo);
            for (IntentFilterData intentFilterData : data.getIntentFilters()) {
                PackageParser.ActivityIntentInfo outInfo2 = new PackageParser.ActivityIntentInfo(activity);
                LegacyManifestParser.populateIntentInfo(intentFilterData, (PackageParser.IntentInfo)outInfo2);
                activity.intents.add(outInfo2);
            }
            pkg.activities.add(activity);
        }
        for (ActivityData data : androidManifest.getContentProviders()) {
            info = new ProviderInfo();
            LegacyManifestParser.populateComponentInfo((ComponentInfo)info, pkg, (PackageItemData)data);
            info.authority = data.getAuthorities();
            ArrayList<PathPermission> permissions = new ArrayList<PathPermission>();
            for (PathPermissionData permissionData : data.getPathPermissionDatas()) {
                permissions.add(LegacyManifestParser.createPathPermission(permissionData));
            }
            info.pathPermissions = permissions.toArray(new PathPermission[permissions.size()]);
            info.readPermission = data.getReadPermission();
            info.writePermission = data.getWritePermission();
            info.grantUriPermissions = data.getGrantUriPermissions();
            info.enabled = data.isEnabled();
            pkg.providers.add(LegacyManifestParser.createProvider(pkg, info));
        }
        for (ActivityData data : androidManifest.getBroadcastReceivers()) {
            info = new ActivityInfo();
            LegacyManifestParser.populateComponentInfo((ComponentInfo)info, pkg, (PackageItemData)data);
            info.permission = data.getPermission();
            info.exported = data.isExported();
            info.enabled = data.isEnabled();
            PackageParser.Activity receiver = LegacyManifestParser.createActivity(pkg, (ActivityInfo)info);
            for (IntentFilterData intentFilterData : data.getIntentFilters()) {
                outInfo = new PackageParser.ActivityIntentInfo(receiver);
                LegacyManifestParser.populateIntentInfo(intentFilterData, (PackageParser.IntentInfo)outInfo);
                receiver.intents.add(outInfo);
            }
            pkg.receivers.add(receiver);
        }
        for (ActivityData data : androidManifest.getServices()) {
            info = new ServiceInfo();
            LegacyManifestParser.populateComponentInfo((ComponentInfo)info, pkg, (PackageItemData)data);
            info.permission = data.getPermission();
            info.exported = data.isExported();
            info.enabled = data.isEnabled();
            PackageParser.Service service = LegacyManifestParser.createService(pkg, (ServiceInfo)info);
            for (IntentFilterData intentFilterData : data.getIntentFilters()) {
                outInfo = new PackageParser.ServiceIntentInfo(service);
                LegacyManifestParser.populateIntentInfo(intentFilterData, (PackageParser.IntentInfo)outInfo);
                service.intents.add(outInfo);
            }
            pkg.services.add(service);
        }
        String codePath = RuntimeEnvironment.getTempDirectory().createIfNotExists(String.valueOf(pkg.packageName).concat("-codePath")).toAbsolutePath().toString();
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            pkg.codePath = codePath;
        } else {
            ReflectionHelpers.setField(PackageParser.Package.class, (Object)pkg, (String)"mPath", (Object)codePath);
        }
        return pkg;
    }

    private static PathPermission createPathPermission(PathPermissionData data) {
        if (!Strings.isNullOrEmpty((String)data.pathPattern)) {
            return new PathPermission(data.pathPattern, 2, data.readPermission, data.writePermission);
        }
        if (!Strings.isNullOrEmpty((String)data.path)) {
            return new PathPermission(data.path, 0, data.readPermission, data.writePermission);
        }
        if (!Strings.isNullOrEmpty((String)data.pathPrefix)) {
            return new PathPermission(data.pathPrefix, 1, data.readPermission, data.writePermission);
        }
        throw new IllegalStateException("Permission without type");
    }

    private static void populateComponentInfo(ComponentInfo outInfo, PackageParser.Package owner, PackageItemData itemData) {
        LegacyManifestParser.populatePackageItemInfo((PackageItemInfo)outInfo, owner, itemData);
        outInfo.applicationInfo = owner.applicationInfo;
    }

    private static void populatePackageItemInfo(PackageItemInfo outInfo, PackageParser.Package owner, PackageItemData itemData) {
        outInfo.name = LegacyManifestParser.buildClassName(owner.packageName, itemData.getName());
        outInfo.packageName = owner.packageName;
        outInfo.metaData = LegacyManifestParser.metaDataToBundle(itemData.getMetaData().getValueMap());
    }

    private static List<Boolean> buildBooleanList(int size, boolean defaultVal) {
        Object[] barray = new Boolean[size];
        Arrays.fill(barray, (Object)defaultVal);
        return Arrays.asList(barray);
    }

    private static PackageParser.Provider createProvider(PackageParser.Package pkg, ProviderInfo info) {
        PackageParser.Provider provider = (PackageParser.Provider)ReflectionHelpers.callConstructor(PackageParser.Provider.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        LegacyManifestParser.populateComponent(pkg, (ComponentInfo)info, (PackageParser.Component)provider);
        return provider;
    }

    private static PackageParser.Activity createActivity(PackageParser.Package pkg, ActivityInfo activityInfo) {
        PackageParser.Activity activity = (PackageParser.Activity)ReflectionHelpers.callConstructor(PackageParser.Activity.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        LegacyManifestParser.populateComponent(pkg, (ComponentInfo)activityInfo, (PackageParser.Component)activity);
        return activity;
    }

    private static PackageParser.Service createService(PackageParser.Package pkg, ServiceInfo info) {
        PackageParser.Service service = (PackageParser.Service)ReflectionHelpers.callConstructor(PackageParser.Service.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        LegacyManifestParser.populateComponent(pkg, (ComponentInfo)info, (PackageParser.Component)service);
        return service;
    }

    private static void populateComponent(PackageParser.Package pkg, ComponentInfo info, PackageParser.Component component) {
        ReflectionHelpers.setField((Object)component, (String)"info", (Object)info);
        ReflectionHelpers.setField((Object)component, (String)"intents", new ArrayList());
        ReflectionHelpers.setField((Object)component, (String)"owner", (Object)pkg);
        ReflectionHelpers.setField((Object)component, (String)"className", (Object)info.name);
    }

    private static void populateIntentInfo(IntentFilterData intentFilterData, PackageParser.IntentInfo outInfo) {
        for (String action : intentFilterData.getActions()) {
            outInfo.addAction(action);
        }
        for (String category : intentFilterData.getCategories()) {
            outInfo.addCategory(category);
        }
        for (IntentFilterData.DataAuthority dataAuthority : intentFilterData.getAuthorities()) {
            outInfo.addDataAuthority(dataAuthority.getHost(), dataAuthority.getPort());
        }
        for (String mimeType : intentFilterData.getMimeTypes()) {
            try {
                outInfo.addDataType(mimeType);
            }
            catch (IntentFilter.MalformedMimeTypeException e) {
                throw new RuntimeException(e);
            }
        }
        for (String scheme : intentFilterData.getSchemes()) {
            outInfo.addDataScheme(scheme);
        }
        for (String pathPattern : intentFilterData.getPathPatterns()) {
            outInfo.addDataPath(pathPattern, 2);
        }
        for (String pathPattern : intentFilterData.getPathPrefixes()) {
            outInfo.addDataPath(pathPattern, 1);
        }
        for (String pathPattern : intentFilterData.getPaths()) {
            outInfo.addDataPath(pathPattern, 0);
        }
    }

    private static int getConfigChanges(ActivityData activityData) {
        String[] pieces;
        String s = activityData.getConfigChanges();
        int res = 0;
        if (s == null || "".equals(s)) {
            return res;
        }
        block0: for (String s1 : pieces = s.split("\\|", 0)) {
            s1 = s1.trim();
            for (Pair<String, Integer> pair : CONFIG_OPTIONS) {
                if (!s1.equals(pair.first)) continue;
                res |= ((Integer)pair.second).intValue();
                continue block0;
            }
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            res |= 2;
            res |= 1;
        }
        return res;
    }

    private static int decodeFlags(Map<String, String> applicationAttributes) {
        int applicationFlags = 0;
        for (Pair<String, Integer> pair : APPLICATION_FLAGS) {
            if (!"true".equals(applicationAttributes.get(pair.first))) continue;
            applicationFlags |= ((Integer)pair.second).intValue();
        }
        return applicationFlags;
    }

    private static PermissionInfo createPermissionInfo(PackageParser.Package owner, PermissionItemData itemData) {
        String labelRefOrString;
        PermissionInfo permissionInfo = new PermissionInfo();
        LegacyManifestParser.populatePackageItemInfo((PackageItemInfo)permissionInfo, owner, (PackageItemData)itemData);
        permissionInfo.group = itemData.getPermissionGroup();
        permissionInfo.protectionLevel = LegacyManifestParser.decodeProtectionLevel(itemData.getProtectionLevel());
        permissionInfo.metaData = LegacyManifestParser.metaDataToBundle(itemData.getMetaData().getValueMap());
        String descriptionRef = itemData.getDescription();
        if (descriptionRef != null) {
            ResName descResName = AttributeResource.getResourceReference((String)descriptionRef, (String)owner.packageName, (String)"string");
            permissionInfo.descriptionRes = RuntimeEnvironment.getAppResourceTable().getResourceId(descResName);
        }
        if ((labelRefOrString = itemData.getLabel()) != null) {
            if (AttributeResource.isResourceReference((String)labelRefOrString)) {
                ResName labelResName = AttributeResource.getResourceReference((String)labelRefOrString, (String)owner.packageName, (String)"string");
                permissionInfo.labelRes = RuntimeEnvironment.getAppResourceTable().getResourceId(labelResName);
            } else {
                permissionInfo.nonLocalizedLabel = labelRefOrString;
            }
        }
        return permissionInfo;
    }

    private static PermissionGroupInfo createPermissionGroupInfo(PackageParser.Package owner, PermissionGroupItemData itemData) {
        String labelRefOrString;
        PermissionGroupInfo permissionGroupInfo = new PermissionGroupInfo();
        LegacyManifestParser.populatePackageItemInfo((PackageItemInfo)permissionGroupInfo, owner, (PackageItemData)itemData);
        permissionGroupInfo.metaData = LegacyManifestParser.metaDataToBundle(itemData.getMetaData().getValueMap());
        String descriptionRef = itemData.getDescription();
        if (descriptionRef != null) {
            ResName descResName = AttributeResource.getResourceReference((String)descriptionRef, (String)owner.packageName, (String)"string");
            permissionGroupInfo.descriptionRes = RuntimeEnvironment.getAppResourceTable().getResourceId(descResName);
        }
        if ((labelRefOrString = itemData.getLabel()) != null) {
            if (AttributeResource.isResourceReference((String)labelRefOrString)) {
                ResName labelResName = AttributeResource.getResourceReference((String)labelRefOrString, (String)owner.packageName, (String)"string");
                permissionGroupInfo.labelRes = RuntimeEnvironment.getAppResourceTable().getResourceId(labelResName);
            } else {
                permissionGroupInfo.nonLocalizedLabel = labelRefOrString;
            }
        }
        return permissionGroupInfo;
    }

    private static int decodeProtectionLevel(String protectionLevel) {
        String[] levels;
        if (protectionLevel == null) {
            return 0;
        }
        int permissions = 0;
        String[] stringArray = levels = protectionLevel.split("\\|", 0);
        int n = stringArray.length;
        block40: for (int i = 0; i < n; ++i) {
            String level;
            switch (level = stringArray[i]) {
                case "normal": {
                    permissions |= 0;
                    continue block40;
                }
                case "dangerous": {
                    permissions |= 1;
                    continue block40;
                }
                case "signature": {
                    permissions |= 2;
                    continue block40;
                }
                case "signatureOrSystem": {
                    permissions |= 3;
                    continue block40;
                }
                case "privileged": {
                    permissions |= 0x10;
                    continue block40;
                }
                case "system": {
                    permissions |= 0x10;
                    continue block40;
                }
                case "development": {
                    permissions |= 0x20;
                    continue block40;
                }
                case "appop": {
                    permissions |= 0x40;
                    continue block40;
                }
                case "pre23": {
                    permissions |= 0x80;
                    continue block40;
                }
                case "installer": {
                    permissions |= 0x100;
                    continue block40;
                }
                case "verifier": {
                    permissions |= 0x200;
                    continue block40;
                }
                case "preinstalled": {
                    permissions |= 0x400;
                    continue block40;
                }
                case "setup": {
                    permissions |= 0x800;
                    continue block40;
                }
                case "instant": {
                    permissions |= 0x1000;
                    continue block40;
                }
                case "runtime": {
                    permissions |= 0x2000;
                    continue block40;
                }
                case "oem": {
                    permissions |= 0x4000;
                    continue block40;
                }
                case "vendorPrivileged": {
                    permissions |= 0x8000;
                    continue block40;
                }
                case "textClassifier": {
                    permissions |= 0x10000;
                    continue block40;
                }
                default: {
                    String string = String.valueOf(protectionLevel);
                    throw new IllegalArgumentException(string.length() != 0 ? "unknown protection level ".concat(string) : new String("unknown protection level "));
                }
            }
        }
        return permissions;
    }

    private static Bundle metaDataToBundle(Map<String, Object> meta) {
        if (meta.size() == 0) {
            return null;
        }
        Bundle bundle = new Bundle();
        for (Map.Entry<String, Object> entry : meta.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (Boolean.class.isInstance(value)) {
                bundle.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (Float.class.isInstance(value)) {
                bundle.putFloat(key, ((Float)value).floatValue());
                continue;
            }
            if (Integer.class.isInstance(value)) {
                bundle.putInt(key, ((Integer)value).intValue());
                continue;
            }
            bundle.putString(key, value == null ? null : value.toString());
        }
        return bundle;
    }

    private static String buildClassName(String pkg, String cls) {
        if (Strings.isNullOrEmpty((String)cls)) {
            String string = String.valueOf(pkg);
            throw new IllegalArgumentException(string.length() != 0 ? "Empty class name in package ".concat(string) : new String("Empty class name in package "));
        }
        char c = cls.charAt(0);
        if (c == '.') {
            String string = String.valueOf(pkg);
            String string2 = String.valueOf(cls);
            return (string2.length() != 0 ? string.concat(string2) : new String(string)).intern();
        }
        if (cls.indexOf(46) < 0) {
            StringBuilder b = new StringBuilder(pkg);
            b.append('.');
            b.append(cls);
            return b.toString();
        }
        return cls;
    }
}

