/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.MessageQueue;
import android.view.DisplayEventReceiver;
import java.lang.ref.WeakReference;
import java.time.Duration;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowSystem;
import org.robolectric.shadows.ShadowSystemClock;
import org.robolectric.util.ReflectionHelpers;

@Implements(className="android.view.DisplayEventReceiver", isInAndroidSdk=false, looseSignatures=true)
public class ShadowDisplayEventReceiver {
    private static NativeObjRegistry<NativeDisplayEventReceiver> nativeObjRegistry = new NativeObjRegistry(NativeDisplayEventReceiver.class);
    @RealObject
    protected DisplayEventReceiver receiver;
    private static final Duration VSYNC_DELAY = Duration.ofMillis(1L);

    @Implementation(minSdk=26)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue, int vsyncSource) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(receiver));
    }

    @Implementation(minSdk=23, maxSdk=25)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(receiver));
    }

    @Implementation(minSdk=20, maxSdk=22)
    protected static long nativeInit(DisplayEventReceiver receiver, MessageQueue msgQueue) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(new WeakReference<DisplayEventReceiver>(receiver)));
    }

    @Implementation(maxSdk=19)
    protected static int nativeInit(Object receiver, Object msgQueue) {
        return (int)nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(new WeakReference<DisplayEventReceiver>((DisplayEventReceiver)receiver)));
    }

    @Implementation(minSdk=20)
    protected static void nativeDispose(long receiverPtr) {
        nativeObjRegistry.unregister(receiverPtr);
    }

    @Implementation(maxSdk=19)
    protected static void nativeDispose(int receiverPtr) {
        nativeObjRegistry.unregister((long)receiverPtr);
    }

    @Implementation(minSdk=20)
    protected static void nativeScheduleVsync(long receiverPtr) {
        ((NativeDisplayEventReceiver)nativeObjRegistry.getNativeObject(receiverPtr)).scheduleVsync();
    }

    @Implementation(maxSdk=19)
    protected static void nativeScheduleVsync(int receiverPtr) {
        ((NativeDisplayEventReceiver)nativeObjRegistry.getNativeObject((long)receiverPtr)).scheduleVsync();
    }

    protected void onVsync() {
        if (RuntimeEnvironment.getApiLevel() <= 16) {
            ReflectionHelpers.callInstanceMethod(DisplayEventReceiver.class, (Object)this.receiver, (String)"onVsync", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)ShadowSystem.nanoTime()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)1)});
        } else if (RuntimeEnvironment.getApiLevel() < 29) {
            ReflectionHelpers.callInstanceMethod(DisplayEventReceiver.class, (Object)this.receiver, (String)"onVsync", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)ShadowSystem.nanoTime()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)1)});
        } else {
            this.receiver.onVsync(ShadowSystem.nanoTime(), 0L, 1);
        }
    }

    private static class NativeDisplayEventReceiver {
        private final WeakReference<DisplayEventReceiver> receiverRef;

        public NativeDisplayEventReceiver(WeakReference<DisplayEventReceiver> receiverRef) {
            this.receiverRef = receiverRef;
        }

        public void scheduleVsync() {
            DisplayEventReceiver receiver = (DisplayEventReceiver)this.receiverRef.get();
            ShadowSystemClock.advanceBy(VSYNC_DELAY);
            if (receiver != null) {
                ShadowDisplayEventReceiver shadowReceiver = (ShadowDisplayEventReceiver)Shadow.extract((Object)receiver);
                shadowReceiver.onVsync();
            }
        }
    }
}

