/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.view.Surface;
import com.google.common.base.Preconditions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=MediaCodec.class, minSdk=16, looseSignatures=true)
public class ShadowMediaCodec {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private static final int BUFFER_COUNT = 10;
    private static final int EVENT_CALLBACK = 1;
    private static final int CB_INPUT_AVAILABLE = 1;
    private static final int CB_OUTPUT_AVAILABLE = 2;
    private static final int CB_OUTPUT_FORMAT_CHANGE = 4;
    private static final Map<String, CodecConfig> encoders = new HashMap<String, CodecConfig>();
    private static final Map<String, CodecConfig> decoders = new HashMap<String, CodecConfig>();
    private static final CodecConfig DEFAULT_CODEC = new CodecConfig(512, 512, (in, out) -> out.put(in));
    @RealObject
    private MediaCodec realCodec;
    private CodecConfig.Codec fakeCodec;
    private MediaCodec.Callback callback;
    private MediaFormat pendingOutputFormat;
    private MediaFormat outputFormat;
    private final BlockingQueue<Integer> inputBufferAvailableIndexes = new LinkedBlockingDeque<Integer>();
    private final BlockingQueue<Integer> outputBufferAvailableIndexes = new LinkedBlockingDeque<Integer>();
    private final ByteBuffer[] inputBuffers = new ByteBuffer[10];
    private final ByteBuffer[] outputBuffers = new ByteBuffer[10];
    private final MediaCodec.BufferInfo[] outputBufferInfos = new MediaCodec.BufferInfo[10];
    private boolean isAsync = false;

    public static void addEncoder(String type, CodecConfig config) {
        encoders.put(type, config);
    }

    public static void addDecoder(String type, CodecConfig config) {
        decoders.put(type, config);
    }

    public static void clearCodecs() {
        encoders.clear();
        decoders.clear();
    }

    @Implementation
    protected void __constructor__(String name, boolean nameIsType, boolean encoder) {
        Shadow.invokeConstructor(MediaCodec.class, (Object)this.realCodec, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)name), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)nameIsType), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)encoder)});
        CodecConfig codecConfig = encoder ? encoders.getOrDefault(name, DEFAULT_CODEC) : decoders.getOrDefault(name, DEFAULT_CODEC);
        this.fakeCodec = codecConfig.codec;
        for (int i = 0; i < 10; ++i) {
            this.inputBuffers[i] = ByteBuffer.allocateDirect(codecConfig.inputBufferSize).order(ByteOrder.LITTLE_ENDIAN);
            this.outputBuffers[i] = ByteBuffer.allocateDirect(codecConfig.outputBufferSize).order(ByteOrder.LITTLE_ENDIAN);
            this.outputBufferInfos[i] = new MediaCodec.BufferInfo();
        }
    }

    @Implementation(minSdk=21)
    protected void native_setCallback(MediaCodec.Callback callback) {
        this.callback = callback;
    }

    @Implementation(minSdk=21, maxSdk=25)
    protected void native_configure(String[] keys, Object[] values, Surface surface, MediaCrypto crypto, int flags) {
        this.configure(keys, values);
    }

    @Implementation(minSdk=26)
    protected void native_configure(Object keys, Object values, Object surface, Object crypto, Object descramblerBinder, Object flags) {
        this.configure((String[])keys, (Object[])values);
    }

    private void configure(String[] keys, Object[] values) {
        this.isAsync = this.callback != null;
        this.pendingOutputFormat = ShadowMediaCodec.recreateMediaFormatFromKeysValues(keys, values);
    }

    @Implementation(minSdk=21)
    protected void native_start() {
        this.inputBufferAvailableIndexes.clear();
        this.outputBufferAvailableIndexes.clear();
        for (int i = 0; i < 10; ++i) {
            this.inputBufferAvailableIndexes.add(i);
        }
        if (this.isAsync) {
            HashMap<String, ByteBuffer> format = new HashMap<String, ByteBuffer>();
            format.put("csd-0", ByteBuffer.wrap(new byte[]{19, 16}));
            format.put("csd-1", ByteBuffer.wrap(new byte[0]));
            this.postFakeNativeEvent(1, 4, 0, format);
            try {
                this.makeInputBufferAvailable(this.inputBufferAvailableIndexes.take());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Implementation(minSdk=21)
    protected void native_flush() {
        if (!this.isAsync) {
            this.inputBufferAvailableIndexes.clear();
            this.outputBufferAvailableIndexes.clear();
            for (int i = 0; i < 10; ++i) {
                this.inputBufferAvailableIndexes.add(i);
                ((Buffer)this.inputBuffers[i]).clear();
            }
        }
    }

    @Implementation
    protected ByteBuffer[] getBuffers(boolean input) {
        return input ? this.inputBuffers : this.outputBuffers;
    }

    @Implementation(minSdk=21)
    protected ByteBuffer getBuffer(boolean input, int index) {
        ByteBuffer[] buffers = input ? this.inputBuffers : this.outputBuffers;
        return index >= 0 && index < buffers.length && (!input || !this.codecOwnsInputBuffer(index)) ? buffers[index] : null;
    }

    protected int native_dequeueInputBuffer(long timeoutUs) {
        Preconditions.checkState((!this.isAsync ? 1 : 0) != 0, (Object)"Attempting to deque buffer in Async mode.");
        try {
            Integer index = timeoutUs < 0L ? this.inputBufferAvailableIndexes.take() : this.inputBufferAvailableIndexes.poll(timeoutUs, TimeUnit.MICROSECONDS);
            if (index == null) {
                return -1;
            }
            return index;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    @Implementation(minSdk=21)
    protected void native_queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        if (index < 0 || index >= this.inputBuffers.length || this.codecOwnsInputBuffer(index)) {
            ShadowMediaCodec.throwCodecException(0, 0, new StringBuilder(45).append("Input buffer not owned by client: ").append(index).toString());
        }
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        info.set(offset, size, presentationTimeUs, flags);
        this.makeOutputBufferAvailable(index, info);
    }

    @Implementation(minSdk=21)
    protected int native_dequeueOutputBuffer(MediaCodec.BufferInfo info, long timeoutUs) {
        Preconditions.checkState((!this.isAsync ? 1 : 0) != 0, (Object)"Attempting to deque buffer in Async mode.");
        try {
            if (this.pendingOutputFormat != null) {
                this.outputFormat = this.pendingOutputFormat;
                this.pendingOutputFormat = null;
                return -2;
            }
            Integer index = timeoutUs < 0L ? this.outputBufferAvailableIndexes.take() : this.outputBufferAvailableIndexes.poll(timeoutUs, TimeUnit.MICROSECONDS);
            if (index == null) {
                return -1;
            }
            ShadowMediaCodec.copyBufferInfo(this.outputBufferInfos[index], info);
            return index;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    private void makeInputBufferAvailable(int index) {
        if (index < 0 || index >= this.inputBuffers.length) {
            throw new IndexOutOfBoundsException("Cannot make non-existent input available.");
        }
        ((Buffer)this.inputBuffers[index]).clear();
        if (this.isAsync) {
            this.postFakeNativeEvent(1, 1, index, null);
        } else {
            this.inputBufferAvailableIndexes.add(index);
        }
    }

    private void makeOutputBufferAvailable(int index, MediaCodec.BufferInfo info) {
        if (index < 0 || index >= this.outputBuffers.length) {
            throw new IndexOutOfBoundsException("Cannot make non-existent output buffer available.");
        }
        ((Buffer)this.outputBuffers[index]).clear();
        ((Buffer)this.inputBuffers[index]).position(info.offset).limit(info.offset + info.size);
        this.fakeCodec.process(this.inputBuffers[index], this.outputBuffers[index]);
        this.outputBufferInfos[index].flags = info.flags;
        this.outputBufferInfos[index].size = this.outputBuffers[index].position();
        this.outputBufferInfos[index].offset = info.offset;
        this.outputBufferInfos[index].presentationTimeUs = info.presentationTimeUs;
        ((Buffer)this.outputBuffers[index]).position(0).limit(this.outputBufferInfos[index].size);
        this.outputBufferAvailableIndexes.add(index);
        if (this.isAsync) {
            this.postFakeNativeEvent(1, 2, index, this.outputBufferInfos[index]);
        }
        this.makeInputBufferAvailable(index);
    }

    private void postFakeNativeEvent(int what, int arg1, int arg2, Object obj) {
        ReflectionHelpers.callInstanceMethod(MediaCodec.class, (Object)this.realCodec, (String)"postEventFromNative", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)what), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)arg1), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)arg2), ReflectionHelpers.ClassParameter.from(Object.class, (Object)obj)});
    }

    private boolean codecOwnsInputBuffer(int index) {
        return this.inputBufferAvailableIndexes.contains(index);
    }

    @Implementation(minSdk=21)
    protected void invalidateByteBuffer(ByteBuffer[] buffers, int index) {
    }

    @Implementation(minSdk=21)
    protected void validateInputByteBuffer(ByteBuffer[] buffers, int index) {
    }

    @Implementation(minSdk=21)
    protected void revalidateByteBuffer(ByteBuffer[] buffers, int index) {
    }

    @Implementation(minSdk=21)
    protected void validateOutputByteBuffer(ByteBuffer[] buffers, int index, MediaCodec.BufferInfo info) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            ((Buffer)buffer).limit(info.offset + info.size).position(info.offset);
        }
    }

    @Implementation(minSdk=21)
    protected void invalidateByteBuffers(ByteBuffer[] buffers) {
    }

    @Implementation(minSdk=21)
    protected void freeByteBuffer(ByteBuffer buffer) {
    }

    @Implementation
    protected MediaFormat getOutputFormat() {
        if (this.outputFormat == null) {
            return new MediaFormat();
        }
        return this.outputFormat;
    }

    private static void copyBufferInfo(MediaCodec.BufferInfo from, MediaCodec.BufferInfo to) {
        to.set(from.offset, from.size, from.presentationTimeUs, from.flags);
    }

    private static MediaFormat recreateMediaFormatFromKeysValues(String[] keys, Object[] values) {
        MediaFormat mediaFormat = new MediaFormat();
        for (int i = 0; i < keys.length; ++i) {
            if (values[i] == null || values[i] instanceof ByteBuffer) {
                mediaFormat.setByteBuffer(keys[i], (ByteBuffer)values[i]);
                continue;
            }
            if (values[i] instanceof Integer) {
                mediaFormat.setInteger(keys[i], ((Integer)values[i]).intValue());
                continue;
            }
            if (values[i] instanceof Long) {
                mediaFormat.setLong(keys[i], ((Long)values[i]).longValue());
                continue;
            }
            if (values[i] instanceof Float) {
                mediaFormat.setFloat(keys[i], ((Float)values[i]).floatValue());
                continue;
            }
            if (values[i] instanceof String) {
                mediaFormat.setString(keys[i], (String)values[i]);
                continue;
            }
            throw new IllegalArgumentException("Invalid value for key.");
        }
        return mediaFormat;
    }

    private static void throwCodecException(int errorCode, int actionCode, String message) {
        throw (MediaCodec.CodecException)ReflectionHelpers.callConstructor(MediaCodec.CodecException.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)errorCode), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)actionCode), ReflectionHelpers.ClassParameter.from(String.class, (Object)message)});
    }

    public static final class CodecConfig {
        private final int inputBufferSize;
        private final int outputBufferSize;
        private final Codec codec;

        public CodecConfig(int inputBufferSize, int outputBufferSize, Codec codec) {
            this.inputBufferSize = inputBufferSize;
            this.outputBufferSize = outputBufferSize;
            this.codec = codec;
        }

        public static interface Codec {
            public void process(ByteBuffer var1, ByteBuffer var2);
        }
    }

    @Implements(className="android.media.MediaCodec$BufferMap$CodecBuffer", minSdk=21)
    protected static class ShadowCodecBuffer {
        @Implementation
        protected void __constructor__() {
        }

        @Implementation
        protected void free() {
        }
    }
}

