/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class TempDirectory {
    private final Path basePath;

    public TempDirectory(String name) {
        try {
            this.basePath = Files.createTempDirectory("robolectric-" + name, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                TempDirectory.this.destroy();
            }
        }));
    }

    public Path create(String name) {
        Path path = this.basePath.resolve(name);
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    public Path createIfNotExists(String name) {
        Path path = this.basePath.resolve(name);
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    public void destroy() {
        try {
            this.clearDirectory(this.basePath);
            Files.delete(this.basePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void clearDirectory(final Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!dir.equals(directory)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

