/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser;

import java.io.IOException;
import java.io.InputStream;
import org.savara.bpel.model.TPartnerLink;
import org.savara.bpel.model.TProcess;
import org.savara.bpel.parser.rules.DefaultParserContext;
import org.savara.bpel.util.BPELModelUtil;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.resources.ResourceLocator;
import org.savara.protocol.util.FeedbackHandlerProxy;
import org.savara.protocol.util.SavaraResourceLocatorProxy;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.parser.AnnotationProcessor;
import org.scribble.protocol.parser.ProtocolParser;

public class BPELProtocolParser
implements ProtocolParser {
    public boolean isSupported(Content content) {
        return content.hasExtension("bpel");
    }

    public ProtocolModel parse(ProtocolContext context, Content content, Journal journal) throws IOException {
        ProtocolModel ret = new ProtocolModel();
        InputStream is = content.getInputStream();
        TProcess process = BPELModelUtil.deserialize(is);
        is.close();
        Protocol protocol = new Protocol();
        ret.setProtocol(protocol);
        protocol.setName(process.getName());
        String role = null;
        if (process.getPartnerLinks() != null) {
            for (TPartnerLink pl : process.getPartnerLinks().getPartnerLink()) {
                if (pl.getMyRole() == null || pl.getMyRole().trim().length() <= 0) continue;
                role = pl.getMyRole();
                protocol.setLocatedRole(new Role(role));
                break;
            }
        }
        DefaultParserContext convContext = new DefaultParserContext(role, process, (ResourceLocator)new SavaraResourceLocatorProxy(context.getResourceLocator()));
        convContext.parse(process, protocol.getBlock().getContents(), (FeedbackHandler)new FeedbackHandlerProxy(journal));
        return ret;
    }

    public void setAnnotationProcessor(AnnotationProcessor ap) {
    }
}

