/*
 * Decompiled with CFR 0.152.
 */
package org.savara.common.util;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.savara.common.util.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MessageUtils {
    private static Logger logger = Logger.getLogger(MessageUtils.class.getName());

    public static String getMessageType(Object value) {
        String ret = null;
        if (value instanceof Node) {
            String namespace = ((Node)value).getNamespaceURI();
            String localpart = ((Node)value).getLocalName();
            if (value instanceof Element && ((Element)value).hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) {
                String type = ((Element)value).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                String prefix = XMLUtils.getPrefix(type);
                localpart = XMLUtils.getLocalname(type);
                if (prefix == null) {
                    namespace = null;
                } else {
                    namespace = ((Element)value).getAttribute("xmlns:" + prefix);
                    if (namespace != null && namespace.trim().length() == 0) {
                        namespace = null;
                    }
                }
            }
            ret = namespace == null ? localpart : new QName(namespace, localpart).toString();
        } else if (value instanceof String) {
            ret = String.class.getName();
            try {
                Node node = XMLUtils.getNode((String)value);
                ret = MessageUtils.getMessageType(node);
            }
            catch (Exception e) {
                logger.warning("Failed to obtain message type from value: " + value);
            }
        } else if (value != null) {
            ret = value.getClass().getName();
        }
        return ret;
    }
}

