/*
 * Decompiled with CFR 0.152.
 */
package org.savara.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtils {
    private static final String NS_LABEL = "ns";

    public static final String toText(Node node) throws Exception {
        String ret = null;
        try {
            int index;
            ByteArrayOutputStream xmlstr = new ByteArrayOutputStream();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(xmlstr);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(source, result);
            xmlstr.close();
            ret = new String(xmlstr.toByteArray());
            if (!(node instanceof Document) && (index = ret.indexOf("<?xml")) != -1) {
                index = ret.indexOf("<", 1);
                if (index != -1) {
                    ret = ret.substring(index);
                } else {
                    index = ret.indexOf("?>");
                    if (index != -1) {
                        index += 2;
                        while (index < ret.length() && Character.isWhitespace(ret.charAt(index))) {
                            ++index;
                        }
                        ret = ret.substring(index);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to transform DOM representation into text", e);
        }
        if (ret != null) {
            return XMLUtils.format(ret);
        }
        return ret;
    }

    public static final String format(String xmltext) {
        String ret = xmltext;
        int pos = 0;
        int prevpos = 0;
        StringBuffer buf = new StringBuffer();
        int level = 0;
        while ((pos = ret.indexOf(60, prevpos)) != -1) {
            int endpos;
            if (prevpos < pos && ret.substring(prevpos, pos).trim().length() > 0 && ret.charAt(prevpos - 1) != '?') {
                if (ret.charAt(prevpos) == '\r' && ret.charAt(prevpos + 1) == '\n') {
                    prevpos += 2;
                }
                for (int i = 0; i < level; ++i) {
                    buf.append("    ");
                }
                buf.append(ret.substring(prevpos, pos).trim());
                buf.append("\r\n");
            }
            if ((endpos = ret.indexOf(62, pos)) > 0) {
                boolean noreturn = false;
                if (pos > 0 && ret.charAt(pos + 1) == '/') {
                    --level;
                }
                for (int i = 0; i < level; ++i) {
                    buf.append("    ");
                }
                buf.append(ret.substring(pos, endpos + 1));
                if (!(ret.charAt(endpos - 1) == '?' || ret.charAt(endpos - 1) == '/' || pos > 0 && ret.charAt(pos + 1) == '/' || pos > 0 && ret.charAt(pos + 1) == '!')) {
                    ++level;
                }
                if (!noreturn) {
                    buf.append("\r\n");
                }
                pos = endpos + 1;
            }
            prevpos = pos;
        }
        if (prevpos != -1 && ret.substring(prevpos).trim().length() > 0) {
            buf.append(ret.substring(prevpos));
        }
        ret = buf.toString();
        return ret;
    }

    public static Node getNode(String text) throws Exception {
        Element ret = null;
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        ByteArrayInputStream xmlstr = new ByteArrayInputStream(text.getBytes());
        DocumentBuilder builder = fact.newDocumentBuilder();
        Document doc = builder.parse(xmlstr);
        ((InputStream)xmlstr).close();
        ret = doc.getDocumentElement();
        return ret;
    }

    public static String getLocalname(String qname) {
        String ret = qname;
        int pos = 0;
        if (qname != null && (pos = qname.indexOf(58)) != -1) {
            ret = qname.substring(pos + 1);
        }
        return ret;
    }

    public static String getPrefix(String qname) {
        String ret = qname;
        int pos = 0;
        if (qname != null && (pos = qname.indexOf(58)) != -1) {
            ret = qname.substring(0, pos);
        }
        return ret;
    }

    public static String getPrefixForNamespace(String namespace, Map<String, String> nsMap) {
        String prefix = null;
        prefix = nsMap.get(namespace);
        if (prefix == null) {
            prefix = NS_LABEL + (nsMap.size() + 1);
            nsMap.put(namespace, prefix);
        }
        return prefix;
    }

    public static String getNamespaceForPrefix(String prefix, Map<String, String> nsMap) {
        String ret = null;
        for (String namespace : nsMap.keySet()) {
            String p = nsMap.get(namespace);
            if (!prefix.equals(p)) continue;
            ret = namespace;
            break;
        }
        return ret;
    }
}

