/*
 * Decompiled with CFR 0.152.
 */
package org.savara.monitor.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.savara.monitor.ConversationInstanceId;
import org.savara.monitor.Message;
import org.savara.monitor.Monitor;
import org.savara.monitor.MonitorResult;
import org.savara.monitor.SessionStore;
import org.savara.monitor.impl.DescriptionCache;
import org.savara.protocol.ProtocolCriteria;
import org.savara.protocol.ProtocolId;
import org.savara.protocol.ProtocolUnknownException;
import org.savara.protocol.repository.ProtocolRepository;
import org.scribble.common.logging.CachedJournal;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.export.monitor.MonitorProtocolExporter;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.monitor.DefaultProtocolMonitor;
import org.scribble.protocol.monitor.DefaultSession;
import org.scribble.protocol.monitor.MonitorContext;
import org.scribble.protocol.monitor.ProtocolMonitor;
import org.scribble.protocol.monitor.Result;
import org.scribble.protocol.monitor.Session;
import org.scribble.protocol.monitor.model.Description;
import org.scribble.protocol.monitor.util.MonitorModelUtil;

public class DefaultMonitor
implements Monitor {
    private ProtocolRepository m_protocolRepository = null;
    private SessionStore m_sessionStore = null;
    private ProtocolMonitor m_monitor = new DefaultProtocolMonitor();
    private DescriptionCache m_descriptionCache = new DescriptionCache();
    private MonitorProtocolExporter m_exporter = new MonitorProtocolExporter();
    private static final Logger logger = Logger.getLogger(DefaultMonitor.class.getName());

    public void setProtocolMonitor(ProtocolMonitor pm) {
        this.m_monitor = pm;
    }

    public void setProtocolRepository(ProtocolRepository rep) {
        this.m_protocolRepository = rep;
    }

    public void setSessionStore(SessionStore store) {
        this.m_sessionStore = store;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MonitorResult process(ProtocolId pid, ConversationInstanceId cid, Message mesg) throws ProtocolUnknownException, IOException {
        MonitorResult ret = null;
        if (this.m_protocolRepository == null) {
            throw new IllegalStateException("Protocol repository has not been configured");
        }
        if (this.m_sessionStore == null) {
            throw new IllegalStateException("Session store has not been configured");
        }
        if (pid == null) {
            List pids = this.m_protocolRepository.getProtocols((ProtocolCriteria)mesg);
            if (pids == null) return ret;
            Iterator i$ = pids.iterator();
            while (i$.hasNext()) {
                ProtocolId pi = (ProtocolId)i$.next();
                try {
                    Result result = this.processProtocol(pi, cid, mesg);
                    if (result == null || result == Result.NOT_HANDLED) continue;
                    return new MonitorResult(pid, cid, result.isValid(), result.getReason(), result.getProperties());
                }
                catch (ProtocolUnknownException pue) {
                    logger.severe("Unknown protocol: Failed to process message against protocol id '" + pid + "'");
                }
            }
            return ret;
        }
        try {
            Result result = this.processProtocol(pid, cid, mesg);
            if (result == null) return ret;
            if (result == Result.NOT_HANDLED) return ret;
            return new MonitorResult(pid, cid, result.isValid(), result.getReason(), result.getProperties());
        }
        catch (ProtocolUnknownException pue) {
            logger.severe("Unknown protocol: Failed to process message against protocol id '" + pid + "'");
        }
        return ret;
    }

    protected Result processProtocol(ProtocolId pid, ConversationInstanceId cid, Message mesg) throws ProtocolUnknownException, IOException {
        Result ret = null;
        if (cid == null) {
            // empty if block
        }
        Description desc = this.getProtocolDescription(pid);
        Serializable session = this.m_sessionStore.find(pid, cid);
        MonitorContext context = null;
        boolean f_created = false;
        if (session == null) {
            session = new DefaultSession();
            this.m_sessionStore.create(pid, cid, session);
            if (session instanceof Session) {
                this.m_monitor.initialize(context, desc, (Session)session);
            }
            f_created = true;
        }
        if (session instanceof Session) {
            ret = this.m_monitor.messageSent(context, desc, (Session)session, null, (org.scribble.protocol.monitor.Message)mesg);
            if (f_created && ret == Result.NOT_HANDLED || ((Session)session).isFinished()) {
                this.m_sessionStore.remove(pid, cid);
            } else {
                this.m_sessionStore.update(pid, cid, session);
            }
        } else {
            throw new IOException("Inappropriate session type returned");
        }
        return ret;
    }

    protected Description getProtocolDescription(ProtocolId pid) {
        Description ret = this.getDescriptionCache().getDescription(pid);
        if (ret == null) {
            try {
                ProtocolModel pm = this.m_protocolRepository.getProtocol(pid);
                CachedJournal journal = new CachedJournal();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.m_exporter.export(pm, (Journal)journal, (OutputStream)os);
                os.close();
                if (journal.hasErrors()) {
                    logger.severe("Errors detected when exporting protocol '" + pid + "' to monitorable description");
                } else {
                    ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                    ret = MonitorModelUtil.deserialize((InputStream)is);
                    ((InputStream)is).close();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to obtain monitorable description for protocol '" + pid + "'", e);
            }
            if (ret != null) {
                this.getDescriptionCache().setDescription(pid, ret);
            }
        }
        return ret;
    }

    protected DescriptionCache getDescriptionCache() {
        return this.m_descriptionCache;
    }

    protected void setDescriptionCache(DescriptionCache dc) {
        this.m_descriptionCache = dc;
    }
}

